/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import net.geforcemods.securitycraft.api.IDisguisable;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.INameSetter;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasscodeProtected;
import net.geforcemods.securitycraft.api.LinkableBlockEntity;
import net.geforcemods.securitycraft.compat.IOverlayDisplay;
import net.geforcemods.securitycraft.misc.SaltData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class SpecialDoorBlock
extends DoorBlock
implements EntityBlock,
IDisguisable,
IOverlayDisplay {
    protected SpecialDoorBlock(BlockBehaviour.Properties properties, BlockSetType blockSetType) {
        super(properties, blockSetType);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        BlockState disguisedState = IDisguisable.getDisguisedStateOrDefault(state, level, pos);
        if (disguisedState.m_60734_() != this) {
            return disguisedState.m_60651_(level, pos, ctx);
        }
        return super.m_5940_(state, level, pos, ctx);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        BlockState disguisedState = IDisguisable.getDisguisedStateOrDefault(state, level, pos);
        if (disguisedState.m_60734_() != this) {
            if (((Boolean)state.m_61143_((Property)f_52727_)).booleanValue()) {
                return Shapes.m_83040_();
            }
            return disguisedState.m_60651_(level, pos, ctx);
        }
        return super.m_5940_(state, level, pos, ctx);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.m_6402_(level, pos, state, placer, stack);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof IOwnable) {
            IOwnable lowerBe = (IOwnable)blockEntity;
            blockEntity = level.m_7702_(pos.m_7494_());
            if (blockEntity instanceof IOwnable) {
                IOwnable upperBe = (IOwnable)blockEntity;
                if (placer instanceof Player) {
                    Player player = (Player)placer;
                    lowerBe.setOwner(player.m_36316_().getId().toString(), player.m_7755_().getString());
                    upperBe.setOwner(player.m_36316_().getId().toString(), player.m_7755_().getString());
                }
                if (lowerBe instanceof LinkableBlockEntity) {
                    LinkableBlockEntity linkable1 = (LinkableBlockEntity)lowerBe;
                    if (upperBe instanceof LinkableBlockEntity) {
                        LinkableBlockEntity linkable2 = (LinkableBlockEntity)upperBe;
                        LinkableBlockEntity.link(linkable1, linkable2);
                    }
                }
                if (stack.m_41788_() && lowerBe instanceof INameSetter) {
                    INameSetter nameSetter1 = (INameSetter)((Object)lowerBe);
                    if (upperBe instanceof INameSetter) {
                        INameSetter nameSetter2 = (INameSetter)((Object)upperBe);
                        nameSetter1.setCustomName(stack.m_41786_());
                        nameSetter2.setCustomName(stack.m_41786_());
                    }
                }
            }
        }
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos upperPos, RandomSource rand) {
        BlockState lowerState;
        BlockPos lowerPos;
        BlockState upperState = level.m_8055_(upperPos);
        if (!((Boolean)upperState.m_61143_((Property)DoorBlock.f_52727_)).booleanValue()) {
            return;
        }
        if (upperState.m_61143_((Property)DoorBlock.f_52730_) == DoubleBlockHalf.LOWER) {
            lowerPos = upperPos;
            lowerState = upperState;
            upperPos = upperPos.m_7494_();
            upperState = level.m_8055_(upperPos);
        } else {
            lowerPos = upperPos.m_7495_();
            lowerState = level.m_8055_(lowerPos);
        }
        level.m_46597_(upperPos, (BlockState)upperState.m_61124_((Property)DoorBlock.f_52727_, (Comparable)Boolean.valueOf(false)));
        level.m_46597_(lowerPos, (BlockState)lowerState.m_61124_((Property)DoorBlock.f_52727_, (Comparable)Boolean.valueOf(false)));
        this.m_245755_(null, (Level)level, upperPos, false);
        level.m_142346_(null, GameEvent.f_157793_, upperPos);
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity;
        if (player.m_7500_() && (blockEntity = level.m_7702_(pos)) instanceof IModuleInventory) {
            IModuleInventory inv = (IModuleInventory)blockEntity;
            inv.getInventory().clear();
        }
        super.m_5707_(level, pos, state, player);
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockState state = super.m_5573_(ctx);
        return state == null ? null : (BlockState)((BlockState)state.m_61124_((Property)f_52727_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_52729_, (Comparable)Boolean.valueOf(false));
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity be = level.m_7702_(pos);
            if (be instanceof IModuleInventory) {
                IModuleInventory inv = (IModuleInventory)be;
                if (state.m_61143_((Property)f_52730_) == DoubleBlockHalf.LOWER) {
                    inv.dropAllModules();
                }
            }
            if (be instanceof IPasscodeProtected) {
                IPasscodeProtected passcodeProtected = (IPasscodeProtected)be;
                SaltData.removeSalt(passcodeProtected.getSaltKey());
            }
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public boolean m_8133_(BlockState state, Level level, BlockPos pos, int id, int param) {
        BlockEntity be = level.m_7702_(pos);
        return be != null && be.m_7531_(id, param);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return this.getDisguisedStack(level, pos);
    }

    @Override
    public ItemStack getDefaultStack() {
        return new ItemStack((ItemLike)this.getDoorItem());
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        BlockState disguisedState = IDisguisable.getDisguisedStateOrDefault(state, level, pos);
        if (disguisedState.m_60734_() != this) {
            return disguisedState.getLightEmission(level, pos);
        }
        return super.getLightEmission(state, level, pos);
    }

    public SoundType getSoundType(BlockState state, LevelReader level, BlockPos pos, Entity entity) {
        BlockState disguisedState = IDisguisable.getDisguisedStateOrDefault(state, (BlockGetter)level, pos);
        if (disguisedState.m_60734_() != this) {
            return disguisedState.getSoundType(level, pos, entity);
        }
        return super.getSoundType(state, level, pos, entity);
    }

    public float m_7749_(BlockState state, BlockGetter level, BlockPos pos) {
        BlockState disguisedState = IDisguisable.getDisguisedStateOrDefault(state, level, pos);
        if (disguisedState.m_60734_() != this) {
            return disguisedState.m_60792_(level, pos);
        }
        return super.m_7749_(state, level, pos);
    }

    public int m_7753_(BlockState state, BlockGetter level, BlockPos pos) {
        BlockState disguisedState = IDisguisable.getDisguisedStateOrDefault(state, level, pos);
        if (disguisedState.m_60734_() != this) {
            return disguisedState.m_60739_(level, pos);
        }
        return super.m_7753_(state, level, pos);
    }

    public BlockState getAppearance(BlockState state, BlockAndTintGetter level, BlockPos pos, Direction side, BlockState queryState, BlockPos queryPos) {
        return IDisguisable.getDisguisedStateOrDefault(state, (BlockGetter)level, pos);
    }

    @Override
    public ItemStack getDisplayStack(Level level, BlockState state, BlockPos pos) {
        return this.getDisguisedStack((BlockGetter)level, pos);
    }

    @Override
    public boolean shouldShowSCInfo(Level level, BlockState state, BlockPos pos) {
        return this.getDisguisedStack((BlockGetter)level, pos).m_41720_() == this.m_5456_();
    }

    public abstract Item getDoorItem();
}

