/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import java.util.ArrayList;
import java.util.List;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.api.ILinkedAction;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.LinkableBlockEntity;
import net.geforcemods.securitycraft.inventory.DisguiseModuleMenu;
import net.geforcemods.securitycraft.inventory.ModuleItemContainer;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraftforge.network.NetworkHooks;

public class ModuleItem
extends Item {
    private static final MutableComponent MODIFIABLE = Component.m_237115_((String)"tooltip.securitycraft:module.modifiable").m_6270_(Utils.GRAY_STYLE);
    private static final MutableComponent NOT_MODIFIABLE = Component.m_237115_((String)"tooltip.securitycraft:module.notModifiable").m_6270_(Utils.GRAY_STYLE);
    public static final int MAX_PLAYERS = 50;
    private final ModuleType module;
    private final boolean containsCustomData;
    private final boolean canBeCustomized;

    public ModuleItem(Item.Properties properties, ModuleType module, boolean containsCustomData) {
        this(properties, module, containsCustomData, false);
    }

    public ModuleItem(Item.Properties properties, ModuleType module, boolean containsCustomData, boolean canBeCustomized) {
        super(properties);
        this.module = module;
        this.containsCustomData = containsCustomData;
        this.canBeCustomized = canBeCustomized;
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        BlockEntity blockEntity = ctx.m_43725_().m_7702_(ctx.m_8083_());
        if (blockEntity instanceof IModuleInventory) {
            IOwnable ownable;
            IModuleInventory inv = (IModuleInventory)blockEntity;
            ItemStack stack = ctx.m_43722_();
            ModuleType type = ((ModuleItem)stack.m_41720_()).getModuleType();
            if (inv instanceof IOwnable && !(ownable = (IOwnable)((Object)inv)).isOwnedBy((Entity)ctx.m_43723_())) {
                return InteractionResult.PASS;
            }
            if (inv.acceptsModule(type) && !inv.hasModule(type)) {
                inv.insertModule(stack, false);
                if (inv instanceof LinkableBlockEntity) {
                    LinkableBlockEntity linkable = (LinkableBlockEntity)inv;
                    linkable.propagate((ILinkedAction)new ILinkedAction.ModuleInserted(stack, (ModuleItem)stack.m_41720_(), false), linkable);
                }
                if (!ctx.m_43723_().m_7500_()) {
                    stack.m_41774_(1);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, final InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (this.canBeCustomized()) {
            if (this.module == ModuleType.ALLOWLIST || this.module == ModuleType.DENYLIST) {
                if (level.f_46443_) {
                    ClientHandler.displayEditModuleScreen(stack);
                }
                return InteractionResultHolder.m_19096_((Object)stack);
            }
            if (this.module == ModuleType.DISGUISE) {
                if (!level.f_46443_) {
                    NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new MenuProvider(){

                        public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
                            return new DisguiseModuleMenu(windowId, inv, new ModuleItemContainer(player.m_21120_(hand)));
                        }

                        public Component m_5446_() {
                            return Component.m_237115_((String)ModuleItem.this.m_5524_());
                        }
                    });
                }
                return InteractionResultHolder.m_19096_((Object)stack);
            }
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> list, TooltipFlag flag) {
        Block addon;
        if (this.containsCustomData || this.canBeCustomized()) {
            list.add((Component)MODIFIABLE);
        } else {
            list.add((Component)NOT_MODIFIABLE);
        }
        if (this.canBeCustomized() && (addon = ModuleItem.getBlockAddon(stack)) != null) {
            list.add((Component)Utils.localize("tooltip.securitycraft:module.itemAddons.added", Utils.localize(addon.m_7705_(), new Object[0])).m_6270_(Utils.GRAY_STYLE));
        }
        if (this.containsCustomData) {
            CompoundTag tag;
            boolean affectsEveryone = false;
            int playerCount = 0;
            int teamCount = 0;
            if (stack.m_41782_() && !(affectsEveryone = (tag = stack.m_41783_()).m_128471_("affectEveryone"))) {
                playerCount = ModuleItem.getPlayersFromModule(stack).size();
                teamCount = tag.m_128437_("ListedTeams", 8).size();
            }
            if (affectsEveryone) {
                list.add((Component)Utils.localize("tooltip.securitycraft.component.list_module_data.affects_everyone", new Object[0]).m_6270_(Utils.GRAY_STYLE));
            } else {
                list.add((Component)Utils.localize("tooltip.securitycraft.component.list_module_data.added_players", playerCount).m_6270_(Utils.GRAY_STYLE));
                list.add((Component)Utils.localize("tooltip.securitycraft.component.list_module_data.added_teams", teamCount).m_6270_(Utils.GRAY_STYLE));
            }
        }
    }

    public ModuleType getModuleType() {
        return this.module;
    }

    public static Block getBlockAddon(ItemStack stack) {
        Item item;
        if (!stack.m_41782_()) {
            return null;
        }
        ListTag items = stack.m_41783_().m_128437_("ItemInventory", 10);
        if (items != null && !items.isEmpty() && (item = ItemStack.m_41712_((CompoundTag)items.m_128728_(0)).m_41720_()) instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            return blockItem.m_40614_();
        }
        return null;
    }

    public boolean canBeCustomized() {
        return this.canBeCustomized;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean doesModuleHaveTeamOf(ItemStack module, String name, Level level) {
        PlayerTeam team = level.m_6188_().m_83500_(name);
        if (team == null) return false;
        if (!module.m_41784_().m_128437_("ListedTeams", 8).stream().filter(StringTag.class::isInstance).map(tag -> ((StringTag)tag).m_7916_()).anyMatch(team.m_5758_()::equals)) return false;
        return true;
    }

    public static List<String> getPlayersFromModule(ItemStack stack) {
        ArrayList<String> list = new ArrayList<String>();
        if (stack.m_41720_() instanceof ModuleItem && stack.m_41782_()) {
            for (int i = 1; i <= 50; ++i) {
                if (stack.m_41783_().m_128461_("Player" + i) == null || stack.m_41783_().m_128461_("Player" + i).isEmpty()) continue;
                list.add(stack.m_41783_().m_128461_("Player" + i).toLowerCase());
            }
        }
        return list;
    }
}

