/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import java.util.function.Supplier;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.items.BriefcaseItem;
import net.geforcemods.securitycraft.util.PasscodeUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class CheckBriefcasePasscode {
    private String passcode;

    public CheckBriefcasePasscode() {
    }

    public CheckBriefcasePasscode(String passcode) {
        this.passcode = PasscodeUtils.hashPasscodeWithoutSalt(passcode);
    }

    public CheckBriefcasePasscode(FriendlyByteBuf buf) {
        this.passcode = buf.m_130277_();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130070_(this.passcode);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ServerPlayer player = ctx.get().getSender();
        ItemStack briefcase = PlayerUtils.getItemStackFromAnyHand((Player)player, (Item)SCContent.BRIEFCASE.get());
        if (!briefcase.m_41619_()) {
            if (PasscodeUtils.isOnCooldown((Player)player)) {
                PlayerUtils.sendMessageToPlayer((Player)player, Component.m_237113_((String)"SecurityCraft"), Component.m_237115_((String)"messages.securitycraft:passcodeProtected.onCooldown"), ChatFormatting.RED);
                if (((Boolean)ConfigHandler.SERVER.passcodeSpamLogWarningEnabled.get()).booleanValue()) {
                    SecurityCraft.LOGGER.warn(String.format((String)ConfigHandler.SERVER.passcodeSpamLogWarning.get(), player.m_36316_().getName(), ((Item)SCContent.BRIEFCASE.get()).m_41466_().getString(), GlobalPos.m_122643_((ResourceKey)player.m_9236_().m_46472_(), (BlockPos)player.m_20183_())));
                }
                return;
            }
            CompoundTag tag = briefcase.m_41784_();
            String tagCode = tag.m_128461_("passcode");
            if (tagCode.length() == 4) {
                BriefcaseItem.hashAndSetPasscode(tag, PasscodeUtils.hashPasscodeWithoutSalt(tagCode), p -> BriefcaseItem.checkPasscode(player, briefcase, this.passcode, PasscodeUtils.bytesToString(p), tag));
            } else {
                BriefcaseItem.checkPasscode(player, briefcase, this.passcode, tagCode, tag);
            }
        }
    }
}

