/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import java.util.function.Supplier;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.items.BriefcaseItem;
import net.geforcemods.securitycraft.network.client.OpenScreen;
import net.geforcemods.securitycraft.util.PasscodeUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class SetBriefcasePasscodeAndOwner {
    private String passcode;

    public SetBriefcasePasscodeAndOwner() {
    }

    public SetBriefcasePasscodeAndOwner(String passcode) {
        this.passcode = passcode.isEmpty() ? passcode : PasscodeUtils.hashPasscodeWithoutSalt(passcode);
    }

    public SetBriefcasePasscodeAndOwner(FriendlyByteBuf buf) {
        this.passcode = buf.m_130277_();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130070_(this.passcode);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ServerPlayer player = ctx.get().getSender();
        ItemStack stack = PlayerUtils.getItemStackFromAnyHand((Player)player, (Item)SCContent.BRIEFCASE.get());
        if (!stack.m_41619_()) {
            CompoundTag tag = stack.m_41784_();
            if (!tag.m_128441_("owner")) {
                tag.m_128359_("owner", player.m_7755_().getString());
                tag.m_128359_("ownerUUID", player.m_20148_().toString());
            }
            if (!this.passcode.isEmpty() && !tag.m_128441_("passcode")) {
                BriefcaseItem.hashAndSetPasscode(tag, this.passcode, arg_0 -> SetBriefcasePasscodeAndOwner.lambda$handle$1((Player)player, arg_0));
            }
        }
    }

    private static /* synthetic */ void lambda$handle$1(Player player, byte[] p) {
        SecurityCraft.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new OpenScreen(OpenScreen.DataType.CHECK_PASSCODE_FOR_BRIEFCASE));
    }
}

