/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.renderers;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.blockentities.RetinalScannerBlockEntity;
import net.geforcemods.securitycraft.blocks.RetinalScannerBlock;
import net.geforcemods.securitycraft.items.ModuleItem;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class RetinalScannerRenderer
implements BlockEntityRenderer<RetinalScannerBlockEntity> {
    private static final float CORRECT_FACTOR = 0.0018181818f;

    public RetinalScannerRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(RetinalScannerBlockEntity be, float partialTicks, PoseStack pose, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        if (ClientHandler.DISGUISED_BLOCK_RENDER_DELEGATE.tryRenderDelegate(be, partialTicks, pose, buffer, combinedLight, combinedOverlay)) {
            return;
        }
        Direction direction = (Direction)be.m_58900_().m_61143_((Property)RetinalScannerBlock.FACING);
        if (direction != null) {
            if (be.isModuleEnabled(ModuleType.DISGUISE) && ModuleItem.getBlockAddon(be.getModule(ModuleType.DISGUISE)) != null) {
                return;
            }
            pose.m_85836_();
            switch (direction) {
                case NORTH: {
                    pose.m_252880_(0.25f, 0.0625f, 0.0f);
                    break;
                }
                case SOUTH: {
                    pose.m_252880_(0.75f, 0.0625f, 1.0f);
                    pose.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                    break;
                }
                case WEST: {
                    pose.m_252880_(0.0f, 0.0625f, 0.75f);
                    pose.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                    break;
                }
                case EAST: {
                    pose.m_252880_(1.0f, 0.0625f, 0.25f);
                    pose.m_252781_(Axis.f_252436_.m_252977_(270.0f));
                    break;
                }
            }
            pose.m_85841_(-1.0f, -1.0f, 1.0f);
            VertexConsumer vertexBuilder = buffer.m_6299_(RenderType.m_110452_((ResourceLocation)RetinalScannerRenderer.getSkinTexture(be.getPlayerProfile())));
            Matrix4f positionMatrix = pose.m_85850_().m_252922_();
            Matrix3f normalMatrix = pose.m_85850_().m_252943_();
            Vec3i normalVector = direction.m_122436_();
            BlockPos offsetPos = be.m_58899_().m_121945_(direction);
            combinedLight = LightTexture.m_109885_((int)be.m_58904_().m_45517_(LightLayer.BLOCK, offsetPos), (int)be.m_58904_().m_45517_(LightLayer.SKY, offsetPos));
            vertexBuilder.m_252986_(positionMatrix, 0.0018181818f, 0.0027272727f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.125f, 0.25f).m_86008_(OverlayTexture.f_118083_).m_85969_(combinedLight).m_252939_(normalMatrix, (float)normalVector.m_123341_(), (float)normalVector.m_123342_(), (float)normalVector.m_123343_()).m_5752_();
            vertexBuilder.m_252986_(positionMatrix, 0.0018181818f, -0.5009091f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.125f, 0.125f).m_86008_(OverlayTexture.f_118083_).m_85969_(combinedLight).m_252939_(normalMatrix, (float)normalVector.m_123341_(), (float)normalVector.m_123342_(), (float)normalVector.m_123343_()).m_5752_();
            vertexBuilder.m_252986_(positionMatrix, -0.5018182f, -0.5009091f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.25f, 0.125f).m_86008_(OverlayTexture.f_118083_).m_85969_(combinedLight).m_252939_(normalMatrix, (float)normalVector.m_123341_(), (float)normalVector.m_123342_(), (float)normalVector.m_123343_()).m_5752_();
            vertexBuilder.m_252986_(positionMatrix, -0.5018182f, 0.0027272727f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.25f, 0.25f).m_86008_(OverlayTexture.f_118083_).m_85969_(combinedLight).m_252939_(normalMatrix, (float)normalVector.m_123341_(), (float)normalVector.m_123342_(), (float)normalVector.m_123343_()).m_5752_();
            vertexBuilder.m_252986_(positionMatrix, 0.0018181818f, 0.0027272727f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.625f, 0.25f).m_86008_(OverlayTexture.f_118083_).m_85969_(combinedLight).m_252939_(normalMatrix, (float)normalVector.m_123341_(), (float)normalVector.m_123342_(), (float)normalVector.m_123343_()).m_5752_();
            vertexBuilder.m_252986_(positionMatrix, 0.0018181818f, -0.5009091f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.625f, 0.125f).m_86008_(OverlayTexture.f_118083_).m_85969_(combinedLight).m_252939_(normalMatrix, (float)normalVector.m_123341_(), (float)normalVector.m_123342_(), (float)normalVector.m_123343_()).m_5752_();
            vertexBuilder.m_252986_(positionMatrix, -0.5018182f, -0.5009091f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.75f, 0.125f).m_86008_(OverlayTexture.f_118083_).m_85969_(combinedLight).m_252939_(normalMatrix, (float)normalVector.m_123341_(), (float)normalVector.m_123342_(), (float)normalVector.m_123343_()).m_5752_();
            vertexBuilder.m_252986_(positionMatrix, -0.5018182f, 0.0027272727f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.75f, 0.25f).m_86008_(OverlayTexture.f_118083_).m_85969_(combinedLight).m_252939_(normalMatrix, (float)normalVector.m_123341_(), (float)normalVector.m_123342_(), (float)normalVector.m_123343_()).m_5752_();
            pose.m_85849_();
        }
    }

    private static ResourceLocation getSkinTexture(@Nullable GameProfile profile) {
        if (((Boolean)ConfigHandler.SERVER.retinalScannerFace.get()).booleanValue() && profile != null) {
            Minecraft minecraft = Minecraft.m_91087_();
            Map map = minecraft.m_91109_().m_118815_(profile);
            return map.containsKey(MinecraftProfileTexture.Type.SKIN) ? minecraft.m_91109_().m_118825_((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN) : DefaultPlayerSkin.m_118627_((UUID)UUIDUtil.m_235875_((GameProfile)profile));
        }
        return DefaultPlayerSkin.m_118626_();
    }
}

