/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.renderers;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.blockentities.SonicSecuritySystemBlockEntity;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.models.SonicSecuritySystemModel;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

public class SonicSecuritySystemRenderer
implements BlockEntityRenderer<SonicSecuritySystemBlockEntity> {
    private static final Quaternionf POSITIVE_X_180 = Axis.f_252529_.m_252977_(180.0f);
    private static final ResourceLocation TEXTURE = new ResourceLocation("securitycraft:textures/block/sonic_security_system.png");
    private static final Component RECORDING_TEXT = Utils.localize("gui.securitycraft:sonic_security_system.recording", new Object[0]);
    private static final Component LISTENING_TEXT = Utils.localize("gui.securitycraft:sonic_security_system.listening", new Object[0]);
    private final SonicSecuritySystemModel model;

    public SonicSecuritySystemRenderer(BlockEntityRendererProvider.Context ctx) {
        this.model = new SonicSecuritySystemModel(ctx.m_173582_(ClientHandler.SONIC_SECURITY_SYSTEM_LOCATION));
    }

    public void render(SonicSecuritySystemBlockEntity be, float partialTicks, PoseStack pose, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        boolean recording = be.isRecording();
        ClientHandler.DISGUISED_BLOCK_RENDER_DELEGATE.tryRenderDelegate(be, partialTicks, pose, buffer, packedLight, packedOverlay);
        pose.m_85837_(0.5, 1.5, 0.5);
        if (recording || be.isListening() && !be.isShutDown()) {
            Component text = recording ? RECORDING_TEXT : LISTENING_TEXT;
            float f1 = Minecraft.m_91087_().f_91066_.m_92141_(0.25f);
            int j = (int)(f1 * 255.0f) << 24;
            Font fontRenderer = Minecraft.m_91087_().f_91062_;
            float halfWidth = -fontRenderer.m_92852_((FormattedText)text) / 2;
            pose.m_85836_();
            pose.m_252781_(Minecraft.m_91087_().m_91290_().m_253208_());
            pose.m_85841_(-0.025f, -0.025f, 0.025f);
            Matrix4f positionMatrix = pose.m_85850_().m_252922_();
            RenderSystem.disableCull();
            fontRenderer.m_272077_(text, halfWidth, 0.0f, 0xFFFFFF, false, positionMatrix, buffer, Font.DisplayMode.SEE_THROUGH, j, packedLight);
            fontRenderer.m_272077_(text, halfWidth, 0.0f, -1, false, positionMatrix, buffer, Font.DisplayMode.NORMAL, 0, packedLight);
            RenderSystem.enableCull();
            pose.m_85849_();
        }
        if (!be.isModuleEnabled(ModuleType.DISGUISE)) {
            pose.m_252781_(POSITIVE_X_180);
            this.model.setRadarRotation(Mth.m_14179_((float)partialTicks, (float)be.getOriginalRadarRotationDegrees(), (float)be.getRadarRotationDegrees()));
            this.model.m_7695_(pose, buffer.m_6299_(RenderType.m_110446_((ResourceLocation)TEXTURE)), packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }
}

