/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen.components;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.geforcemods.securitycraft.util.IToggleableEntries;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraftforge.client.gui.widget.ScrollPanel;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

public class ToggleScrollList<T>
extends ScrollPanel {
    private static final ResourceLocation BEACON_GUI = new ResourceLocation("textures/gui/container/beacon.png");
    private static final int SLOT_HEIGHT = 12;
    private final int listLength;
    private final List<T> orderedFilterList;
    private final Map<T, Component> typeNames = new HashMap<T, Component>();
    private final Minecraft mc;
    private final IToggleableEntries<T> be;
    private final boolean hasSmartModule;
    private final boolean hasRedstoneModule;

    public ToggleScrollList(IToggleableEntries<T> be, boolean hasSmartModule, boolean hasRedstoneModule, Minecraft mc, int width, int height, int top, int left) {
        super(mc, width, height, top, left);
        this.mc = mc;
        this.be = be;
        this.hasSmartModule = hasSmartModule;
        this.hasRedstoneModule = hasRedstoneModule;
        this.orderedFilterList = new ArrayList<T>(be.getFilters().keySet());
        this.orderedFilterList.sort((e1, e2) -> {
            if (e1 == be.getDefaultType()) {
                return 1;
            }
            if (e2 == be.getDefaultType()) {
                return -1;
            }
            return Utils.localize(e1.toString(), new Object[0]).getString().compareTo(Utils.localize(e2.toString(), new Object[0]).getString());
        });
        this.listLength = this.orderedFilterList.size();
    }

    protected int getContentHeight() {
        Objects.requireNonNull(this.mc.f_91062_);
        int height = this.listLength * (9 + 3);
        if (height < this.bottom - this.top - 4) {
            height = this.bottom - this.top - 4;
        }
        return height;
    }

    protected boolean clickPanel(double mouseX, double mouseY, int button) {
        double relativeMouseY;
        int slotIndex;
        if (this.hasSmartModule && (slotIndex = (int)(mouseY + (double)(this.border / 2)) / 12) >= 0 && slotIndex < this.listLength && (relativeMouseY = this.mc.f_91067_.m_91594_() * (double)this.mc.m_91268_().m_85446_() / (double)this.mc.m_91268_().m_85444_()) >= (double)this.top && relativeMouseY <= (double)this.bottom) {
            this.be.toggleFilter(this.orderedFilterList.get(slotIndex));
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
            return true;
        }
        return false;
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int comparatorOutput;
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        int baseY = this.top + this.border - (int)this.scrollDistance;
        int mouseListY = (int)((float)(mouseY - this.top) + this.scrollDistance - (float)(this.border / 2));
        int slotIndex = mouseListY / 12;
        int slotBottom = baseY + (slotIndex + 1) * 12;
        if (this.hasRedstoneModule && mouseX >= this.left && mouseX <= this.right - 7 && slotIndex >= 0 && mouseListY >= 0 && slotIndex < this.listLength && mouseY >= this.top && mouseY <= this.bottom && (comparatorOutput = this.be.getComparatorOutputFunction().applyAsInt(this.orderedFilterList.get(slotIndex))) > 0) {
            guiGraphics.m_280557_(this.mc.f_91062_, (Component)Component.m_237110_((String)"gui.securitycraft:toggleList.comparatorOutput", (Object[])new Object[]{comparatorOutput}), this.right - 8, slotBottom);
        }
    }

    protected void drawPanel(GuiGraphics guiGraphics, int entryRight, int relativeY, Tesselator tess, int mouseX, int mouseY) {
        Font font = Minecraft.m_91087_().f_91062_;
        int baseY = this.top + this.border - (int)this.scrollDistance;
        int slotBuffer = 8;
        int mouseListY = (int)((float)(mouseY - this.top) + this.scrollDistance - (float)(this.border / 2));
        int slotIndex = mouseListY / 12;
        if (this.hasSmartModule && mouseX >= this.left && mouseX <= this.right - 7 && slotIndex >= 0 && mouseListY >= 0 && slotIndex < this.listLength && mouseY >= this.top && mouseY <= this.bottom) {
            int min = this.left;
            int max = entryRight - 6;
            int slotTop = baseY + slotIndex * 12;
            BufferBuilder bufferBuilder = tess.m_85915_();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            bufferBuilder.m_5483_((double)min, (double)(slotTop + slotBuffer + 2), 0.0).m_6122_(128, 128, 128, 255).m_5752_();
            bufferBuilder.m_5483_((double)max, (double)(slotTop + slotBuffer + 2), 0.0).m_6122_(128, 128, 128, 255).m_5752_();
            bufferBuilder.m_5483_((double)max, (double)(slotTop - 2), 0.0).m_6122_(128, 128, 128, 255).m_5752_();
            bufferBuilder.m_5483_((double)min, (double)(slotTop - 2), 0.0).m_6122_(128, 128, 128, 255).m_5752_();
            bufferBuilder.m_5483_((double)(min + 1), (double)(slotTop + slotBuffer + 1), 0.0).m_6122_(0, 0, 0, 255).m_5752_();
            bufferBuilder.m_5483_((double)(max - 1), (double)(slotTop + slotBuffer + 1), 0.0).m_6122_(0, 0, 0, 255).m_5752_();
            bufferBuilder.m_5483_((double)(max - 1), (double)(slotTop - 1), 0.0).m_6122_(0, 0, 0, 255).m_5752_();
            bufferBuilder.m_5483_((double)(min + 1), (double)(slotTop - 1), 0.0).m_6122_(0, 0, 0, 255).m_5752_();
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
            RenderSystem.disableBlend();
        }
        int i = 0;
        for (T type : this.orderedFilterList) {
            Component name = this.typeNames.computeIfAbsent(type, t -> Utils.localize(t == this.be.getDefaultType() ? this.be.getDefaultTypeName() : t.toString(), new Object[0]));
            int yStart = relativeY + 12 * i;
            guiGraphics.m_280614_(font, name, this.left + this.width / 2 - font.m_92852_((FormattedText)name) / 2, yStart, 0xC6C6C6, false);
            guiGraphics.m_280411_(BEACON_GUI, this.left, yStart - 3, 14, 14, this.be.getFilter(type) ? 88.0f : 110.0f, 219.0f, 21, 22, 256, 256);
            ++i;
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        boolean returnValue = super.m_6375_(mouseX, mouseY, button);
        int barLeft = (Integer)ObfuscationReflectionHelper.getPrivateValue(ScrollPanel.class, (Object)((Object)this), (String)"barLeft");
        int barWidth = (Integer)ObfuscationReflectionHelper.getPrivateValue(ScrollPanel.class, (Object)((Object)this), (String)"barWidth");
        boolean previousScrolling = (Boolean)ObfuscationReflectionHelper.getPrivateValue(ScrollPanel.class, (Object)((Object)this), (String)"scrolling");
        if (previousScrolling) {
            boolean scrolling;
            boolean bl = scrolling = button == 0 && mouseX >= (double)barLeft && mouseX < (double)(barLeft + barWidth) && mouseY >= (double)this.top && mouseY <= (double)this.bottom;
            if (!scrolling) {
                ObfuscationReflectionHelper.setPrivateValue(ScrollPanel.class, (Object)((Object)this), (Object)scrolling, (String)"scrolling");
            }
            if (!this.m_5953_(mouseX, mouseY) || !scrolling) {
                return this.clickPanel(mouseX - (double)this.left, mouseY - (double)this.top + (double)((int)this.scrollDistance) - (double)this.border, button);
            }
        }
        return previousScrolling || !previousScrolling && returnValue;
    }

    public NarratableEntry.NarrationPriority m_142684_() {
        return NarratableEntry.NarrationPriority.NONE;
    }

    public void m_142291_(NarrationElementOutput narrationElementOutput) {
    }
}

