/*
 * Decompiled with CFR 0.152.
 */
package net.arphex.configuration;

import net.minecraftforge.common.ForgeConfigSpec;

public class ConfigurationSettingsConfiguration {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.ConfigValue<Boolean> DWELLERS_REQUIRE_WEATHER;
    public static final ForgeConfigSpec.ConfigValue<Boolean> SPAWN_DWELLERS_NATURALLY;
    public static final ForgeConfigSpec.ConfigValue<Double> DWELLERS_FREQUENCY;
    public static final ForgeConfigSpec.ConfigValue<Boolean> DWELLERS_INCLUSION;
    public static final ForgeConfigSpec.ConfigValue<Double> NON_BOSS_SPAWNRATE;
    public static final ForgeConfigSpec.ConfigValue<Double> RANDOM_SYSTEM_SPAWNS;
    public static final ForgeConfigSpec.ConfigValue<Boolean> ALL_ENTITY_INCLUSION;
    public static final ForgeConfigSpec.ConfigValue<Double> MAX_ANTS;
    public static final ForgeConfigSpec.ConfigValue<Boolean> CRAWLING_ONLY;
    public static final ForgeConfigSpec.ConfigValue<Boolean> DISABLE_TORMENTOR;
    public static final ForgeConfigSpec.ConfigValue<Boolean> ANY_DIMENSION;
    public static final ForgeConfigSpec.ConfigValue<Boolean> DWELLER_HEALTH;
    public static final ForgeConfigSpec.ConfigValue<Double> OVERALL_DIFFICULTY;
    public static final ForgeConfigSpec.ConfigValue<Double> OVERALL_DIFFICULTY_LOWER;
    public static final ForgeConfigSpec.ConfigValue<Double> TORMENTOR_MAX_HEALTH;
    public static final ForgeConfigSpec.ConfigValue<Double> TORMENTOR_HIT_SPEED;
    public static final ForgeConfigSpec.ConfigValue<Boolean> WELCOME_MESSAGE;
    public static final ForgeConfigSpec.ConfigValue<Boolean> STRUCTURE_GENERATION;
    public static final ForgeConfigSpec.ConfigValue<Boolean> SPECIAL_TORMENTOR_RENDERING;

    static {
        BUILDER.push("Spawning");
        DWELLERS_REQUIRE_WEATHER = BUILDER.comment("This controls whether all boss versions will require specific weather conditions to spawn. Without this, they will appear much more frequently. ").define("Bosses require weather?", true);
        SPAWN_DWELLERS_NATURALLY = BUILDER.comment("Do you want the boss and clone versions to spawn naturally, or only from summoning structures?").define("Boss natural spawning", true);
        DWELLERS_FREQUENCY = BUILDER.comment("Bosses and variant spawns are rare by default. 1=twice as common. 2=default rarity. 3=twice as rare. 4=three times rarer. Avoid decimal and negative numbers.").define("Boss rarity", (Object)2.0);
        DWELLERS_INCLUSION = BUILDER.comment("This controls whether the stalker bosses (spider moth, scorpioid bloodluster, draconic voidlasher, tormentor) are included in general. Set to false if you only want the other mobs, and the bosses will become unable to be spawned in any way.").define("Boss inclusion", true);
        NON_BOSS_SPAWNRATE = BUILDER.comment("Controls the spawnrate of ALL non-boss mobs in this mod, including minibosses and all regular arthropods. Default multiplier value is 8. To double ArPhEx spawnrates, set it to 4. Lower values = more spawns (minimum value is 1). No maximum rarity. Avoid decimal and negative numbers.").define("Non-boss global spawnrates", (Object)8.0);
        RANDOM_SYSTEM_SPAWNS = BUILDER.comment("ArPhEx has an additional spawning system that gives a 1 in (10) chance to spawn a random ArPhEx mob each time the natural spawn triggers. This system allows ArPhEx mobs to spawn in non-vanilla overworld biomes, while still accounting for mob rarity. Default number is 10, meaning it has a 1 in 10 chance to spawn each time. Setting it to 0 disables the additional spawning system entirely. Avoid decimal and negative numbers.").define("Random-system spawn rates", (Object)10.0);
        ALL_ENTITY_INCLUSION = BUILDER.define("All entities enabled/disabled", true);
        MAX_ANTS = BUILDER.comment("Maximum colony tamed ants per player (furthest ants despawn, 20 default)").define("Max tamed ants per player", (Object)20.0);
        CRAWLING_ONLY = BUILDER.comment("Option to limit all natural ArPhEx spawning to the Crawling dimension").define("Crawling-restrict all mobs", false);
        DISABLE_TORMENTOR = BUILDER.comment("Specifically disables the Tormentor boss entirely. It will be unable to be spawned in any form if this is enabled.").define("Disable Tormentor", false);
        ANY_DIMENSION = BUILDER.comment("Disabled by default. If enabled, most mobs will become able to spawn in any dimension, including dimensions from other mods - may cause issues with some mod dimensions.").define("Spawn in other dimensions", false);
        BUILDER.pop();
        BUILDER.push("Difficulty");
        DWELLER_HEALTH = BUILDER.comment("By default, the stalker bosses have hundreds of health points. Choose true to decrease their maximum to just 60 health. Avoid decimal and negative numbers.").define("Boss easy-mode", false);
        OVERALL_DIFFICULTY = BUILDER.comment("Can increase damage for most ArPhEx mob, miniboss, and boss attacks. Affects their ranged projectiles too. Default value is 0. Positive values will give that level of strength to all arphex mobs. Avoid decimal and negative numbers, upper limit is 256. Does not affect Tormentor fight significantly.").define("Extra Difficulty Control", (Object)0.0);
        OVERALL_DIFFICULTY_LOWER = BUILDER.comment("Can lower damage for most ArPhEx mob, miniboss, and boss attacks. Affects their ranged projectiles too. Default value is 0. Positive values will give that level of weakness to all arphex mobs. Avoid decimal and negative numbers, upper limit is 256. Does not affect Tormentor fight significantly.").define("Lower Difficulty Control", (Object)0.0);
        TORMENTOR_MAX_HEALTH = BUILDER.comment("Option to make the TORMENTOR weaker by lowering its max heath to any specific value. Default and maximum value is 1024.").define("Tormentor Max Health", (Object)1024.0);
        TORMENTOR_HIT_SPEED = BUILDER.comment("Value is in ticks. Since 20 ticks equate to a second, the default 50 ticks gives the Tormentor 5 seconds of immunity after each time it takes damage.").define("Tormentor Damage Speed Limit", (Object)40.0);
        BUILDER.pop();
        BUILDER.push("Other");
        WELCOME_MESSAGE = BUILDER.comment("When you join a world for the first time with ArPhEx installed, it shows a welcome message, informing you about the wiki and showing that the mod is active. Set to false to disable.").define("Welcome message", true);
        STRUCTURE_GENERATION = BUILDER.comment("Allow structure generations? Without them you will need to cheat to access the lower Crawling dimension layers or get ant colonies and termite-related items. Some tiny elements may still generate.").define("Structure generation toggle", true);
        SPECIAL_TORMENTOR_RENDERING = BUILDER.comment("Keep enabled if you want to use the bonus rendering system for the Tormentor, featuring infinite render distance for the entity along with modifying fog distance accordingly, plus fog colour when nearby").define("Special Tormentor rendering", true);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

