/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.impl.resources;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.darkhax.bookshelf.Constants;
import net.darkhax.bookshelf.api.Services;
import net.darkhax.bookshelf.api.function.CachedSupplier;
import net.minecraft.DetectedVersion;
import net.minecraft.WorldVersion;
import net.minecraft.client.Minecraft;

public class ExtendedText {
    public static Supplier<ExtendedText> INSTANCE = CachedSupplier.cache(ExtendedText::new);
    private final Map<String, Supplier<String>> extendedEntries = new LinkedHashMap<String, Supplier<String>>();

    private ExtendedText() {
        this.register("java_version", () -> ExtendedText.getProperty("java.version"));
        this.register("mc_version", () -> ((WorldVersion)DetectedVersion.f_132476_).m_132493_());
        this.register("loader_name", Services.PLATFORM::getName);
        this.register("player_name", () -> Minecraft.m_91087_().m_91094_().m_92546_());
        for (String modId : Services.PLATFORM.getLoadedMods()) {
            this.register(modId + "_name", () -> Services.PLATFORM.getModName(modId));
            this.register(modId + "_version", () -> {
                String version = Services.PLATFORM.getModVersion(modId);
                return version != null ? version : modId + "_version";
            });
        }
    }

    public boolean has(String key) {
        return this.extendedEntries.containsKey(key);
    }

    public String get(String key) {
        return this.extendedEntries.get(key).get();
    }

    private void register(String key, Supplier<String> value) {
        this.extendedEntries.put("text.bookshelf.ext." + key, CachedSupplier.cache(value));
    }

    private static String getProperty(String propertyName) {
        try {
            return System.getProperty(propertyName);
        }
        catch (Exception e) {
            Constants.LOG.debug("Unable to read property {}", (Object)propertyName, (Object)e);
            return "unknown";
        }
    }
}

