/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.lunar;

import com.mrbysco.lunar.api.ILunarEvent;
import com.mrbysco.lunar.platform.Services;
import com.mrbysco.lunar.registry.LunarRegistry;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class LunarPhaseData
extends SavedData {
    private static final Random random = new Random();
    private static final String DATA_NAME = "lunar_world_data";
    public ILunarEvent forcedEvent;
    public ILunarEvent activeEvent;

    public LunarPhaseData() {
        this.setActiveEvent(null);
        this.setForcedEvent(null);
    }

    public LunarPhaseData(ILunarEvent event, ILunarEvent forcedEvent) {
        this.setActiveEvent(event);
        this.setForcedEvent(forcedEvent);
    }

    public CompoundTag m_7176_(CompoundTag compound) {
        if (this.activeEvent != null) {
            compound.m_128359_("event", this.activeEvent.getID().toString());
        }
        if (this.forcedEvent != null) {
            compound.m_128359_("forcedEvent", this.forcedEvent.getID().toString());
        }
        return compound;
    }

    public static LunarPhaseData load(CompoundTag compound) {
        ResourceLocation eventID = compound.m_128461_("event").isEmpty() ? null : ResourceLocation.m_135820_((String)compound.m_128461_("event"));
        ILunarEvent event = eventID != null ? LunarRegistry.instance().getEventByID(eventID) : null;
        ResourceLocation forcedEventID = compound.m_128461_("forcedEvent").isEmpty() ? null : ResourceLocation.m_135820_((String)compound.m_128461_("forcedEvent"));
        ILunarEvent forcedEvent = forcedEventID != null ? LunarRegistry.instance().getEventByID(forcedEventID) : null;
        return new LunarPhaseData(event, forcedEvent);
    }

    public static LunarPhaseData get(Level level) {
        if (!(level instanceof ServerLevel)) {
            throw new RuntimeException("Attempted to get the data from a client world. This is wrong.");
        }
        ServerLevel overworld = level.m_7654_().m_129880_(Level.f_46428_);
        DimensionDataStorage storage = overworld.m_8895_();
        return (LunarPhaseData)storage.m_164861_(LunarPhaseData::load, LunarPhaseData::new, DATA_NAME);
    }

    public void setRandomLunarEvent(Level level) {
        if (this.forcedEvent != null) {
            MutableComponent startComponent = Component.m_237110_((String)"lunar.event.start", (Object[])new Object[]{Component.m_237115_((String)this.forcedEvent.getTranslationKey())});
            level.m_6907_().forEach(arg_0 -> LunarPhaseData.lambda$setRandomLunarEvent$0((Component)startComponent, arg_0));
            this.setActiveEvent(this.forcedEvent);
            this.setForcedEvent(null);
        } else {
            ILunarEvent event;
            float rng = random.nextFloat();
            if (rng <= Services.PLATFORM.getLunarChance() && (event = LunarRegistry.instance().getRandomLunarEvent(level)) != null) {
                MutableComponent startComponent = Component.m_237110_((String)"lunar.event.start", (Object[])new Object[]{Component.m_237115_((String)event.getTranslationKey())});
                level.m_6907_().forEach(arg_0 -> LunarPhaseData.lambda$setRandomLunarEvent$1((Component)startComponent, arg_0));
                this.setActiveEvent(event);
                return;
            }
            this.setDefaultMoon();
        }
    }

    public void setForcedEvent(ILunarEvent event) {
        this.forcedEvent = event;
        this.m_77762_();
    }

    public void eraseEvent() {
        this.setActiveEvent(null);
    }

    public void setDefaultMoon() {
        this.setActiveEvent(LunarRegistry.getDefaultMoon());
        this.setForcedEvent(null);
    }

    private void setActiveEvent(ILunarEvent storage) {
        this.activeEvent = storage;
        this.m_77762_();
    }

    public void syncEvent(Level level) {
        Services.PLATFORM.syncEvent(level, this.activeEvent != null ? this.activeEvent : null);
    }

    public void syncEvent(ServerPlayer player) {
        Services.PLATFORM.syncEvent(player, this.activeEvent != null ? this.activeEvent : null);
    }

    public ILunarEvent getActiveLunarEvent() {
        return this.activeEvent != null ? this.activeEvent : null;
    }

    public boolean hasEventActive() {
        return this.activeEvent != null;
    }

    private static /* synthetic */ void lambda$setRandomLunarEvent$1(Component startComponent, Player player) {
        player.m_213846_(startComponent);
    }

    private static /* synthetic */ void lambda$setRandomLunarEvent$0(Component startComponent, Player player) {
        player.m_213846_(startComponent);
    }
}

