/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.lunar.config;

import com.mrbysco.lunar.CommonClass;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class LunarConfig {
    public static final ForgeConfigSpec commonSpec;
    public static final Common COMMON;

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        commonSpec = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.DoubleValue lunarEventChance;
        public final ForgeConfigSpec.IntValue bloodMoonWeight;
        public final ForgeConfigSpec.IntValue crimsonMoonWeight;
        public final ForgeConfigSpec.IntValue minerMoonWeight;
        public final ForgeConfigSpec.IntValue whiteMoonWeight;
        public final ForgeConfigSpec.IntValue tinyMoonWeight;
        public final ForgeConfigSpec.IntValue bigMoonWeight;
        public final ForgeConfigSpec.IntValue badOmenMoonWeight;
        public final ForgeConfigSpec.IntValue heroMoonWeight;
        public final ForgeConfigSpec.IntValue eclipseMoonWeight;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> crimsonReplacements;

        Common(ForgeConfigSpec.Builder builder) {
            builder.comment("General settings").push("General");
            this.lunarEventChance = builder.comment("Chance of a Lunar Event happening when night falls [Default: 0.4]").defineInRange("lunarEventChance", 0.4, 0.0, 1.0);
            builder.pop();
            builder.comment("Event settings").push("Events");
            this.bloodMoonWeight = builder.comment("Weight of the Blood Moon Event [Default: 60]").defineInRange("bloodMoonWeight", 60, 0, 100);
            this.crimsonMoonWeight = builder.comment("Weight of the Crimson Moon Event [Default: 20]").defineInRange("crimsonMoonWeight", 20, 0, 100);
            this.minerMoonWeight = builder.comment("Weight of the Miner Moon Event [Default: 40]").defineInRange("minerMoonWeight", 40, 0, 100);
            this.whiteMoonWeight = builder.comment("Weight of the White Moon Event [Default: 10]").defineInRange("whiteMoonWeight", 10, 0, 100);
            this.tinyMoonWeight = builder.comment("Weight of the Tiny Moon Event [Default: 10]").defineInRange("tinyMoonWeight", 10, 0, 100);
            this.bigMoonWeight = builder.comment("Weight of the Big Moon Event [Default: 10]").defineInRange("bigMoonWeight", 10, 0, 100);
            this.badOmenMoonWeight = builder.comment("Weight of the Big Moon Event [Default: 5]").defineInRange("badOmenMoonWeight", 5, 0, 100);
            this.heroMoonWeight = builder.comment("Weight of the Hero Moon Event [Default: 5]").defineInRange("heroMoonWeight", 5, 0, 100);
            this.eclipseMoonWeight = builder.comment("Weight of the Eclipse Moon Event [Default: 2]").defineInRange("eclipseMoonWeight", 2, 0, 100);
            builder.pop();
            builder.comment("Crimson Replacement settings").push("Crimson");
            this.crimsonReplacements = builder.comment("List of entities to replace during the Crimson Moon Event [Example: \"minecraft:zombie,minecraft:zombified_piglin\"]").defineListAllowEmpty(List.of("crimsonReplacements"), () -> CommonClass.DEFAULT_CRIMSON_REPLACEMENT, o -> {
                String entry;
                return o instanceof String && (entry = (String)o).contains(",");
            });
            builder.pop();
        }
    }
}

