/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.lunar.handler;

import com.mrbysco.lunar.LunarPhaseData;
import com.mrbysco.lunar.api.ILunarEvent;
import com.mrbysco.lunar.handler.result.EventResult;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class LunarHandler {
    public static void onWorldTick(Level level) {
        if (level.m_46467_() % 20L == 0L && !level.f_46443_) {
            ServerLevel serverLevel = (ServerLevel)level;
            LunarPhaseData phaseData = LunarPhaseData.get((Level)serverLevel);
            ILunarEvent event = phaseData.getActiveLunarEvent();
            int currentTime = (int)(serverLevel.m_46468_() % 24000L);
            if (currentTime > 13000 && currentTime < 23000) {
                if (!phaseData.hasEventActive()) {
                    phaseData.setRandomLunarEvent((Level)serverLevel);
                    phaseData.syncEvent((Level)serverLevel);
                } else if (event != null) {
                    if (event.applyEntityEffect()) {
                        serverLevel.m_8583_().forEach(entity -> {
                            if (entity.m_5833_()) {
                                return;
                            }
                            event.applyEntityEffect((Entity)entity);
                        });
                    }
                    if (event.applyPlayerEffect()) {
                        serverLevel.m_6907_().forEach(event::applyPlayerEffect);
                    }
                }
            } else if (phaseData.hasEventActive()) {
                if (event != null) {
                    event.stopEffects((Level)serverLevel);
                }
                phaseData.eraseEvent();
                phaseData.syncEvent((Level)serverLevel);
            }
        }
    }

    public static EventResult canSleep(Player player, BlockPos sleepingPos) {
        LunarPhaseData phaseData;
        ILunarEvent lunarEvent;
        Level level = player.m_9236_();
        if (!level.f_46443_ && (lunarEvent = (phaseData = LunarPhaseData.get(level)).getActiveLunarEvent()) != null) {
            return lunarEvent.canSleep(player, sleepingPos);
        }
        return EventResult.DEFAULT;
    }

    public static EventResult getSpawnResult(MobSpawnType mobSpawnType, LivingEntity livingEntity) {
        LunarPhaseData phaseData;
        ILunarEvent lunarEvent;
        Level level = livingEntity.m_9236_();
        if (!level.f_46443_ && (lunarEvent = (phaseData = LunarPhaseData.get(level)).getActiveLunarEvent()) != null && lunarEvent.dictatesMobSpawn()) {
            return lunarEvent.getSpawnResult(livingEntity, mobSpawnType);
        }
        return EventResult.DEFAULT;
    }

    public static void uponLivingSpawn(MobSpawnType mobSpawnType, LivingEntity livingEntity) {
        LunarPhaseData phaseData;
        ILunarEvent lunarEvent;
        Level level = livingEntity.m_9236_();
        if (!level.f_46443_ && (lunarEvent = (phaseData = LunarPhaseData.get(level)).getActiveLunarEvent()) != null && lunarEvent.applySpawnEffect()) {
            lunarEvent.applySpawnEffect(livingEntity, mobSpawnType);
        }
    }
}

