/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.lunar.platform;

import com.google.common.collect.Maps;
import com.mrbysco.lunar.api.ILunarEvent;
import com.mrbysco.lunar.config.LunarConfig;
import com.mrbysco.lunar.network.PacketHandler;
import com.mrbysco.lunar.network.message.SyncDeltaMovement;
import com.mrbysco.lunar.network.message.SyncEventMessage;
import com.mrbysco.lunar.platform.services.IPlatformHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;

public class ForgePlatformHelper
implements IPlatformHelper {
    @Override
    public void syncEvent(Level level, ILunarEvent event) {
        PacketHandler.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new SyncEventMessage(event));
    }

    @Override
    public void syncEvent(ServerPlayer player, ILunarEvent event) {
        PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SyncEventMessage(event));
    }

    @Override
    public void syncDeltaMovement(ServerPlayer player, Vec3 deltaMovement) {
        PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SyncDeltaMovement(deltaMovement));
    }

    @Override
    public float getLunarChance() {
        return ((Double)LunarConfig.COMMON.lunarEventChance.get()).floatValue();
    }

    @Override
    public int getBloodMoonWeight() {
        return (Integer)LunarConfig.COMMON.bloodMoonWeight.get();
    }

    @Override
    public int getCrimsonMoonWeight() {
        return (Integer)LunarConfig.COMMON.crimsonMoonWeight.get();
    }

    @Override
    public int getMinerMoonWeight() {
        return (Integer)LunarConfig.COMMON.minerMoonWeight.get();
    }

    @Override
    public int getWhiteMoonWeight() {
        return (Integer)LunarConfig.COMMON.whiteMoonWeight.get();
    }

    @Override
    public int getBigMoonWeight() {
        return (Integer)LunarConfig.COMMON.bigMoonWeight.get();
    }

    @Override
    public int getTinyMoonWeight() {
        return (Integer)LunarConfig.COMMON.tinyMoonWeight.get();
    }

    @Override
    public int getBadOmenMoonWeight() {
        return (Integer)LunarConfig.COMMON.badOmenMoonWeight.get();
    }

    @Override
    public int getHeroMoonWeight() {
        return (Integer)LunarConfig.COMMON.heroMoonWeight.get();
    }

    @Override
    public int getEclipseMoonWeight() {
        return (Integer)LunarConfig.COMMON.eclipseMoonWeight.get();
    }

    @Override
    public Map<ResourceLocation, ResourceLocation> getCrimsonReplacementMap() {
        HashMap map = Maps.newHashMap();
        ((List)LunarConfig.COMMON.crimsonReplacements.get()).forEach(entry -> {
            if (entry.contains(",")) {
                String[] split = entry.split(",");
                map.put(ResourceLocation.m_135820_((String)split[0]), ResourceLocation.m_135820_((String)split[1]));
            }
        });
        return map;
    }

    @Override
    public ResourceLocation getEntityTypeLocation(EntityType<?> entityType) {
        return ForgeRegistries.ENTITY_TYPES.getKey(entityType);
    }

    @Override
    public EntityType<?> getEntityType(ResourceLocation location) {
        return (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(location);
    }
}

