/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.lunar.registry.events;

import com.mrbysco.lunar.api.LunarEvent;
import com.mrbysco.lunar.handler.result.EventResult;
import com.mrbysco.lunar.platform.Services;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;

public class CrimsonMoonEvent
extends LunarEvent {
    public CrimsonMoonEvent() {
        super(new ResourceLocation("lunar", "crimson_moon"), 14423100);
    }

    @Override
    public int spawnWeight() {
        return Services.PLATFORM.getCrimsonMoonWeight();
    }

    @Override
    public String getTranslationKey() {
        return "lunar.event.crimson_moon";
    }

    @Override
    public EventResult canSleep(Player player, BlockPos sleepingLocation) {
        return EventResult.DEFAULT;
    }

    @Override
    public boolean dictatesMobSpawn() {
        return true;
    }

    @Override
    public EventResult getSpawnResult(LivingEntity livingEntity, MobSpawnType spawnType) {
        Entity replacementEntity;
        EntityType<?> replacementType;
        ResourceLocation replacementLocation;
        ResourceLocation entityLocation;
        Map<ResourceLocation, ResourceLocation> replacementMap;
        ServerLevel level = (ServerLevel)livingEntity.m_9236_();
        if (spawnType == MobSpawnType.NATURAL && (replacementMap = Services.PLATFORM.getCrimsonReplacementMap()).containsKey(entityLocation = Services.PLATFORM.getEntityTypeLocation(livingEntity.m_6095_())) && (replacementLocation = replacementMap.get(entityLocation)) != null && (replacementType = Services.PLATFORM.getEntityType(replacementLocation)) != null && (replacementEntity = replacementType.m_20615_((Level)level)) != null) {
            BlockPos position = livingEntity.m_20183_();
            replacementEntity.m_20035_(position, livingEntity.m_146908_(), livingEntity.m_146909_());
            if (replacementEntity instanceof Mob) {
                Mob mob = (Mob)replacementEntity;
                if (!mob.m_6914_((LevelReader)level)) {
                    return EventResult.DEFAULT;
                }
                mob.m_6518_((ServerLevelAccessor)level, level.m_6436_(position), MobSpawnType.NATURAL, null, null);
            }
            if (replacementEntity instanceof Ghast) {
                if (level.f_46441_.m_188500_() <= 0.5) {
                    level.m_7967_(replacementEntity);
                }
                livingEntity.m_146870_();
            } else {
                level.m_7967_(replacementEntity);
                livingEntity.m_146870_();
            }
            return EventResult.DENY;
        }
        return EventResult.DEFAULT;
    }
}

