/*
 * Decompiled with CFR 0.152.
 */
package com.codinglitch.simpleradio;

import java.util.ServiceLoader;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CommonSimpleRadio {
    public static final String ID = "simpleradio";
    private static Logger LOGGER = LogManager.getLogger((String)"simpleradio");

    public static ResourceLocation id(String ... arguments) {
        return CommonSimpleRadio.id((CharSequence)"", arguments);
    }

    public static ResourceLocation id(CharSequence delimiter, String ... arguments) {
        return new ResourceLocation(ID, String.join(delimiter, arguments));
    }

    public static <T> T loadService(Class<T> clazz) {
        T loadedService = ServiceLoader.load(clazz).findFirst().orElseThrow(() -> new NullPointerException("Failed to load service for " + clazz.getName()));
        CommonSimpleRadio.debug("Loaded {} for service {}", loadedService, clazz);
        return loadedService;
    }

    public static void info(Object object, Object ... substitutions) {
        LOGGER.info(String.valueOf(object), substitutions);
    }

    public static void debug(Object object, Object ... substitutions) {
        LOGGER.debug(String.valueOf(object), substitutions);
    }

    public static void warn(Object object, Object ... substitutions) {
        LOGGER.warn(String.valueOf(object), substitutions);
    }

    public static void error(Object object, Object ... substitutions) {
        LOGGER.error(String.valueOf(object), substitutions);
    }

    public static void initialize() {
    }
}

