/*
 * Decompiled with CFR 0.152.
 */
package com.codinglitch.simpleradio.client;

import com.codinglitch.simpleradio.client.models.MicrophoneModel;
import com.codinglitch.simpleradio.client.models.RadioModel;
import com.codinglitch.simpleradio.client.renderers.FrequencerRenderer;
import com.codinglitch.simpleradio.client.renderers.MicrophoneRenderer;
import com.codinglitch.simpleradio.client.renderers.RadioRenderer;
import com.codinglitch.simpleradio.client.screens.RadiosmitherScreen;
import com.codinglitch.simpleradio.core.registry.SimpleRadioBlockEntities;
import com.codinglitch.simpleradio.core.registry.SimpleRadioBlocks;
import com.codinglitch.simpleradio.core.registry.SimpleRadioItems;
import com.codinglitch.simpleradio.core.registry.SimpleRadioMenus;
import com.codinglitch.simpleradio.platform.ClientServices;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import org.apache.logging.log4j.util.BiConsumer;
import org.apache.logging.log4j.util.TriConsumer;

public class CommonSimpleRadioClient {
    public static final Map<UUID, Boolean> isTransmitting = new HashMap<UUID, Boolean>();

    public static void loadProperties(TriConsumer<Item, ResourceLocation, ClampedItemPropertyFunction> registry) {
        registry.accept((Object)SimpleRadioItems.TRANSCEIVER, (Object)new ResourceLocation("using"), (stack, level, entity, i) -> entity != null && entity.m_6117_() && entity.m_21211_() == stack ? 1.0f : 0.0f);
        registry.accept((Object)SimpleRadioItems.TRANSCEIVER, (Object)new ResourceLocation("speaking"), (stack, level, entity, i) -> entity != null && isTransmitting.containsValue(true) ? 1.0f : 0.0f);
        registry.accept((Object)SimpleRadioItems.WALKIE_TALKIE, (Object)new ResourceLocation("using"), (stack, level, entity, i) -> entity != null && entity.m_6117_() && entity.m_21211_() == stack ? 1.0f : 0.0f);
        registry.accept((Object)SimpleRadioItems.SPUDDIE_TALKIE, (Object)new ResourceLocation("using"), (stack, level, entity, i) -> entity != null && entity.m_6117_() && entity.m_21211_() == stack ? 1.0f : 0.0f);
    }

    public static void loadRenderTypes(BiConsumer<Block, RenderType> registry) {
        registry.accept((Object)SimpleRadioBlocks.RADIOSMITHER, (Object)RenderType.m_110463_());
        registry.accept((Object)SimpleRadioBlocks.ANTENNA, (Object)RenderType.m_110463_());
    }

    public static void loadLayerDefinitions(BiConsumer<ModelLayerLocation, Supplier<LayerDefinition>> registry) {
        registry.accept((Object)RadioModel.LAYER_LOCATION, RadioModel::createBodyLayer);
        registry.accept((Object)MicrophoneModel.LAYER_LOCATION, MicrophoneModel::createBodyLayer);
    }

    public static void loadBlockEntityRenderers(BlockEntityRendererRegistry registry) {
        registry.register(SimpleRadioBlockEntities.RADIO, RadioRenderer::new);
        registry.register(SimpleRadioBlockEntities.FREQUENCER, FrequencerRenderer::new);
        registry.register(SimpleRadioBlockEntities.MICROPHONE, MicrophoneRenderer::new);
    }

    public static void loadScreens() {
        ClientServices.REGISTRY.registerScreen(SimpleRadioMenus.RADIOSMITHER_MENU, RadiosmitherScreen::new);
    }

    public static void loadAtlases(BiConsumer<ResourceLocation, Supplier<LayerDefinition>> registry) {
    }

    public static void initialize() {
    }

    public static interface BlockEntityRendererRegistry {
        public <BE extends BlockEntity> void register(BlockEntityType<BE> var1, BlockEntityRendererProvider<? super BE> var2);
    }
}

