/*
 * Decompiled with CFR 0.152.
 */
package com.codinglitch.simpleradio.core.central;

import com.codinglitch.simpleradio.core.central.Frequencing;
import com.codinglitch.simpleradio.core.central.Frequency;
import com.codinglitch.simpleradio.core.central.WorldlyPosition;
import com.codinglitch.simpleradio.radio.CommonRadioPlugin;
import com.codinglitch.simpleradio.radio.RadioListener;
import de.maxhenkel.voicechat.api.VoicechatConnection;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public interface Transmitting
extends Frequencing {
    public static boolean validateTransmitter(WorldlyPosition position, @Nullable Frequency frequency) {
        BlockPos pos = position.realLocation();
        if (!position.level.m_46749_(pos)) {
            return false;
        }
        BlockState state = position.level.m_8055_(pos);
        if (state.m_60795_()) {
            return false;
        }
        BlockEntity blockEntity = position.level.m_7702_(pos);
        Item item = state.m_60734_().m_5456_();
        if (item instanceof Transmitting) {
            Transmitting transmitting = (Transmitting)item;
            return frequency == null || transmitting.getFrequency(blockEntity) == frequency;
        }
        return false;
    }

    public static boolean validateTransmitter(UUID uuid, @Nullable Frequency frequency) {
        VoicechatConnection connection = CommonRadioPlugin.serverApi.getConnectionOf(uuid);
        if (connection != null) {
            return Transmitting.validateTransmitter(connection, frequency);
        }
        return false;
    }

    public static boolean validateTransmitter(VoicechatConnection connection, @Nullable Frequency frequency) {
        ServerPlayer player = (ServerPlayer)connection.getPlayer().getPlayer();
        if (player == null) {
            return false;
        }
        return Transmitting.validateTransmitter(player, frequency);
    }

    public static boolean validateTransmitter(ServerPlayer player, @Nullable Frequency frequency) {
        return player.m_150109_().m_216874_(stack -> {
            Item patt2111$temp = stack.m_41720_();
            if (patt2111$temp instanceof Transmitting) {
                Transmitting transmitting = (Transmitting)patt2111$temp;
                return frequency == null || transmitting.getFrequency((ItemStack)stack) == frequency;
            }
            return false;
        });
    }

    default public RadioListener startListening(Entity owner) {
        return RadioListener.getOrCreateListener(owner);
    }

    default public RadioListener startListening(WorldlyPosition location) {
        return RadioListener.getOrCreateListener(location);
    }

    default public void stopListening(Entity owner) {
        RadioListener.removeListener(owner);
    }

    default public void stopListening(WorldlyPosition location) {
        RadioListener.removeListener(location);
    }

    default public void setState(Entity entity, State state) {
        switch (state) {
            case TRANSMITTING: {
                entity.m_20049_("transmissionActive");
                break;
            }
            case INACTIVE: {
                entity.m_20137_("transmissionActive");
            }
        }
    }

    public static enum State {
        TRANSMITTING,
        INACTIVE;

    }
}

