/*
 * Decompiled with CFR 0.152.
 */
package com.codinglitch.simpleradio.core.networking.packets;

import com.codinglitch.simpleradio.CommonSimpleRadio;
import com.codinglitch.simpleradio.core.central.Frequency;
import com.codinglitch.simpleradio.core.central.Packeter;
import com.codinglitch.simpleradio.core.registry.menus.RadiosmitherMenu;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;

public record ServerboundRadioUpdatePacket(String frequency, Frequency.Modulation modulation) implements Packeter
{
    public static ResourceLocation ID = new ResourceLocation("simpleradio", "radio_update_packet");

    @Override
    public ResourceLocation resource() {
        return ID;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.frequency);
        buffer.m_130070_(this.modulation.shorthand);
    }

    public static ServerboundRadioUpdatePacket decode(FriendlyByteBuf buffer) {
        return new ServerboundRadioUpdatePacket(buffer.m_130277_(), Frequency.modulationOf(buffer.m_130277_()));
    }

    public void handle(MinecraftServer server, ServerPlayer player) {
        server.execute(() -> {
            if (!Frequency.check(this.frequency)) {
                return;
            }
            AbstractContainerMenu menu = player.f_36096_;
            if (menu instanceof RadiosmitherMenu) {
                RadiosmitherMenu radiosmitherMenu = (RadiosmitherMenu)menu;
                if (!player.f_36096_.m_6875_((Player)player)) {
                    CommonSimpleRadio.debug("Player {} interacted with invalid menu {}", player, player.f_36096_);
                    return;
                }
                radiosmitherMenu.updateTinkering(this.frequency, this.modulation);
            }
        });
    }
}

