/*
 * Decompiled with CFR 0.152.
 */
package com.codinglitch.simpleradio.core.registry;

import com.codinglitch.lexiconfig.classes.LexiconPageData;
import com.codinglitch.simpleradio.CommonSimpleRadio;
import com.codinglitch.simpleradio.SimpleRadioLibrary;
import com.codinglitch.simpleradio.core.central.ItemHolder;
import com.codinglitch.simpleradio.core.registry.SimpleRadioBlocks;
import com.codinglitch.simpleradio.core.registry.SimpleRadioMenus;
import com.codinglitch.simpleradio.core.registry.items.MicrophoneItem;
import com.codinglitch.simpleradio.core.registry.items.ModuleItem;
import com.codinglitch.simpleradio.core.registry.items.RadioItem;
import com.codinglitch.simpleradio.core.registry.items.SpeakerItem;
import com.codinglitch.simpleradio.core.registry.items.TransceiverItem;
import com.codinglitch.simpleradio.core.registry.items.WalkieTalkieItem;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;

public class SimpleRadioItems {
    public static final Map<ResourceLocation, ItemHolder<Item>> ITEMS = new LinkedHashMap<ResourceLocation, ItemHolder<Item>>();
    public static TransceiverItem TRANSCEIVER = SimpleRadioItems.register(CommonSimpleRadio.id("transceiver"), new TransceiverItem(new Item.Properties().m_41487_(1)));
    public static WalkieTalkieItem WALKIE_TALKIE = SimpleRadioItems.register(CommonSimpleRadio.id("walkie_talkie"), new WalkieTalkieItem(new Item.Properties().m_41487_(1)));
    public static WalkieTalkieItem SPUDDIE_TALKIE = SimpleRadioItems.register(CommonSimpleRadio.id("spuddie_talkie"), new WalkieTalkieItem(new Item.Properties().m_41487_(1)));
    public static Item RADIOSMITHER = SimpleRadioItems.register(CommonSimpleRadio.id("radiosmither"), new BlockItem(SimpleRadioBlocks.RADIOSMITHER, new Item.Properties()));
    public static RadioItem RADIO = SimpleRadioItems.register(CommonSimpleRadio.id("radio"), new RadioItem(new Item.Properties().m_41487_(1)));
    public static SpeakerItem SPEAKER = SimpleRadioItems.register(CommonSimpleRadio.id("speaker"), new SpeakerItem(new Item.Properties().m_41487_(1)));
    public static MicrophoneItem MICROPHONE = SimpleRadioItems.register(CommonSimpleRadio.id("microphone"), new MicrophoneItem(new Item.Properties().m_41487_(1)));
    public static Item FREQUENCER = SimpleRadioItems.register(CommonSimpleRadio.id("frequencer"), new BlockItem(SimpleRadioBlocks.FREQUENCER, new Item.Properties().m_41487_(1)));
    public static Item ANTENNA = SimpleRadioItems.register(CommonSimpleRadio.id("antenna"), new BlockItem(SimpleRadioBlocks.ANTENNA, new Item.Properties().m_41487_(16)));
    public static Item TRANSMITTING_MODULE = SimpleRadioItems.register(CommonSimpleRadio.id("transmitting_module"), new Item(new Item.Properties()));
    public static Item RECEIVING_MODULE = SimpleRadioItems.register(CommonSimpleRadio.id("receiving_module"), new Item(new Item.Properties()));
    public static Item SPEAKER_MODULE = SimpleRadioItems.register(CommonSimpleRadio.id("speaker_module"), new Item(new Item.Properties()));
    public static Item LISTENER_MODULE = SimpleRadioItems.register(CommonSimpleRadio.id("listener_module"), new Item(new Item.Properties()));
    public static ModuleItem IRON_MODULE = SimpleRadioItems.register(CommonSimpleRadio.id("iron_module"), new ModuleItem((Tier)Tiers.IRON, new Item.Properties()));
    public static ModuleItem GOLD_MODULE = SimpleRadioItems.register(CommonSimpleRadio.id("gold_module"), new ModuleItem((Tier)Tiers.GOLD, new Item.Properties()));
    public static ModuleItem DIAMOND_MODULE = SimpleRadioItems.register(CommonSimpleRadio.id("diamond_module"), new ModuleItem((Tier)Tiers.DIAMOND, new Item.Properties()));
    public static ModuleItem NETHERITE_MODULE = SimpleRadioItems.register(CommonSimpleRadio.id("netherite_module"), new ModuleItem((Tier)Tiers.NETHERITE, new Item.Properties()));

    public static void reload() {
        ITEMS.forEach((location, holder) -> {
            String path = location.m_135815_();
            LexiconPageData configData = SimpleRadioLibrary.SERVER_CONFIG.getPage(path);
            if (configData != null) {
                Object field = configData.getEntry("enabled");
                boolean bl = holder.enabled = field == null || (Boolean)field != false;
            }
            if (path.equals("walkie_talkie") || path.equals("spuddie_talkie")) {
                LexiconPageData spudData = SimpleRadioLibrary.SERVER_CONFIG.getPage("walkie_talkie");
                Object enabled = spudData.getEntry("enabled");
                Object spudder = spudData.getEntry("spuddieTalkie");
                holder.enabled = (Boolean)enabled != false && (spudder == null || path.equals("spuddie_talkie") == ((Boolean)spudder).booleanValue());
            }
        });
    }

    public static ItemHolder<Item> getByName(String name) {
        Optional<Map.Entry> optional = ITEMS.entrySet().stream().filter(entry -> ((ResourceLocation)entry.getKey()).m_135815_().equals(name)).findFirst();
        return optional.map(Map.Entry::getValue).orElse(null);
    }

    private static <I extends Item> I register(ResourceLocation location, I item) {
        return SimpleRadioItems.register(location, item, SimpleRadioMenus.RADIO_TAB_LOCATION);
    }

    private static <I extends Item> I register(ResourceLocation location, I item, ResourceLocation tab) {
        ItemHolder<I> holder = ItemHolder.of(item, tab);
        ITEMS.put(location, holder);
        return item;
    }
}

