/*
 * Decompiled with CFR 0.152.
 */
package com.codinglitch.simpleradio.core.registry.blocks;

import com.codinglitch.simpleradio.core.central.Frequency;
import com.codinglitch.simpleradio.core.central.FrequencyBlockEntity;
import com.codinglitch.simpleradio.core.central.Transmitting;
import com.codinglitch.simpleradio.core.central.WorldlyPosition;
import com.codinglitch.simpleradio.core.registry.SimpleRadioBlockEntities;
import com.codinglitch.simpleradio.core.registry.SimpleRadioSounds;
import com.codinglitch.simpleradio.platform.Services;
import com.codinglitch.simpleradio.radio.RadioListener;
import com.codinglitch.simpleradio.radio.RadioManager;
import com.codinglitch.simpleradio.radio.RadioSource;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class MicrophoneBlockEntity
extends FrequencyBlockEntity
implements Transmitting {
    public boolean isListening = false;
    public UUID listenerID = UUID.randomUUID();
    private RadioListener listener;

    public MicrophoneBlockEntity(BlockPos pos, BlockState state) {
        super(SimpleRadioBlockEntities.MICROPHONE, pos, state);
    }

    public void m_7651_() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_ && this.listener != null) {
            this.f_58857_.m_6263_(null, (double)this.listener.location.x, (double)this.listener.location.y, (double)this.listener.location.z, SimpleRadioSounds.RADIO_CLOSE, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        if (this.frequency != null) {
            this.stopListening(WorldlyPosition.of(this.m_58899_(), this.f_58857_));
        }
        super.m_7651_();
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.loadTag(tag);
    }

    public void m_183515_(CompoundTag tag) {
        this.saveTag(tag);
        super.m_183515_(tag);
    }

    public void m_187476_(ItemStack stack) {
        this.saveTag(stack.m_41784_());
        super.m_187476_(stack);
    }

    public static void tick(Level level, BlockPos pos, BlockState blockState, MicrophoneBlockEntity blockEntity) {
        if (!level.f_46443_ && blockEntity.frequency != null && !blockEntity.isListening) {
            blockEntity.listen();
        }
    }

    public void listen() {
        this.listener = this.startListening(Services.COMPAT.modifyPosition(WorldlyPosition.of(this.f_58858_, this.f_58857_, this.f_58858_)));
        this.listener.range = 12.0f;
        this.listener.acceptor(source -> {
            source.type = RadioSource.Type.TRANSMITTER;
            source.delegate(this.listenerID);
            Frequency frequency = this.getFrequency(this);
            if (frequency != null) {
                RadioManager.transmit(source, frequency);
            }
        });
        this.frequency.tryAddTransmitter(this.listener);
        this.f_58857_.m_6263_(null, (double)this.listener.location.x, (double)this.listener.location.y, (double)this.listener.location.z, SimpleRadioSounds.RADIO_OPEN, SoundSource.PLAYERS, 1.0f, 1.0f);
        this.isListening = true;
    }

    public void loadFromItem(ItemStack stack) {
        this.loadTag(stack.m_41784_());
    }

    public void loadTag(CompoundTag tag) {
        if (this.frequency != null) {
            this.stopListening(WorldlyPosition.of(this.m_58899_(), this.f_58857_));
            this.isListening = false;
        }
        String frequencyName = tag.m_128461_("frequency");
        Frequency.Modulation modulation = Frequency.modulationOf(tag.m_128461_("modulation"));
        this.frequency = Frequency.getOrCreateFrequency(frequencyName, modulation);
    }

    public void saveTag(CompoundTag tag) {
        if (this.frequency == null) {
            return;
        }
        tag.m_128359_("frequency", this.frequency.frequency);
        tag.m_128359_("modulation", this.frequency.modulation.shorthand);
    }
}

