/*
 * Decompiled with CFR 0.152.
 */
package com.codinglitch.simpleradio.radio;

import com.codinglitch.simpleradio.core.central.Transmitting;
import com.codinglitch.simpleradio.core.central.WorldlyPosition;
import com.codinglitch.simpleradio.platform.Services;
import com.codinglitch.simpleradio.radio.RadioSource;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public class RadioListener {
    private static final List<RadioListener> listeners = new ArrayList<RadioListener>();
    public Entity owner;
    public WorldlyPosition location;
    private Consumer<RadioSource> dataAcceptor;
    public float range = 8.0f;

    public static List<RadioListener> getListeners() {
        return listeners;
    }

    public static void removeListener(RadioListener listener) {
        listeners.remove(listener);
    }

    public static void removeListener(Entity owner) {
        listeners.removeIf(listener -> listener.owner == owner);
    }

    public static void removeListener(WorldlyPosition location) {
        listeners.removeIf(listener -> listener.location != null && listener.location.equals(location));
    }

    public static RadioListener getListener(Entity owner) {
        Optional<RadioListener> radioListener = listeners.stream().filter(listener -> listener.owner == owner).findFirst();
        return radioListener.orElse(null);
    }

    public static RadioListener getListener(WorldlyPosition location) {
        Optional<RadioListener> radioListener = listeners.stream().filter(listener -> listener.location == location).findFirst();
        return radioListener.orElse(null);
    }

    public static RadioListener getOrCreateListener(Entity owner) {
        RadioListener listener = RadioListener.getListener(owner);
        return listener != null ? listener : new RadioListener(owner);
    }

    public static RadioListener getOrCreateListener(WorldlyPosition location) {
        RadioListener listener = RadioListener.getListener(location);
        return listener != null ? listener : new RadioListener(location);
    }

    public static void garbageCollect() {
        listeners.removeIf(Predicate.not(RadioListener::validate));
        listeners.removeIf(listener -> listener.owner == null && listener.location == null);
    }

    public RadioListener(Entity owner) {
        this.owner = owner;
        listeners.add(this);
    }

    public RadioListener(WorldlyPosition location) {
        this.location = location;
        listeners.add(this);
    }

    public void acceptor(Consumer<RadioSource> acceptor) {
        this.dataAcceptor = acceptor;
    }

    public void onData(RadioSource source) {
        this.dataAcceptor.accept(source);
    }

    public void updateLocation(WorldlyPosition location) {
    }

    public void serverTick(int tickCount) {
        if (this.location != null) {
            Services.COMPAT.modifyPosition(this.location);
            this.updateLocation(this.location);
        }
    }

    public boolean validate() {
        if (this.owner == null) {
            if (this.location == null || !Transmitting.validateTransmitter(this.location, null)) {
                this.invalidate();
                return false;
            }
        } else if (!Transmitting.validateTransmitter((ServerPlayer)this.owner, null)) {
            this.invalidate();
            return false;
        }
        return true;
    }

    public void invalidate() {
    }
}

