/*
 * Decompiled with CFR 0.152.
 */
package com.codinglitch.simpleradio.radio;

import com.codinglitch.lexiconfig.classes.LexiconPageData;
import com.codinglitch.simpleradio.CommonSimpleRadio;
import com.codinglitch.simpleradio.SimpleRadioLibrary;
import com.codinglitch.simpleradio.core.central.Frequency;
import com.codinglitch.simpleradio.core.central.WorldlyPosition;
import java.util.UUID;
import org.joml.Math;

public class RadioSource {
    public UUID owner;
    public UUID originalOwner;
    public WorldlyPosition location;
    public byte[] data;
    public Type type;
    public float volume;

    public RadioSource(UUID owner, WorldlyPosition location, byte[] data, float volume) {
        this.owner = owner;
        this.location = location;
        this.data = data;
        this.volume = volume;
    }

    public UUID getRealOwner() {
        return this.originalOwner == null ? this.owner : this.originalOwner;
    }

    public void delegate(UUID owner) {
        this.originalOwner = this.owner;
        this.owner = owner;
    }

    public int getMaxDistance(Frequency.Modulation modulation) {
        String pageName = this.type.toString().toLowerCase();
        LexiconPageData pageData = SimpleRadioLibrary.SERVER_CONFIG.getPage(pageName);
        if (pageData == null) {
            CommonSimpleRadio.warn("Could not find page {}!", pageName);
            return 0;
        }
        return modulation == Frequency.Modulation.FREQUENCY ? ((Integer)pageData.getEntry("maxFMDistance")).intValue() : ((Integer)pageData.getEntry("maxAMDistance")).intValue();
    }

    public int getFalloff(Frequency.Modulation modulation) {
        String pageName = this.type.toString().toLowerCase();
        LexiconPageData pageData = SimpleRadioLibrary.SERVER_CONFIG.getPage(pageName);
        if (pageData == null) {
            CommonSimpleRadio.warn("Could not find page {}!", pageName);
            return 0;
        }
        return modulation == Frequency.Modulation.FREQUENCY ? ((Integer)pageData.getEntry("falloffFM")).intValue() : ((Integer)pageData.getEntry("falloffAM")).intValue();
    }

    public float computeSeverity(WorldlyPosition destination, Frequency destinationFrequency) {
        float base;
        int maxDistance = this.getMaxDistance(destinationFrequency.modulation);
        int falloff = this.getFalloff(destinationFrequency.modulation);
        float distance = this.location.distance(destination);
        float f = base = destinationFrequency.modulation == Frequency.Modulation.FREQUENCY ? 2.0f : 15.0f;
        if (this.location.level.m_6042_() != destination.level.m_6042_()) {
            if (SimpleRadioLibrary.SERVER_CONFIG.frequency.crossDimensional.booleanValue()) {
                base += destinationFrequency.modulation == Frequency.Modulation.FREQUENCY ? (float)SimpleRadioLibrary.SERVER_CONFIG.frequency.dimensionalInterference.intValue() : 0.0f;
            } else {
                return 100.0f;
            }
        }
        return Math.clamp((float)0.0f, (float)100.0f, (float)(base + Math.max((float)0.0f, (float)(distance - (float)falloff)) / (float)(maxDistance - falloff) * (100.0f - base)));
    }

    public static enum Type {
        TRANSCEIVER,
        WALKIE_TALKIE,
        TRANSMITTER;

    }
}

