/*
 * Decompiled with CFR 0.152.
 */
package com.lion.graveyard.entities;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import org.jetbrains.annotations.Nullable;

public class GraveyardMinionEntity
extends PathfinderMob {
    protected static final EntityDataAccessor<Optional<UUID>> OWNER_UUID;
    protected static final EntityDataAccessor<Byte> TAMEABLE_FLAGS;
    private boolean sitting;

    public GraveyardMinionEntity(EntityType<? extends GraveyardMinionEntity> entityType, Level world) {
        super(entityType, world);
        this.m_21441_(BlockPathTypes.POWDER_SNOW, -1.0f);
        this.m_21441_(BlockPathTypes.DANGER_POWDER_SNOW, -1.0f);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(OWNER_UUID, Optional.empty());
        this.f_19804_.m_135372_(TAMEABLE_FLAGS, (Object)0);
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        if (this.getOwnerUuid() != null) {
            nbt.m_128362_("Owner", this.getOwnerUuid());
        }
        nbt.m_128379_("Sitting", this.sitting);
    }

    public void m_7378_(CompoundTag nbt) {
        UUID uUID;
        super.m_7378_(nbt);
        if (nbt.m_128403_("Owner")) {
            uUID = nbt.m_128342_("Owner");
        } else {
            String string = nbt.m_128461_("Owner");
            uUID = OldUsersConverter.m_11083_((MinecraftServer)this.m_20194_(), (String)string);
        }
        if (uUID != null) {
            try {
                this.setOwnerUuid(uUID);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.sitting = nbt.m_128471_("Sitting");
        this.setInSittingPose(this.sitting);
    }

    @Nullable
    public UUID getOwnerUuid() {
        return ((Optional)this.f_19804_.m_135370_(OWNER_UUID)).orElse(null);
    }

    public void setOwnerUuid(@Nullable UUID uuid) {
        this.f_19804_.m_135381_(OWNER_UUID, Optional.ofNullable(uuid));
    }

    public void setOwner(Player player) {
        this.setOwnerUuid(player.m_20148_());
    }

    public boolean isSitting() {
        return this.sitting;
    }

    public void setSitting(boolean sitting) {
        this.sitting = sitting;
    }

    public boolean isInSittingPose() {
        return ((Byte)this.f_19804_.m_135370_(TAMEABLE_FLAGS) & 1) != 0;
    }

    public void setInSittingPose(boolean inSittingPose) {
        byte b = (Byte)this.f_19804_.m_135370_(TAMEABLE_FLAGS);
        if (inSittingPose) {
            this.f_19804_.m_135381_(TAMEABLE_FLAGS, (Object)((byte)(b | 1)));
        } else {
            this.f_19804_.m_135381_(TAMEABLE_FLAGS, (Object)((byte)(b & 0xFFFFFFFE)));
        }
    }

    @Nullable
    public LivingEntity getOwner() {
        try {
            UUID uUID = this.getOwnerUuid();
            return uUID == null ? null : this.m_20193_().m_46003_(uUID);
        }
        catch (IllegalArgumentException var2) {
            return null;
        }
    }

    public boolean m_6779_(LivingEntity target) {
        return this.isOwner(target) ? false : super.m_6779_(target);
    }

    public boolean isOwner(LivingEntity entity) {
        return entity == this.getOwner();
    }

    public boolean m_7307_(Entity other) {
        LivingEntity livingEntity = this.getOwner();
        if (other == livingEntity) {
            return true;
        }
        if (livingEntity != null) {
            return livingEntity.m_7307_(other);
        }
        return super.m_7307_(other);
    }

    public boolean canAttackWithOwner(LivingEntity target, LivingEntity owner) {
        if (!(target instanceof Creeper) && !(target instanceof Ghast)) {
            if (target instanceof GraveyardMinionEntity) {
                GraveyardMinionEntity minion = (GraveyardMinionEntity)target;
                return minion.getOwner() != owner;
            }
            if (target instanceof Player && owner instanceof Player && !((Player)owner).m_7099_((Player)target)) {
                return false;
            }
            if (target instanceof AbstractHorse && ((AbstractHorse)target).m_30614_()) {
                return false;
            }
            return !(target instanceof TamableAnimal) || !((TamableAnimal)target).m_21824_();
        }
        return false;
    }

    static {
        TAMEABLE_FLAGS = SynchedEntityData.m_135353_(GraveyardMinionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
        OWNER_UUID = SynchedEntityData.m_135353_(GraveyardMinionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    }
}

