/*
 * Decompiled with CFR 0.152.
 */
package com.lion.graveyard.gui;

import com.google.common.collect.Lists;
import com.lion.graveyard.init.TGBlocks;
import com.lion.graveyard.init.TGRecipeTypes;
import com.lion.graveyard.init.TGScreens;
import com.lion.graveyard.recipe.OssuaryRecipe;
import java.util.List;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class OssuaryScreenHandler
extends AbstractContainerMenu {
    private final ContainerLevelAccess context;
    private final DataSlot selectedRecipe = DataSlot.m_39401_();
    private final Level world;
    private List<OssuaryRecipe> availableRecipes = Lists.newArrayList();
    private ItemStack inputStack = ItemStack.f_41583_;
    long lastTakeTime;
    final Slot inputSlot;
    final Slot outputSlot;
    Runnable contentsChangedListener = () -> {};
    public final Container input = new SimpleContainer(1){

        public void m_6596_() {
            super.m_6596_();
            OssuaryScreenHandler.this.m_6199_((Container)this);
            OssuaryScreenHandler.this.contentsChangedListener.run();
        }
    };
    final ResultContainer output = new ResultContainer();

    public OssuaryScreenHandler(int syncId, Inventory playerInventory) {
        this(syncId, playerInventory, ContainerLevelAccess.f_39287_);
    }

    public OssuaryScreenHandler(int syncId, Inventory playerInventory, final ContainerLevelAccess context) {
        super(TGScreens.OSSUARY_SCREEN_HANDLER, syncId);
        int i;
        this.context = context;
        this.world = playerInventory.f_35978_.m_9236_();
        this.inputSlot = this.m_38897_(new Slot(this.input, 0, 20, 33));
        this.outputSlot = this.m_38897_(new Slot((Container)this.output, 1, 143, 33){

            public boolean m_5857_(ItemStack stack) {
                return false;
            }

            public void m_142406_(Player player, ItemStack stack) {
                stack.m_41678_(player.m_9236_(), player, stack.m_41613_());
                OssuaryScreenHandler.this.output.m_58395_(player, this.getInputStacks());
                ItemStack itemStack = OssuaryScreenHandler.this.inputSlot.m_6201_(1);
                if (!itemStack.m_41619_()) {
                    OssuaryScreenHandler.this.populateResult();
                }
                context.m_39292_((world, pos) -> {
                    long l = world.m_46467_();
                    if (OssuaryScreenHandler.this.lastTakeTime != l) {
                        world.m_5594_((Player)null, pos, SoundEvents.f_11794_, SoundSource.BLOCKS, 1.0f, -3.0f);
                        OssuaryScreenHandler.this.lastTakeTime = l;
                    }
                });
                super.m_142406_(player, stack);
            }

            private List<ItemStack> getInputStacks() {
                return List.of(OssuaryScreenHandler.this.inputSlot.m_7993_());
            }
        });
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
        this.m_38895_(this.selectedRecipe);
    }

    public int getSelectedRecipe() {
        return this.selectedRecipe.m_6501_();
    }

    public List<OssuaryRecipe> getAvailableRecipes() {
        return this.availableRecipes;
    }

    public int getAvailableRecipeCount() {
        return this.availableRecipes.size();
    }

    public boolean canCraft() {
        return this.inputSlot.m_6657_() && !this.availableRecipes.isEmpty();
    }

    public boolean m_6875_(Player player) {
        return AbstractContainerMenu.m_38889_((ContainerLevelAccess)this.context, (Player)player, (Block)TGBlocks.OSSUARY.get());
    }

    public boolean m_6366_(Player player, int id) {
        if (this.isInBounds(id)) {
            this.selectedRecipe.m_6422_(id);
            this.populateResult();
        }
        return true;
    }

    private boolean isInBounds(int id) {
        return id >= 0 && id < this.availableRecipes.size();
    }

    public void m_6199_(Container inventory) {
        ItemStack itemStack = this.inputSlot.m_7993_();
        if (!itemStack.m_150930_(this.inputStack.m_41720_())) {
            this.inputStack = itemStack.m_41777_();
            this.updateInput(inventory, itemStack);
        }
    }

    private void updateInput(Container input, ItemStack stack) {
        this.availableRecipes.clear();
        this.selectedRecipe.m_6422_(-1);
        this.outputSlot.m_269060_(ItemStack.f_41583_);
        if (!stack.m_41619_()) {
            this.availableRecipes = this.world.m_7465_().m_44056_(TGRecipeTypes.OSSUARY_CARVING.get(), input, this.world);
        }
    }

    void populateResult() {
        if (!this.availableRecipes.isEmpty() && this.isInBounds(this.selectedRecipe.m_6501_())) {
            OssuaryRecipe carvingRecipe = this.availableRecipes.get(this.selectedRecipe.m_6501_());
            ItemStack itemStack = carvingRecipe.m_5874_(this.input, this.world.m_9598_());
            if (itemStack.m_246617_(this.world.m_246046_())) {
                this.output.m_6029_((Recipe)carvingRecipe);
                this.outputSlot.m_269060_(itemStack);
            } else {
                this.outputSlot.m_269060_(ItemStack.f_41583_);
            }
        } else {
            this.outputSlot.m_269060_(ItemStack.f_41583_);
        }
        this.m_38946_();
    }

    public MenuType<?> m_6772_() {
        return TGScreens.OSSUARY_SCREEN_HANDLER;
    }

    public void setContentsChangedListener(Runnable contentsChangedListener) {
        this.contentsChangedListener = contentsChangedListener;
    }

    public boolean m_5882_(ItemStack stack, Slot slot) {
        return slot.f_40218_ != this.output && super.m_5882_(stack, slot);
    }

    public ItemStack m_7648_(Player player, int slot) {
        ItemStack itemStack = ItemStack.f_41583_;
        Slot slot2 = (Slot)this.f_38839_.get(slot);
        if (slot2 != null && slot2.m_6657_()) {
            ItemStack itemStack2 = slot2.m_7993_();
            Item item = itemStack2.m_41720_();
            itemStack = itemStack2.m_41777_();
            if (slot == 1) {
                item.m_7836_(itemStack2, player.m_9236_(), player);
                if (!this.m_38903_(itemStack2, 2, 38, true)) {
                    return ItemStack.f_41583_;
                }
                slot2.m_40234_(itemStack2, itemStack);
            } else if (slot == 0 ? !this.m_38903_(itemStack2, 2, 38, false) : (this.world.m_7465_().m_44015_(TGRecipeTypes.OSSUARY_CARVING.get(), (Container)new SimpleContainer(new ItemStack[]{itemStack2}), this.world).isPresent() ? !this.m_38903_(itemStack2, 0, 1, false) : (slot >= 2 && slot < 29 ? !this.m_38903_(itemStack2, 29, 38, false) : slot >= 29 && slot < 38 && !this.m_38903_(itemStack2, 2, 29, false)))) {
                return ItemStack.f_41583_;
            }
            if (itemStack2.m_41619_()) {
                slot2.m_269060_(ItemStack.f_41583_);
            }
            slot2.m_6654_();
            if (itemStack2.m_41613_() == itemStack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot2.m_142406_(player, itemStack2);
            this.m_38946_();
        }
        return itemStack;
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.output.m_8016_(1);
        this.context.m_39292_((world, pos) -> this.m_150411_(player, this.input));
    }
}

