/*
 * Decompiled with CFR 0.152.
 */
package com.lion.graveyard.util;

import com.lion.graveyard.Graveyard;
import com.lion.graveyard.entities.HordeGraveyardEntity;
import com.lion.graveyard.init.TGEntities;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;

public class SpawnHordeCommand {
    public static void register(CommandDispatcher<CommandSourceStack> commandDispatcher) {
        commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"horde").requires(source -> source.m_6761_(3))).then(Commands.m_82127_((String)"trigger").executes(context -> SpawnHordeCommand.executeSpawn((CommandSourceStack)context.getSource()))));
    }

    public static int executeSpawn(CommandSourceStack source) {
        source.m_288197_(() -> Component.m_237113_((String)"Spawned a graveyard horde."), false);
        int o = Graveyard.getConfig().getHorde((ResourceLocation)new ResourceLocation((String)"graveyard", (String)"horde_spawn")).mobSpawnAttempts;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos(source.m_81371_().m_7096_(), source.m_81371_().m_7098_(), source.m_81371_().m_7094_());
        ServerLevel world = source.m_81372_();
        RandomSource random = source.m_81372_().m_213780_();
        boolean illagerSpawn = random.m_188499_();
        for (int p = 0; p < o; ++p) {
            mutable.m_142448_(world.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (BlockPos)mutable).m_123342_());
            if (p == 0) {
                if (!SpawnHordeCommand.spawnHordeEntity(world, (BlockPos)mutable, random, true, illagerSpawn)) {
                    break;
                }
            } else {
                SpawnHordeCommand.spawnHordeEntity(world, (BlockPos)mutable, random, false, illagerSpawn);
            }
            mutable.m_142451_(mutable.m_123341_() + random.m_188503_(5) - random.m_188503_(5));
            mutable.m_142443_(mutable.m_123343_() + random.m_188503_(5) - random.m_188503_(5));
        }
        return 1;
    }

    private static boolean spawnHordeEntity(ServerLevel world, BlockPos pos, RandomSource random, boolean captain, boolean illagerSpawn) {
        HordeGraveyardEntity hordeEntity;
        if (!illagerSpawn) {
            hordeEntity = random.m_188499_() ? (HordeGraveyardEntity)TGEntities.GHOUL.get().m_20615_((Level)world) : (HordeGraveyardEntity)TGEntities.REVENANT.get().m_20615_((Level)world);
        } else {
            int rand = random.m_188503_(5);
            switch (rand) {
                case 0: 
                case 1: {
                    hordeEntity = (HordeGraveyardEntity)TGEntities.CORRUPTED_PILLAGER.get().m_20615_((Level)world);
                    break;
                }
                case 2: 
                case 3: {
                    hordeEntity = (HordeGraveyardEntity)TGEntities.CORRUPTED_VINDICATOR.get().m_20615_((Level)world);
                    break;
                }
                default: {
                    hordeEntity = (HordeGraveyardEntity)TGEntities.ACOLYTE.get().m_20615_((Level)world);
                }
            }
        }
        if (hordeEntity != null) {
            if (captain) {
                hordeEntity.setPatrolLeader(true);
                hordeEntity.setRandomPatrolTarget();
                world.m_7654_().m_6846_().m_240416_((Component)Component.m_237113_((String)("A large Graveyard horde of undead appeared at x:" + pos.m_123341_() + " y:" + pos.m_123342_() + " z:" + pos.m_123343_() + ".")), false);
            }
            hordeEntity.m_6034_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
            hordeEntity.m_6518_((ServerLevelAccessor)world, world.m_6436_(pos), MobSpawnType.PATROL, null, null);
            hordeEntity.m_21573_().m_26573_();
            world.m_47205_((Entity)hordeEntity);
            return true;
        }
        return false;
    }
}

