/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.unilib.core.utils;

import com.gitlab.cdagaming.unilib.core.CoreUtils;
import io.github.cdagaming.unicore.integrations.versioning.VersionComparator;
import io.github.cdagaming.unicore.utils.FileUtils;
import io.github.cdagaming.unicore.utils.StringUtils;
import io.github.cdagaming.unicore.utils.UrlUtils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ModUpdaterUtils {
    private final String modID;
    private final String updateUrl;
    private final Map<String, String> changelogData = StringUtils.newLinkedHashMap();
    private final String currentVersion;
    private final String currentGameVersion;
    private UpdateState currentState = UpdateState.PENDING;
    private String downloadUrl;
    private String targetLatestVersion;
    private String targetRecommendedVersion;
    private String targetVersion;

    public ModUpdaterUtils(String modID, String updateUrl, String currentVersion, String currentGameVersion) {
        this.modID = modID;
        this.updateUrl = updateUrl;
        this.currentGameVersion = currentGameVersion;
        this.currentVersion = currentVersion;
    }

    public void flushData() {
        this.currentState = UpdateState.PENDING;
        this.targetRecommendedVersion = "";
        this.targetLatestVersion = "";
        this.targetVersion = "";
        this.downloadUrl = "";
        this.changelogData.clear();
    }

    public UpdateState getStatus() {
        return this.currentState;
    }

    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public boolean hasChanges() {
        return !this.changelogData.isEmpty();
    }

    public Set<Map.Entry<String, String>> getChanges() {
        return this.changelogData.entrySet();
    }

    public void checkForUpdates() {
        this.checkForUpdates(null);
    }

    public void checkForUpdates(Runnable callback) {
        CoreUtils.getThreadFactory().newThread(() -> this.process(callback)).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(Runnable callback) {
        try {
            boolean hasLatest;
            this.flushData();
            if (StringUtils.isNullOrEmpty(this.updateUrl)) {
                return;
            }
            CoreUtils.LOG.info("Starting version check for \"%1$s\" (MC %2$s) at \"%3$s\"", this.modID, this.currentGameVersion, this.updateUrl);
            String data = UrlUtils.getURLText(this.updateUrl, "UTF-8");
            CoreUtils.LOG.debugInfo("Received update data:\\n%1$s", data);
            Map json = FileUtils.getJsonData(data, Map.class, new FileUtils.Modifiers[0]);
            Map promos = (Map)json.get("promos");
            this.downloadUrl = (String)json.get("homepage");
            this.targetRecommendedVersion = (String)promos.get(this.currentGameVersion + "-recommended");
            this.targetLatestVersion = (String)promos.get(this.currentGameVersion + "-latest");
            VersionComparator cmp = new VersionComparator();
            boolean hasRecommended = !StringUtils.isNullOrEmpty(this.targetRecommendedVersion);
            boolean bl = hasLatest = !StringUtils.isNullOrEmpty(this.targetLatestVersion);
            if (hasRecommended) {
                int diff = cmp.compare(this.targetRecommendedVersion, this.currentVersion);
                if (diff == 0) {
                    this.currentState = UpdateState.UP_TO_DATE;
                } else if (diff < 0) {
                    this.currentState = UpdateState.AHEAD;
                    if (hasLatest && cmp.compare(this.currentVersion, this.targetLatestVersion) < 0) {
                        this.currentState = UpdateState.OUTDATED;
                        this.targetVersion = this.targetLatestVersion;
                    }
                } else {
                    this.currentState = UpdateState.OUTDATED;
                    this.targetVersion = this.targetRecommendedVersion;
                }
            } else if (hasLatest) {
                this.currentState = cmp.compare(this.currentVersion, this.targetLatestVersion) < 0 ? UpdateState.BETA_OUTDATED : UpdateState.BETA;
                this.targetVersion = this.targetLatestVersion;
            } else {
                this.currentState = UpdateState.BETA;
            }
            CoreUtils.LOG.info("Received update status for \"%1$s\" -> %2$s (Target version: \"%3$s\")", this.modID, this.currentState.getDisplayName(), this.targetVersion);
            this.changelogData.clear();
            Map tmp = (Map)json.get(this.currentGameVersion);
            if (tmp != null) {
                List<String> ordered = StringUtils.newArrayList();
                for (String key : tmp.keySet()) {
                    if (cmp.compare(key, this.currentVersion) <= 0 || !StringUtils.isNullOrEmpty(this.targetVersion) && cmp.compare(key, this.targetVersion) >= 1) continue;
                    ordered.add(key);
                }
                Collections.sort(ordered);
                for (String ver : ordered) {
                    this.changelogData.put(ver, (String)tmp.get(ver));
                }
            }
        }
        catch (Throwable ex) {
            CoreUtils.LOG.error("Failed to check for updates, enable debug mode to see errors...", new Object[0]);
            CoreUtils.LOG.debugError(ex);
            this.currentState = UpdateState.FAILED;
        }
        finally {
            if (callback != null) {
                callback.run();
            }
        }
    }

    public static enum UpdateState {
        FAILED,
        UP_TO_DATE("Release"),
        AHEAD,
        OUTDATED,
        BETA_OUTDATED("Beta (Outdated)"),
        BETA,
        PENDING;

        private final String displayName;

        private UpdateState() {
            this.displayName = StringUtils.formatWord(this.name().toLowerCase());
        }

        private UpdateState(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }
}

