/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.client;

import com.mrcrayfish.backpacked.Config;
import com.mrcrayfish.backpacked.client.Keys;
import com.mrcrayfish.backpacked.client.model.backpack.BackpackModel;
import com.mrcrayfish.backpacked.client.renderer.entity.layers.BackpackLayer;
import com.mrcrayfish.backpacked.common.backpack.ModelProperty;
import com.mrcrayfish.backpacked.data.pickpocket.PickpocketChallenge;
import com.mrcrayfish.backpacked.inventory.ExtendedPlayerInventory;
import com.mrcrayfish.backpacked.network.Network;
import com.mrcrayfish.backpacked.network.message.MessageEntityBackpack;
import com.mrcrayfish.backpacked.network.message.MessageOpenBackpack;
import com.mrcrayfish.backpacked.platform.ClientServices;
import com.mrcrayfish.backpacked.platform.Services;
import com.mrcrayfish.backpacked.util.PickpocketUtil;
import com.mrcrayfish.framework.api.event.ClientConnectionEvents;
import com.mrcrayfish.framework.api.event.IFrameworkEvent;
import com.mrcrayfish.framework.api.event.InputEvents;
import com.mrcrayfish.framework.api.event.ScreenEvents;
import com.mrcrayfish.framework.api.event.TickEvents;
import com.mrcrayfish.framework.event.IClientConnectionEvent;
import com.mrcrayfish.framework.event.IInputEvent;
import com.mrcrayfish.framework.event.IScreenEvent;
import com.mrcrayfish.framework.event.ITickEvent;
import com.mrcrayfish.framework.network.message.IMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ClientEvents {
    public static final ResourceLocation EMPTY_BACKPACK_SLOT = new ResourceLocation("backpacked", "item/empty_backpack_slot");
    private static boolean initializedSlot = false;

    public static void init() {
        TickEvents.END_CLIENT.register((IFrameworkEvent)((ITickEvent.EndClient)ClientEvents::onClientTickEnd));
        ClientConnectionEvents.LOGGING_IN.register((IFrameworkEvent)((IClientConnectionEvent.LoggingIn)ClientEvents::onPlayerLogin));
        ScreenEvents.AFTER_DRAW_CONTAINER_BACKGROUND.register((IFrameworkEvent)((IScreenEvent.AfterDrawContainerBackground)ClientEvents::onAfterDrawBackground));
        ScreenEvents.AFTER_DRAW_CONTAINER_BACKGROUND.register((IFrameworkEvent)((IScreenEvent.AfterDrawContainerBackground)ClientEvents::repositionSlot));
        ScreenEvents.INIT.register((IFrameworkEvent)((IScreenEvent.Init)ClientEvents::onScreenInit));
        InputEvents.KEY.register((IFrameworkEvent)((IInputEvent.Key)ClientEvents::onKeyInput));
        InputEvents.CLICK.register((IFrameworkEvent)((IInputEvent.Click)ClientEvents::onInteraction));
    }

    private static void onPlayerLogin(LocalPlayer player, MultiPlayerGameMode gameMode, Connection connection) {
        Config.updateBannedItemsList();
    }

    private static void onAfterDrawBackground(AbstractContainerScreen<?> screen, GuiGraphics graphics, int mouseX, int mouseY) {
        CreativeModeInventoryScreen inventory;
        if (Services.BACKPACK.isUsingThirdPartySlot()) {
            return;
        }
        if (screen instanceof InventoryScreen) {
            InventoryScreen inventory2 = (InventoryScreen)screen;
            int left = ClientServices.SCREEN.getScreenLeftPos((AbstractContainerScreen<?>)inventory2);
            int top = ClientServices.SCREEN.getScreenTopPos((AbstractContainerScreen<?>)inventory2);
            graphics.m_280163_(AbstractContainerScreen.f_97725_, left + 76, top + 43, 7.0f, 7.0f, 18, 18, 256, 256);
        } else if (screen instanceof CreativeModeInventoryScreen && (inventory = (CreativeModeInventoryScreen)screen).m_258017_()) {
            int left = ClientServices.SCREEN.getScreenLeftPos((AbstractContainerScreen<?>)inventory);
            int top = ClientServices.SCREEN.getScreenTopPos((AbstractContainerScreen<?>)inventory);
            graphics.m_280163_(AbstractContainerScreen.f_97725_, left + 126, top + 19, 7.0f, 7.0f, 18, 18, 256, 256);
        }
    }

    public static void onKeyInput(int key, int scanCode, int action, int modifiers) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ != null && mc.f_91080_ == null) {
            LocalPlayer player = mc.f_91074_;
            if (Keys.KEY_BACKPACK.m_90857_() && Keys.KEY_BACKPACK.m_90859_() && !Services.BACKPACK.getBackpackStack((Player)player).m_41619_()) {
                Network.getPlay().sendToServer((IMessage)new MessageOpenBackpack());
            }
        }
    }

    private static void onClientTickEnd() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null || mc.f_91074_ == null) {
            return;
        }
        List players = mc.f_91073_.m_142425_((EntityTypeTest)EntityType.f_20532_, mc.f_91074_.m_20191_().m_82400_(16.0), player -> true);
        for (Player player2 : players) {
            String modelName;
            BackpackModel model;
            ItemStack stack;
            if (Services.BACKPACK.isUsingThirdPartySlot() && !Services.BACKPACK.isBackpackVisible(player2) || (stack = Services.BACKPACK.getBackpackStack(player2)).m_41619_() || !ClientEvents.canShowBackpackEffects(stack) || (model = BackpackLayer.getModel(modelName = stack.m_41784_().m_128461_("BackpackModel")).get()) == null) continue;
            model.tickForPlayer(PickpocketUtil.getBackpackBox((LivingEntity)player2, 1.0f).m_82399_(), player2);
        }
    }

    public static boolean canShowBackpackEffects(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128425_(ModelProperty.SHOW_EFFECTS.getTagName(), 1)) {
            return tag.m_128471_(ModelProperty.SHOW_EFFECTS.getTagName());
        }
        return true;
    }

    private static boolean onInteraction(boolean attack, boolean use, boolean pick, InteractionHand hand) {
        if (!use || hand != InteractionHand.MAIN_HAND) {
            return false;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null || mc.f_91074_ == null || mc.f_91072_ == null) {
            return false;
        }
        double range = (Double)Config.SERVER.common.pickpocketMaxReachDistance.get();
        ArrayList entities = new ArrayList();
        if (((Boolean)Config.SERVER.common.pickpocketBackpacks.get()).booleanValue()) {
            entities.addAll(mc.f_91073_.m_142425_((EntityTypeTest)EntityType.f_20532_, mc.f_91074_.m_20191_().m_82400_(range), player -> !Services.BACKPACK.getBackpackStack((Player)player).m_41619_() && !player.equals((Object)mc.f_91074_) && PickpocketUtil.canPickpocketEntity((LivingEntity)player, (Player)mc.f_91074_)));
        }
        entities.addAll(mc.f_91073_.m_142425_((EntityTypeTest)EntityType.f_20494_, mc.f_91074_.m_20191_().m_82400_((double)mc.f_91072_.m_105286_()), entity -> PickpocketChallenge.get((Entity)entity).map(PickpocketChallenge::isBackpackEquipped).orElse(false) != false && PickpocketUtil.canPickpocketEntity((LivingEntity)entity, (Player)mc.f_91074_, mc.f_91072_.m_105286_())));
        if (entities.isEmpty()) {
            return false;
        }
        Vec3 start = mc.f_91074_.m_20299_(1.0f);
        Vec3 end = mc.f_91074_.m_20252_(1.0f).m_82490_((double)mc.f_91072_.m_105286_()).m_82549_(start);
        double closestDistance = Double.MAX_VALUE;
        LivingEntity hitEntity = null;
        for (LivingEntity entity2 : entities) {
            double distance;
            AABB box = PickpocketUtil.getBackpackBox(entity2, 1.0f);
            Optional optionalHitVec = box.m_82371_(start, end);
            if (optionalHitVec.isEmpty() || !((distance = start.m_82554_((Vec3)optionalHitVec.get())) < closestDistance)) continue;
            closestDistance = distance;
            hitEntity = entity2;
        }
        if (hitEntity != null) {
            if (PickpocketUtil.canSeeBackpack(hitEntity, (Player)mc.f_91074_)) {
                Network.getPlay().sendToServer((IMessage)new MessageEntityBackpack(hitEntity.m_19879_()));
                mc.f_91074_.m_6674_(hand);
            }
            return true;
        }
        return false;
    }

    private static void onScreenInit(Screen screen) {
        if (screen instanceof CreativeModeInventoryScreen) {
            initializedSlot = false;
        }
    }

    private static void repositionSlot(AbstractContainerScreen<?> screen, GuiGraphics graphics, int mouseX, int mouseY) {
        if (Services.BACKPACK.isUsingThirdPartySlot()) {
            return;
        }
        if (!(screen instanceof CreativeModeInventoryScreen)) {
            initializedSlot = false;
            return;
        }
        CreativeModeInventoryScreen creativeScreen = (CreativeModeInventoryScreen)screen;
        if (creativeScreen.m_258017_()) {
            if (!initializedSlot) {
                initializedSlot = true;
                NonNullList slots = ((CreativeModeInventoryScreen.ItemPickerMenu)creativeScreen.m_6262_()).f_38839_;
                Slot backpackSlot = slots.stream().filter(slot -> slot.f_40218_ instanceof ExtendedPlayerInventory && slot.m_150661_() == 41).findFirst().orElse(null);
                if (backpackSlot != null) {
                    int index = slots.indexOf(backpackSlot);
                    Slot newSlot = ClientServices.SCREEN.createCreativeSlotWrapper(backpackSlot, index, 127, 20);
                    backpackSlot.f_40219_ = index;
                    slots.set(index, newSlot);
                }
            }
        } else {
            initializedSlot = false;
        }
    }
}

