/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.client;

import com.mrcrayfish.backpacked.Backpacked;
import com.mrcrayfish.backpacked.client.ForgeClientEvents;
import com.mrcrayfish.backpacked.client.gui.screen.inventory.BackpackScreen;
import com.mrcrayfish.backpacked.client.model.ModelInstances;
import com.mrcrayfish.backpacked.client.model.backpack.BambooBasketBackpackModel;
import com.mrcrayfish.backpacked.client.model.backpack.CardboardBoxBackpackModel;
import com.mrcrayfish.backpacked.client.model.backpack.ClassicBackpackModel;
import com.mrcrayfish.backpacked.client.model.backpack.CogwheelBackpackModel;
import com.mrcrayfish.backpacked.client.model.backpack.EndCrystalBackpackModel;
import com.mrcrayfish.backpacked.client.model.backpack.HoneyJarBackpackModel;
import com.mrcrayfish.backpacked.client.model.backpack.MiniChestBackpackModel;
import com.mrcrayfish.backpacked.client.model.backpack.PiglinPackBackpackModel;
import com.mrcrayfish.backpacked.client.model.backpack.RocketBackpackModel;
import com.mrcrayfish.backpacked.client.model.backpack.SheepPlushBackpackModel;
import com.mrcrayfish.backpacked.client.model.backpack.StandardBackpackModel;
import com.mrcrayfish.backpacked.client.model.backpack.TrashCanBackpackModel;
import com.mrcrayfish.backpacked.client.model.backpack.TurtleShellBackpackModel;
import com.mrcrayfish.backpacked.client.model.backpack.WanderingBagBackpackModel;
import com.mrcrayfish.backpacked.client.renderer.entity.layers.BackpackLayer;
import com.mrcrayfish.backpacked.client.renderer.entity.layers.ShelfRenderer;
import com.mrcrayfish.backpacked.client.renderer.entity.layers.VillagerBackpackLayer;
import com.mrcrayfish.backpacked.core.ModBlockEntities;
import com.mrcrayfish.backpacked.core.ModContainers;
import com.mrcrayfish.backpacked.core.ModLayerDefinitions;
import com.mrcrayfish.backpacked.integration.Controllable;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.WanderingTraderRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.loading.FMLLoader;

public class ClientHandler {
    public static void init() {
        MenuScreens.m_96206_((MenuType)((MenuType)ModContainers.BACKPACK.get()), BackpackScreen::new);
        if (Backpacked.isControllableLoaded()) {
            Controllable.init();
        }
        if (!FMLLoader.isProduction()) {
            MinecraftForge.EVENT_BUS.register((Object)new ForgeClientEvents());
        }
    }

    public static void onRegisterLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(ModLayerDefinitions.STANDARD, StandardBackpackModel::createLayer);
        event.registerLayerDefinition(ModLayerDefinitions.CLASSIC, ClassicBackpackModel::createLayer);
        event.registerLayerDefinition(ModLayerDefinitions.BAMBOO_BASKET, BambooBasketBackpackModel::createLayer);
        event.registerLayerDefinition(ModLayerDefinitions.ROCKET, RocketBackpackModel::createLayer);
        event.registerLayerDefinition(ModLayerDefinitions.MINI_CHEST, MiniChestBackpackModel::createLayer);
        event.registerLayerDefinition(ModLayerDefinitions.TRASH_CAN, TrashCanBackpackModel::createLayer);
        event.registerLayerDefinition(ModLayerDefinitions.HONEY_JAR, HoneyJarBackpackModel::createLayer);
        event.registerLayerDefinition(ModLayerDefinitions.TURTLE_SHELL, TurtleShellBackpackModel::createLayer);
        event.registerLayerDefinition(ModLayerDefinitions.CARDBOARD_BOX, CardboardBoxBackpackModel::createLayer);
        event.registerLayerDefinition(ModLayerDefinitions.SHEEP_PLUSH, SheepPlushBackpackModel::createLayer);
        event.registerLayerDefinition(ModLayerDefinitions.WANDERING_BAG, WanderingBagBackpackModel::createLayer);
        event.registerLayerDefinition(ModLayerDefinitions.PIGLIN_PACK, PiglinPackBackpackModel::createLayer);
        event.registerLayerDefinition(ModLayerDefinitions.END_CRYSTAL, EndCrystalBackpackModel::createLayer);
        event.registerLayerDefinition(ModLayerDefinitions.COGWHEEL, CogwheelBackpackModel::createLayer);
    }

    public static void onRegisterRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntities.SHELF.get(), ShelfRenderer::new);
    }

    public static void onAddLayers(EntityRenderersEvent.AddLayers event) {
        ClientHandler.addBackpackLayer(event.getSkin("default"));
        ClientHandler.addBackpackLayer(event.getSkin("slim"));
        LivingEntityRenderer renderer = event.getRenderer(EntityType.f_20494_);
        if (renderer instanceof WanderingTraderRenderer) {
            WanderingTraderRenderer traderRenderer = (WanderingTraderRenderer)renderer;
            traderRenderer.m_115326_(new VillagerBackpackLayer(traderRenderer));
        }
        ModelInstances.get().loadModels(event.getEntityModels());
    }

    private static void addBackpackLayer(LivingEntityRenderer<?, ?> renderer) {
        if (renderer instanceof PlayerRenderer) {
            PlayerRenderer playerRenderer = (PlayerRenderer)renderer;
            playerRenderer.m_115326_(new BackpackLayer(playerRenderer));
        }
    }
}

