/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.client.model.backpack;

import com.mrcrayfish.backpacked.client.model.backpack.BackpackModel;
import javax.annotation.Nullable;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.joml.Vector3d;

public class EndCrystalBackpackModel
extends BackpackModel {
    private static final ResourceLocation TEXTURE = new ResourceLocation("backpacked", "textures/entity/crystal_backpack.png");
    private static final Vector3d SHELF_OFFSET = new Vector3d(0.0, 8.0, -6.0);
    private final ModelPart crystal;

    public EndCrystalBackpackModel(ModelPart root) {
        super(root, TEXTURE);
        this.crystal = this.bag.m_171324_("crystal");
    }

    public static LayerDefinition createLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.m_171576_();
        PartDefinition backpack = root.m_171599_("backpack", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition bag = backpack.m_171599_("bag", CubeListBuilder.m_171558_().m_171514_(0, 10).m_171488_(-3.5f, 0.0f, 0.0f, 7.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-9.0f, (float)0.0f));
        PartDefinition crystal = bag.m_171599_("crystal", CubeListBuilder.m_171558_().m_171514_(14, 16).m_171488_(-2.0f, -2.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(-0.25f)), PartPose.m_171419_((float)0.0f, (float)4.0f, (float)5.25f));
        PartDefinition frame = crystal.m_171599_("frame", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.5f, -2.5f, -2.75f, 5.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.7854f, (float)0.0f, (float)0.6109f));
        PartDefinition strap = bag.m_171599_("strap", CubeListBuilder.m_171558_().m_171514_(0, 20).m_171488_(5.0f, -8.0f, -4.0f, 1.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(15, 0).m_171480_().m_171488_(6.0f, -1.0f, -4.0f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(0, 20).m_171480_().m_171488_(0.0f, -8.0f, -4.0f, 1.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(15, 0).m_171488_(-1.0f, -1.0f, -4.0f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-3.0f, (float)8.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)32, (int)32);
    }

    @Override
    public void setupAngles(@Nullable Player player, int animationTick, float partialTick) {
        double rotation = (float)animationTick + partialTick;
        this.crystal.f_104201_ = 4.0f;
        this.crystal.f_104201_ = (float)((double)this.crystal.f_104201_ + Math.sin(rotation / 4.0));
        this.crystal.f_104204_ = (float)Math.toRadians(rotation * 3.0);
    }

    @Override
    public Vector3d getShelfOffset() {
        return SHELF_OFFSET;
    }
}

