/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common;

import com.mrcrayfish.backpacked.Config;
import com.mrcrayfish.backpacked.data.tracker.UnlockManager;
import com.mrcrayfish.backpacked.data.tracker.impl.BiomeExploreProgressTracker;
import com.mrcrayfish.backpacked.data.tracker.impl.CraftingProgressTracker;
import com.mrcrayfish.backpacked.item.BackpackItem;
import com.mrcrayfish.backpacked.platform.Services;
import com.mrcrayfish.framework.api.event.IFrameworkEvent;
import com.mrcrayfish.framework.api.event.PlayerEvents;
import com.mrcrayfish.framework.api.event.TickEvents;
import com.mrcrayfish.framework.event.IPlayerEvent;
import com.mrcrayfish.framework.event.ITickEvent;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundTakeItemEntityPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.biome.Biome;

public class BackpackEvents {
    public static void init() {
        TickEvents.END_PLAYER.register((IFrameworkEvent)((ITickEvent.EndPlayer)BackpackEvents::onPlayerTick));
        PlayerEvents.PICKUP_ITEM.register((IFrameworkEvent)((IPlayerEvent.PickupItem)BackpackEvents::onPickupItem));
        PlayerEvents.CRAFT_ITEM.register((IFrameworkEvent)((IPlayerEvent.CraftItem)BackpackEvents::onCraftedItem));
    }

    private static boolean onPickupItem(Player player, ItemEntity entity) {
        if (((Boolean)Config.SERVER.common.autoEquipBackpackOnPickup.get()).booleanValue() && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ItemStack stack = entity.m_32055_();
            if (!(stack.m_41720_() instanceof BackpackItem)) {
                return false;
            }
            if (Services.BACKPACK.getBackpackStack((Player)serverPlayer).m_41619_()) {
                if (Services.BACKPACK.setBackpackStack((Player)serverPlayer, stack)) {
                    ((ServerLevel)entity.m_9236_()).m_7726_().m_8445_((Entity)entity, (Packet)new ClientboundTakeItemEntityPacket(entity.m_19879_(), serverPlayer.m_19879_(), stack.m_41613_()));
                    entity.m_146870_();
                }
                return true;
            }
        }
        return false;
    }

    private static void onCraftedItem(Player player, ItemStack stack, Container inventory) {
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        UnlockManager.get(player).ifPresent(unlockTracker -> unlockTracker.getProgressTrackerMap().forEach((location, progressTracker) -> {
            if (progressTracker instanceof CraftingProgressTracker && !progressTracker.isComplete()) {
                ((CraftingProgressTracker)progressTracker).processCrafted(stack, serverPlayer);
            }
        }));
    }

    private static void onPlayerTick(Player player) {
        if (player.m_9236_().m_5776_()) {
            return;
        }
        if (player.f_19797_ % 20 != 0) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        ServerLevel world = serverPlayer.m_284548_();
        BlockPos playerPosition = serverPlayer.m_20183_();
        world.m_9598_().m_175515_(Registries.f_256952_).m_7854_((Object)((Biome)world.m_204166_(playerPosition).m_203334_())).ifPresent(key -> UnlockManager.get((Player)serverPlayer).ifPresent(unlockTracker -> unlockTracker.getProgressTrackerMap().forEach((location, progressTracker) -> {
            if (progressTracker instanceof BiomeExploreProgressTracker && !progressTracker.isComplete()) {
                ((BiomeExploreProgressTracker)progressTracker).explore((ResourceKey<Biome>)key, serverPlayer);
            }
        })));
    }
}

