/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common;

import com.mrcrayfish.backpacked.Config;
import com.mrcrayfish.backpacked.common.IMovedAccess;
import com.mrcrayfish.backpacked.common.backpack.impl.WanderingBagBackpack;
import com.mrcrayfish.backpacked.data.pickpocket.PickpocketChallenge;
import com.mrcrayfish.backpacked.data.tracker.UnlockManager;
import com.mrcrayfish.backpacked.network.Network;
import com.mrcrayfish.backpacked.network.message.MessageSyncVillagerBackpack;
import com.mrcrayfish.backpacked.platform.Services;
import com.mrcrayfish.framework.api.event.EntityEvents;
import com.mrcrayfish.framework.api.event.IFrameworkEvent;
import com.mrcrayfish.framework.api.event.PlayerEvents;
import com.mrcrayfish.framework.api.event.TickEvents;
import com.mrcrayfish.framework.event.IEntityEvent;
import com.mrcrayfish.framework.event.IPlayerEvent;
import com.mrcrayfish.framework.event.ITickEvent;
import com.mrcrayfish.framework.network.message.IMessage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class WanderingTraderEvents {
    public static final Component WANDERING_BAG_TRANSLATION = Component.m_237115_((String)"backpacked.backpack.wandering_bag");

    public static void init() {
        EntityEvents.JOIN_LEVEL.register((IFrameworkEvent)((IEntityEvent.JoinLevel)WanderingTraderEvents::onEntityJoinLevel));
        PlayerEvents.START_TRACKING_ENTITY.register((IFrameworkEvent)((IPlayerEvent.StartTrackingEntity)WanderingTraderEvents::onStartTracking));
        TickEvents.START_LIVING_ENTITY.register((IFrameworkEvent)((ITickEvent.StartLivingEntity)WanderingTraderEvents::onTickLivingEntity));
    }

    private static void onEntityJoinLevel(Entity entity, Level level, boolean disk) {
        if (!entity.m_9236_().m_5776_() && entity instanceof WanderingTrader) {
            WanderingTrader trader = (WanderingTrader)entity;
            if (((Boolean)Config.COMMON.common.wanderingTrader.spawnBackpackOnWanderingTraders.get()).booleanValue()) {
                PickpocketChallenge.get((Entity)trader).ifPresent(data -> {
                    if (!data.isInitialized()) {
                        boolean equipped = trader.m_9236_().f_46441_.m_188503_(((Integer)Config.COMMON.common.wanderingTrader.wanderingTraderBackpackChance.get()).intValue()) == 0;
                        data.setBackpackEquipped(equipped);
                        data.setInitialized();
                    }
                });
                WanderingTraderEvents.patchTraderAiGoals(trader);
            }
        }
    }

    private static void onStartTracking(Entity entity, Player player) {
        if (entity.m_6095_() != EntityType.f_20494_) {
            return;
        }
        WanderingTrader trader = (WanderingTrader)entity;
        PickpocketChallenge.get((Entity)trader).ifPresent(data -> {
            if (data.isBackpackEquipped()) {
                Network.getPlay().sendToPlayer(() -> (ServerPlayer)player, (IMessage)new MessageSyncVillagerBackpack(entity.m_19879_()));
            }
        });
    }

    private static void onTickLivingEntity(LivingEntity entity) {
        Level level = entity.m_9236_();
        if (level.m_5776_() || entity.m_6095_() != EntityType.f_20494_) {
            return;
        }
        WanderingTrader trader = (WanderingTrader)entity;
        if (trader.m_35303_() > 0) {
            trader.m_35319_(trader.m_35303_() - 1);
        }
        PickpocketChallenge.get((Entity)entity).ifPresent(data -> {
            if (!data.isBackpackEquipped()) {
                return;
            }
            Map<Player, Long> detectedPlayers = data.getDetectedPlayers();
            List<Player> newDetectedPlayers = WanderingTraderEvents.findDetectedPlayers((LivingEntity)trader);
            newDetectedPlayers.forEach(player -> detectedPlayers.put((Player)player, level.m_46467_()));
            detectedPlayers.entrySet().removeIf(WanderingTraderEvents.createForgetPlayerPredicate(trader, level));
            data.getDislikedPlayers().entrySet().removeIf(entry -> level.m_46467_() - (Long)entry.getValue() > (long)((Integer)Config.COMMON.common.wanderingTrader.dislikeCooldown.get()).intValue());
        });
    }

    public static boolean onInteract(Entity target, Player player) {
        Level level = target.m_9236_();
        if (!level.m_5776_() && target instanceof WanderingTrader) {
            WanderingTrader trader = (WanderingTrader)target;
            if (!((Boolean)Config.COMMON.common.wanderingTrader.dislikedPlayersCanTrade.get()).booleanValue() && PickpocketChallenge.get((Entity)trader).map(data -> data.isBackpackEquipped() && data.isDislikedPlayer(player)).orElse(false).booleanValue()) {
                trader.m_35319_(20);
                level.m_6269_(null, (Entity)trader, SoundEvents.f_12507_, SoundSource.NEUTRAL, 1.0f, 1.5f);
                return true;
            }
        }
        return false;
    }

    private static List<Player> findDetectedPlayers(LivingEntity entity) {
        return entity.m_9236_().m_142425_((EntityTypeTest)EntityType.f_20532_, entity.m_20191_().m_82400_(WanderingTraderEvents.getMaxDetectionDistance()), player -> WanderingTraderEvents.isPlayerInLivingEntityVision(entity, player) && WanderingTraderEvents.isPlayerSeenByLivingEntity(entity, player, WanderingTraderEvents.getMaxDetectionDistance()) || !player.m_6047_() && WanderingTraderEvents.isPlayerMoving(player));
    }

    private static Predicate<Map.Entry<Player, Long>> createForgetPlayerPredicate(WanderingTrader trader, Level world) {
        return entry -> !((Player)entry.getKey()).m_6084_() || (double)((Player)entry.getKey()).m_20270_((Entity)trader) > WanderingTraderEvents.getMaxDetectionDistance() * 2.0 || world.m_46467_() - (Long)entry.getValue() > (long)((Integer)Config.COMMON.common.wanderingTrader.wanderingTraderForgetTime.get()).intValue() && (double)((Player)entry.getKey()).m_20270_((Entity)trader) >= (Double)Config.COMMON.common.wanderingTrader.wanderingTraderMaxDetectionDistance.get();
    }

    private static boolean isPlayerInLivingEntityVision(LivingEntity entity, Player player) {
        if (WanderingTraderEvents.isPlayerInvisible(player)) {
            return false;
        }
        Vec3 between = entity.m_20182_().m_82546_(player.m_20182_());
        float angle = (float)Math.toDegrees(Mth.m_14136_((double)between.f_82481_, (double)between.f_82479_)) - 90.0f;
        return Mth.m_14145_((float)(entity.f_20885_ + 180.0f), (float)angle) <= 90.0f;
    }

    private static boolean isPlayerSeenByLivingEntity(LivingEntity entity, Player player, double distance) {
        Vec3 playerEyePos;
        if (WanderingTraderEvents.isPlayerInvisible(player)) {
            return false;
        }
        if (entity.m_9236_() != player.m_9236_() || (double)entity.m_20270_((Entity)player) > distance) {
            return false;
        }
        Vec3 livingEyePos = new Vec3(entity.m_20185_(), entity.m_20188_(), entity.m_20189_());
        if (WanderingTraderEvents.performRayTrace(livingEyePos, playerEyePos = new Vec3(player.m_20185_(), player.m_20188_(), player.m_20189_()), (Entity)entity).m_6662_() == HitResult.Type.MISS) {
            return true;
        }
        Vec3 playerLegPos = new Vec3(player.m_20185_(), player.m_20186_() + 0.5, player.m_20189_());
        return WanderingTraderEvents.performRayTrace(livingEyePos, playerLegPos, (Entity)entity).m_6662_() == HitResult.Type.MISS;
    }

    private static boolean isPlayerInvisible(Player player) {
        return player.m_21023_(MobEffects.f_19609_) && player.m_21207_() <= 0.0f && StreamSupport.stream(player.m_6167_().spliterator(), false).allMatch(ItemStack::m_41619_) && Services.BACKPACK.getBackpackStack(player).m_41619_();
    }

    private static BlockHitResult performRayTrace(Vec3 start, Vec3 end, Entity source) {
        return source.m_9236_().m_45547_(new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, source));
    }

    private static boolean isPlayerMoving(Player player) {
        return ((IMovedAccess)player).backpackedMoved();
    }

    public static void openBackpack(WanderingTrader trader, ServerPlayer openingPlayer) {
        PickpocketChallenge.get((Entity)trader).ifPresent(data -> {
            if (!data.isBackpackEquipped()) {
                return;
            }
            if (data.getDetectedPlayers().containsKey(openingPlayer)) {
                trader.m_35319_(20);
                trader.m_21563_().m_24964_(openingPlayer.m_20299_(1.0f));
                trader.m_9236_().m_6269_(null, (Entity)trader, SoundEvents.f_12507_, SoundSource.NEUTRAL, 1.0f, 1.5f);
                trader.m_9236_().m_142425_((EntityTypeTest)EntityType.f_20488_, trader.m_20191_().m_82400_(((Double)Config.COMMON.common.wanderingTrader.wanderingTraderMaxDetectionDistance.get()).doubleValue()), entity -> true).forEach(llama -> llama.m_6710_((LivingEntity)openingPlayer));
                ((ServerLevel)trader.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123792_, trader.m_20185_(), trader.m_20188_(), trader.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
                data.addDislikedPlayer((Player)openingPlayer, trader.m_9236_().m_46467_());
                return;
            }
            if (WanderingTraderEvents.generateBackpackLoot(trader, data)) {
                UnlockManager.get((Player)openingPlayer).flatMap(tracker -> tracker.getProgressTracker(WanderingBagBackpack.ID)).ifPresent(tracker -> ((WanderingBagBackpack.PickpocketProgressTracker)tracker).addTrader(trader, openingPlayer));
            }
            Services.BACKPACK.openBackpackScreen(openingPlayer, (Container)trader.m_35311_(), 8, 1, false, WANDERING_BAG_TRANSLATION);
            openingPlayer.m_9236_().m_6263_((Player)openingPlayer, trader.m_20185_(), trader.m_20186_() + 1.0, trader.m_20189_(), SoundEvents.f_11678_, SoundSource.PLAYERS, 0.15f, 1.0f);
        });
    }

    private static boolean generateBackpackLoot(WanderingTrader trader, PickpocketChallenge data) {
        if (!data.isLootSpawned()) {
            int size = trader.m_35311_().m_6643_();
            int reserved = size / 4;
            int count = trader.m_9236_().f_46441_.m_188503_(Math.max(reserved, 1)) + (size - reserved);
            List randomSlotIndexes = IntStream.range(0, size).boxed().collect(Collectors.toCollection(ArrayList::new));
            Collections.shuffle(randomSlotIndexes);
            MerchantOffers offers = trader.m_6616_();
            for (int i = 0; i < size; ++i) {
                if (!((Boolean)Config.COMMON.common.wanderingTrader.generateEmeraldsOnly.get()).booleanValue() && i < count) {
                    MerchantOffer offer = (MerchantOffer)offers.get(trader.m_9236_().f_46441_.m_188503_(offers.size()));
                    ItemStack loot = offer.m_45368_().m_41777_();
                    loot.m_41764_(Mth.m_14045_((int)(loot.m_41613_() * (trader.m_9236_().f_46441_.m_188503_(((Integer)Config.COMMON.common.wanderingTrader.maxLootMultiplier.get()).intValue()) + 1)), (int)0, (int)loot.m_41741_()));
                    trader.m_35311_().m_6836_(((Integer)randomSlotIndexes.get(i)).intValue(), loot);
                    continue;
                }
                ItemStack stack = new ItemStack((ItemLike)Items.f_42616_, trader.m_9236_().f_46441_.m_188503_(((Integer)Config.COMMON.common.wanderingTrader.maxEmeraldStack.get()).intValue()) + 1);
                trader.m_35311_().m_6836_(((Integer)randomSlotIndexes.get(i)).intValue(), stack);
            }
            data.setLootSpawned();
            return true;
        }
        return false;
    }

    private static void patchTraderAiGoals(WanderingTrader trader) {
        GoalSelector selector = Services.ENTITY.getGoalSelector((Mob)trader);
        trader.m_262441_(goal -> goal instanceof LookAtPlayerGoal);
        selector.m_25352_(2, (Goal)new LootAtDetectedPlayerGoal(trader));
        selector.m_25352_(9, (Goal)new PickpocketLookAtPlayerGoal((Mob)trader, Player.class, 3.0f, 1.0f));
    }

    private static double getMaxDetectionDistance() {
        return (Double)Config.COMMON.common.wanderingTrader.wanderingTraderMaxDetectionDistance.get();
    }

    private static class LootAtDetectedPlayerGoal
    extends LookAtPlayerGoal {
        private final WanderingTrader trader;

        public LootAtDetectedPlayerGoal(WanderingTrader trader) {
            super((Mob)trader, Player.class, ((Double)Config.COMMON.common.wanderingTrader.wanderingTraderMaxDetectionDistance.get()).floatValue() * 2.0f, 1.0f);
            this.trader = trader;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            super.m_8036_();
            if (this.trader.m_21188_() == null && this.f_25513_ instanceof Player) {
                PickpocketChallenge data = PickpocketChallenge.get((Entity)this.trader).orElse(null);
                return data != null && data.isBackpackEquipped() && data.getDetectedPlayers().containsKey((Player)this.f_25513_);
            }
            return false;
        }

        public boolean m_8045_() {
            if (this.f_25513_ instanceof Player && (double)this.f_25513_.m_20270_((Entity)this.trader) <= (double)((Double)Config.COMMON.common.wanderingTrader.wanderingTraderMaxDetectionDistance.get()).floatValue() * 2.0) {
                PickpocketChallenge data = PickpocketChallenge.get((Entity)this.trader).orElse(null);
                return data != null && data.getDetectedPlayers().containsKey((Player)this.f_25513_);
            }
            return false;
        }

        public void m_8056_() {
            Level level = this.trader.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                level = this.f_25513_;
                if (level instanceof Player) {
                    Player player = (Player)level;
                    if (PickpocketChallenge.get((Entity)this.trader).map(data -> data.isDislikedPlayer(player)).orElse(false).booleanValue()) {
                        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123792_, this.trader.m_20185_(), this.trader.m_20188_(), this.trader.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
                        serverLevel.m_6269_(null, (Entity)this.trader, SoundEvents.f_12507_, SoundSource.NEUTRAL, 1.0f, 1.5f);
                    }
                }
            }
        }

        public void m_8037_() {
            if (this.f_25513_ instanceof Player && WanderingTraderEvents.isPlayerSeenByLivingEntity((LivingEntity)this.trader, (Player)this.f_25513_, (Double)Config.COMMON.common.wanderingTrader.wanderingTraderMaxDetectionDistance.get() * 2.0)) {
                this.trader.m_21563_().m_24946_(this.f_25513_.m_20185_(), this.f_25513_.m_20188_(), this.f_25513_.m_20189_());
            }
        }
    }

    private static class PickpocketLookAtPlayerGoal
    extends LookAtPlayerGoal {
        public PickpocketLookAtPlayerGoal(Mob entity, Class<? extends LivingEntity> entityClass, float distance, float probability) {
            super(entity, entityClass, distance, probability);
        }

        public boolean m_8036_() {
            if (PickpocketChallenge.get((Entity)this.f_25512_).map(PickpocketChallenge::isBackpackEquipped).orElse(false).booleanValue()) {
                return false;
            }
            return super.m_8036_();
        }
    }
}

