/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.data.pickpocket;

import com.mrcrayfish.backpacked.platform.Services;
import com.mrcrayfish.backpacked.util.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class PickpocketChallenge
implements Serializable {
    private boolean initialized = false;
    private boolean backpack = false;
    private boolean spawnedLoot = false;
    private final Map<Player, Long> detectedPlayers = new HashMap<Player, Long>();
    private final Map<UUID, Long> dislikedPlayers = new HashMap<UUID, Long>();

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized() {
        this.initialized = true;
    }

    public void setBackpackEquipped(boolean equipped) {
        this.backpack = equipped;
    }

    public boolean isBackpackEquipped() {
        return this.backpack;
    }

    public boolean isLootSpawned() {
        return this.spawnedLoot;
    }

    public void setLootSpawned() {
        this.spawnedLoot = true;
    }

    public Map<Player, Long> getDetectedPlayers() {
        return this.detectedPlayers;
    }

    public boolean isDislikedPlayer(Player player) {
        return this.dislikedPlayers.containsKey(player.m_20148_());
    }

    public void addDislikedPlayer(Player player, long time) {
        this.dislikedPlayers.put(player.m_20148_(), time);
    }

    public Map<UUID, Long> getDislikedPlayers() {
        return this.dislikedPlayers;
    }

    @Override
    public CompoundTag serialize() {
        CompoundTag tag = new CompoundTag();
        tag.m_128379_("Initialized", this.initialized);
        tag.m_128379_("EquippedBackpack", this.backpack);
        tag.m_128379_("SpawnedLoot", this.spawnedLoot);
        return tag;
    }

    @Override
    public void deserialize(CompoundTag tag) {
        this.initialized = tag.m_128471_("Initialized");
        this.backpack = tag.m_128471_("EquippedBackpack");
        this.spawnedLoot = tag.m_128471_("SpawnedLoot");
    }

    public static Optional<PickpocketChallenge> get(Entity entity) {
        return Optional.ofNullable(Services.BACKPACK.getPickpocketChallenge(entity));
    }
}

