/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.data.tracker;

import com.mrcrayfish.backpacked.common.backpack.BackpackManager;
import com.mrcrayfish.backpacked.data.tracker.UnlockTracker;
import com.mrcrayfish.backpacked.network.Network;
import com.mrcrayfish.backpacked.network.message.MessageSyncUnlockTracker;
import com.mrcrayfish.backpacked.platform.Services;
import com.mrcrayfish.framework.api.event.IFrameworkEvent;
import com.mrcrayfish.framework.api.event.PlayerEvents;
import com.mrcrayfish.framework.api.event.TickEvents;
import com.mrcrayfish.framework.event.IPlayerEvent;
import com.mrcrayfish.framework.event.ITickEvent;
import com.mrcrayfish.framework.network.message.IMessage;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class UnlockManager {
    private static final Set<ServerPlayer> testForCompletion = new HashSet<ServerPlayer>();

    public static void init() {
        PlayerEvents.COPY.register((IFrameworkEvent)((IPlayerEvent.Copy)UnlockManager::onPlayerClone));
        PlayerEvents.LOGGED_IN.register((IFrameworkEvent)((IPlayerEvent.LoggedIn)UnlockManager::onPlayerLoggedIn));
        PlayerEvents.RESPAWN.register((IFrameworkEvent)((IPlayerEvent.Respawn)UnlockManager::onPlayerRespawn));
        PlayerEvents.CHANGE_DIMENSION.register((IFrameworkEvent)((IPlayerEvent.ChangeDimension)UnlockManager::onPlayerChangedDimension));
        TickEvents.END_SERVER.register((IFrameworkEvent)((ITickEvent.EndServer)UnlockManager::onServerTick));
    }

    static void queuePlayerForCompletionTest(ServerPlayer player) {
        testForCompletion.add(player);
    }

    public static Optional<UnlockTracker> get(Player player) {
        return UnlockManager.get(player, false);
    }

    private static Optional<UnlockTracker> get(Player player, boolean old) {
        return Optional.ofNullable(Services.BACKPACK.getUnlockTracker(player, old));
    }

    private static void onPlayerClone(Player oldPlayer, Player newPlayer, boolean respawn) {
        UnlockManager.get(oldPlayer, true).ifPresent(originalTracker -> UnlockManager.get(newPlayer).ifPresent(newTracker -> {
            newTracker.setUnlockedBackpacks(originalTracker.getUnlockedBackpacks());
            originalTracker.getProgressTrackerMap().forEach((location, progressTracker) -> {
                CompoundTag tag = new CompoundTag();
                progressTracker.write(tag);
                Optional.ofNullable(newTracker.getProgressTrackerMap().get(location)).ifPresent(t -> t.read(tag));
            });
        }));
    }

    private static void onPlayerLoggedIn(Player player) {
        UnlockManager.get(player).ifPresent(unlockTracker -> Network.getPlay().sendToPlayer(() -> (ServerPlayer)player, (IMessage)new MessageSyncUnlockTracker(unlockTracker.getUnlockedBackpacks())));
    }

    private static void onPlayerRespawn(Player player, boolean finishedGame) {
        UnlockManager.get(player).ifPresent(unlockTracker -> Network.getPlay().sendToPlayer(() -> (ServerPlayer)player, (IMessage)new MessageSyncUnlockTracker(unlockTracker.getUnlockedBackpacks())));
    }

    private static void onPlayerChangedDimension(Player player, ResourceKey<Level> oldDimension, ResourceKey<Level> newDimension) {
        UnlockManager.get(player).ifPresent(unlockTracker -> Network.getPlay().sendToPlayer(() -> (ServerPlayer)player, (IMessage)new MessageSyncUnlockTracker(unlockTracker.getUnlockedBackpacks())));
    }

    private static void onServerTick(MinecraftServer server) {
        if (testForCompletion.isEmpty()) {
            return;
        }
        for (ServerPlayer player : testForCompletion) {
            UnlockManager.get((Player)player).ifPresent(unlockTracker -> unlockTracker.getProgressTrackerMap().forEach((location, progressTracker) -> {
                if (!unlockTracker.getUnlockedBackpacks().contains(location) && progressTracker.isComplete()) {
                    BackpackManager.instance().unlockBackpack(player, (ResourceLocation)location);
                }
            }));
        }
        testForCompletion.clear();
    }
}

