/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.item;

import com.mrcrayfish.backpacked.Config;
import com.mrcrayfish.backpacked.client.model.ModelInstances;
import com.mrcrayfish.backpacked.client.model.backpack.BackpackModel;
import com.mrcrayfish.backpacked.inventory.BackpackInventory;
import com.mrcrayfish.backpacked.inventory.BackpackedInventoryAccess;
import com.mrcrayfish.backpacked.inventory.ExtendedPlayerInventory;
import com.mrcrayfish.backpacked.platform.Services;
import com.mrcrayfish.backpacked.util.ClientUtils;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class BackpackItem
extends Item {
    public static final Component BACKPACK_TRANSLATION = Component.m_237115_((String)"container.backpack");
    public static final MutableComponent REMOVE_ITEMS_TOOLTIP = Component.m_237115_((String)"backpacked.tooltip.remove_items").m_130940_(ChatFormatting.RED);

    public BackpackItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ExtendedPlayerInventory inventory;
        ItemStack heldItem = playerIn.m_21120_(handIn);
        Inventory inventory2 = playerIn.m_150109_();
        if (inventory2 instanceof ExtendedPlayerInventory && ((ItemStack)(inventory = (ExtendedPlayerInventory)inventory2).getBackpackItems().get(0)).m_41619_()) {
            inventory.m_6836_(41, heldItem.m_41777_());
            heldItem.m_41764_(0);
            playerIn.m_5496_(SoundEvents.f_11678_, 1.0f, 1.0f);
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)heldItem);
        }
        return new InteractionResultHolder(InteractionResult.FAIL, (Object)heldItem);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        ClientUtils.createBackpackTooltip(stack, list);
    }

    public static boolean openBackpack(ServerPlayer ownerPlayer, ServerPlayer openingPlayer) {
        ItemStack backpack = Services.BACKPACK.getBackpackStack((Player)ownerPlayer);
        if (!backpack.m_41619_()) {
            BackpackInventory backpackInventory = ((BackpackedInventoryAccess)ownerPlayer).getBackpackedInventory();
            if (backpackInventory == null) {
                return false;
            }
            BackpackItem backpackItem = (BackpackItem)backpack.m_41720_();
            Component title = backpack.m_41788_() ? backpack.m_41786_() : BACKPACK_TRANSLATION;
            int cols = backpackItem.getColumnCount();
            int rows = backpackItem.getRowCount();
            boolean owner = ownerPlayer.equals((Object)openingPlayer);
            Services.BACKPACK.openBackpackScreen(openingPlayer, (Container)backpackInventory, cols, rows, owner, title);
            return true;
        }
        return false;
    }

    public int getColumnCount() {
        return (Integer)Config.COMMON.common.backpackInventorySizeColumns.get();
    }

    public int getRowCount() {
        return (Integer)Config.COMMON.common.backpackInventorySizeRows.get();
    }

    public Supplier<BackpackModel> getDefaultModel() {
        return () -> ModelInstances.get().getStandardModel();
    }

    public boolean m_142095_() {
        return false;
    }
}

