/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.platform;

import com.mrcrayfish.backpacked.Constants;
import com.mrcrayfish.backpacked.platform.services.IBackpackHelper;
import com.mrcrayfish.backpacked.platform.services.IEntityHelper;
import com.mrcrayfish.backpacked.platform.services.IRegistrationHelper;
import java.util.ServiceLoader;

public class Services {
    public static final IBackpackHelper BACKPACK = Services.load(IBackpackHelper.class);
    public static final IEntityHelper ENTITY = Services.load(IEntityHelper.class);
    public static final IRegistrationHelper REGISTRATION = Services.load(IRegistrationHelper.class);

    public static <T> T load(Class<T> clazz) {
        T loadedService = ServiceLoader.load(clazz).findFirst().orElseThrow(() -> new NullPointerException("Failed to load service for " + clazz.getName()));
        Constants.LOG.debug("Loaded {} for service {}", loadedService, clazz);
        return loadedService;
    }
}

