/*
 * Decompiled with CFR 0.152.
 */
package net.dixta.dixtas_armory.config;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.dixta.dixtas_armory.entity.TextureSize;
import net.dixta.dixtas_armory.item.JsonTier;
import net.dixta.dixtas_armory.item.ModTiers;
import net.dixta.dixtas_armory.item.custom.attributes.AttackAttribute;
import net.dixta.dixtas_armory.item.custom.attributes.SweepAttribute;
import net.dixta.dixtas_armory.item.custom.attributes.ThrownWeaponAttribute;
import net.dixta.dixtas_armory.item.custom.attributes.TwoHandedAttribute;
import net.dixta.dixtas_armory.item.custom.attributes.TwoHandedIIAttribute;
import net.dixta.dixtas_armory.item.custom.attributes.WeaponObject;
import net.dixta.dixtas_armory.item.custom.attributes.WeaponProperty;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DixtasArmoryJsonConfig {
    static int weaponCounter = 0;
    public static Map<String, Map<String, Map<String, Map<String, ?>>>> CONFIG;
    public static List<WeaponObject> WEAPONS;
    public static List<WeaponObject> THD_COPIES;
    public static List<String> TIERS;

    public static Tier getTier(String string) {
        Logger logger = LogManager.getLogger();
        if (Character.isUpperCase(string.charAt(0))) {
            return switch (string) {
                case "Netherite" -> Tiers.NETHERITE;
                case "Diamond" -> Tiers.DIAMOND;
                case "Iron" -> Tiers.IRON;
                case "Stone" -> Tiers.STONE;
                case "Wood" -> Tiers.WOOD;
                case "Gold" -> Tiers.GOLD;
                case "Adamantite" -> ModTiers.ADAMANTITE;
                default -> Tiers.DIAMOND;
            };
        }
        try {
            Tier tier = TierSortingRegistry.byName((ResourceLocation)new ResourceLocation("dixtas_armory_tiers:" + string.toLowerCase()));
            tier.m_6609_();
            return tier;
        }
        catch (Exception e) {
            logger.warn("Failed to create new tier. " + e.getClass() + ": " + e.getMessage());
            return Tiers.DIAMOND;
        }
    }

    public static String createTier(Map.Entry<String, Map<String, ?>> tierData) {
        String name = tierData.getKey();
        Double test2 = 243.0;
        float test = (float)test2.doubleValue();
        Map<String, ?> properties = tierData.getValue();
        int uses = properties.get("uses") != null ? (int)Math.round((Double)properties.get("uses")) : 1561;
        float damage = properties.get("damage") != null ? (float)((Double)properties.get("damage")).doubleValue() : 3.0f;
        float speed = properties.get("speed") != null ? (float)((Double)properties.get("speed")).doubleValue() : 8.0f;
        int level = properties.get("level") != null ? (int)Math.round((Double)properties.get("level")) : 3;
        int enchantmentValue = properties.get("enchantmentValue") != null ? (int)Math.round((Double)properties.get("enchantmentValue")) : 10;
        String repairItemString = properties.get("repairItem") != null ? (String)properties.get("repairItem") : "minecraft:diamond";
        Supplier<Ingredient> repairItem = () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(repairItemString))});
        new JsonTier(uses, damage, speed, level, enchantmentValue, repairItem, "dixtas_armory_tiers:" + name);
        return name;
    }

    public static WeaponObject createWeaponObject(Map.Entry<String, Map<String, ?>> weaponData, int index) {
        String dependencyCluster;
        Logger logger = LogManager.getLogger();
        Map<String, ?> properties = weaponData.getValue();
        Object name = weaponData.getKey() != null ? weaponData.getKey() : "new_weapon_" + ++weaponCounter;
        String string = dependencyCluster = properties.get("dependencies") != null ? (String)properties.get("dependencies") : null;
        if (dependencyCluster != null) {
            String[] dependencies;
            for (String s : dependencies = dependencyCluster.split(",")) {
                if (ModList.get().isLoaded(s)) continue;
                return null;
            }
        }
        Tiers tier = properties.get("tier") != null ? DixtasArmoryJsonConfig.getTier(properties.get("tier").toString()) : Tiers.DIAMOND;
        Item.Properties itemProperties = new Item.Properties();
        if (tier == Tiers.NETHERITE) {
            itemProperties = itemProperties.m_41486_();
        }
        boolean axeType = properties.get("weaponType") == "Axe";
        double damage = properties.get("damage") != null ? (Double)properties.get("damage") : 1.0;
        double speed = properties.get("speed") != null ? (Double)properties.get("speed") : 4.0;
        double range = properties.get("range") != null ? (Double)properties.get("range") : 3.0;
        double piercingChance = properties.get("piercingChance") != null ? (Double)properties.get("piercingChance") : 1.0;
        double piercingAmount = properties.get("piercingAmount") != null ? (Double)properties.get("piercingAmount") : 0.0;
        double unarmoredBonus = properties.get("unarmoredBonus") != null ? (Double)properties.get("unarmoredBonus") : 0.0;
        boolean canSweep = properties.get("canSweep") != null && (Boolean)properties.get("canSweep") != false;
        double sweepDamage = properties.get("sweepDamage") != null ? (Double)properties.get("sweepDamage") : 1.0;
        double sweepRadius = properties.get("sweepRadius") != null ? (Double)properties.get("sweepRadius") : 1.0;
        int twoHandedLevel = properties.get("twoHandedLevel") != null ? (int)Math.round((Double)properties.get("twoHandedLevel")) : 0;
        boolean thdCopy = twoHandedLevel == 1 && properties.get("createThdCopy") != null && (Boolean)properties.get("createThdCopy") != false;
        double twoHandedMajDamage = properties.get("twoHandedMajDamage") != null ? (Double)properties.get("twoHandedMajDamage") : 0.0;
        double twoHandedMinDamage = properties.get("twoHandedMinDamage") != null ? (Double)properties.get("twoHandedMinDamage") : 0.0;
        double twoHandedMajSpeed = properties.get("twoHandedMajSpeed") != null ? (Double)properties.get("twoHandedMajSpeed") : 0.0;
        double twoHandedMinSpeed = properties.get("twoHandedMinSpeed") != null ? (Double)properties.get("twoHandedMinSpeed") : 0.0;
        int invincibilityTime = properties.get("invincibilityTime") != null ? (int)Math.round((Double)properties.get("invincibilityTime")) : 10;
        ThrownWeaponAttribute thwAttribute = null;
        if (properties.get("throwingWeapon") != null) {
            logger.info((String)name);
            Map tWP = (Map)properties.get("throwingWeapon");
            double thrownDamage = tWP.get("damage") != null ? (Double)tWP.get("damage") : 1.0;
            double throwForce = tWP.get("force") != null ? (Double)tWP.get("force") : 1.0;
            int throwAmmo = tWP.get("ammo") != null ? (int)Math.round((Double)tWP.get("ammo")) : 4;
            int throwChargingTime = tWP.get("chargeTime") != null ? (int)Math.round((Double)tWP.get("chargeTime")) : 20;
            double throwInaccuracy = tWP.get("inaccuracy") != null ? (Double)tWP.get("inaccuracy") : 0.0;
            double throwWeight = tWP.get("weight") != null ? (Double)tWP.get("weight") : 1.0;
            double throwWaterInertia = tWP.get("waterInertia") != null ? (Double)tWP.get("waterInertia") : (double)0.6f;
            ThrownWeaponAttribute.ModelData modelData = ThrownWeaponAttribute.ModelData.normal;
            if (tWP.get("modelData") != null) {
                Map mDP = (Map)tWP.get("modelData");
                UseAnim modelDataUseAnim = UseAnim.SPEAR;
                if (mDP.get("useAnim") != null) {
                    logger.info("Found use Anim: " + mDP.get("useAnim"));
                    modelDataUseAnim = switch ((String)mDP.get("useAnim")) {
                        case "block" -> UseAnim.BLOCK;
                        case "bow" -> UseAnim.BOW;
                        case "brush" -> UseAnim.BRUSH;
                        case "crossbow" -> UseAnim.CROSSBOW;
                        case "drink" -> UseAnim.DRINK;
                        case "eat" -> UseAnim.EAT;
                        case "none" -> UseAnim.NONE;
                        case "spyglass" -> UseAnim.SPYGLASS;
                        case "toot_horn" -> UseAnim.TOOT_HORN;
                        default -> UseAnim.SPEAR;
                    };
                }
                TextureSize modelDataTextureSize = TextureSize.X16;
                if (mDP.get("textureSize") != null) {
                    modelDataTextureSize = switch ((String)mDP.get("textureSize")) {
                        case "32X" -> TextureSize.X32;
                        case "64X" -> TextureSize.X64;
                        default -> TextureSize.X16;
                    };
                }
                boolean modelDataHorizontal = mDP.get("horizontal") != null && (Boolean)mDP.get("horizontal") != false;
                boolean modelDataRotating = mDP.get("rotating") != null && (Boolean)mDP.get("rotating") != false;
                modelData = new ThrownWeaponAttribute.ModelData(modelDataTextureSize, modelDataUseAnim, modelDataHorizontal, modelDataRotating);
            }
            thwAttribute = new ThrownWeaponAttribute((float)thrownDamage, (float)throwForce, throwAmmo + 1, throwChargingTime, (float)throwInaccuracy, (float)throwWeight, (float)throwWaterInertia, modelData);
        }
        int breachTime = properties.get("breachTime") != null ? (int)Math.round((Double)properties.get("breachTime")) : 0;
        double breachChance = properties.get("breachChance") != null ? (Double)properties.get("breachChance") : 0.0;
        AttackAttribute atkAttribute = new AttackAttribute(0.0f, (float)piercingChance, (float)piercingAmount, (float)unarmoredBonus, invincibilityTime + 10, breachTime, (float)breachChance);
        TwoHandedAttribute thdAttribute = switch (twoHandedLevel) {
            case 1 -> new TwoHandedAttribute(twoHandedLevel, (int)Math.round(twoHandedMinDamage), (int)Math.round(twoHandedMajDamage), (float)twoHandedMinSpeed, (float)twoHandedMajSpeed);
            case 2 -> new TwoHandedIIAttribute((int)Math.round(twoHandedMajDamage), (float)twoHandedMajSpeed);
            default -> TwoHandedAttribute.none;
        };
        SweepAttribute swpAttribute = new SweepAttribute(canSweep, (float)sweepDamage, (float)sweepRadius);
        if (index != -1 && thdCopy && ModList.get().isLoaded("bettercombat")) {
            DixtasArmoryJsonConfig.createCopy(weaponData, index);
        }
        return new WeaponObject((String)name, new WeaponProperty((Tier)tier, (float)damage - tier.m_6631_() - 1.0f, (float)speed, itemProperties, (float)range, atkAttribute, thdAttribute, swpAttribute, thwAttribute, axeType), -2);
    }

    public static void createCopy(Map.Entry<String, Map<String, ?>> weaponData, int index) {
        WeaponObject weapon = DixtasArmoryJsonConfig.createWeaponObject(weaponData, -1);
        weapon.index = index;
        weapon.name = weapon.name + "_two_handed";
        THD_COPIES.add(weapon);
    }

    public static void register() throws IOException {
        String path = System.getProperty("user.dir") + File.separator + "config" + File.separator + "dixtas_armory-common.json";
        Logger logger = LogManager.getLogger();
        File configFile = new File(path);
        boolean newFile = configFile.createNewFile();
        if (newFile) {
            try {
                FileWriter writer = new FileWriter(path);
                writer.write("{\n  \"weapons\": {\n    \"materials\": {\n    },\n\n    \"regular\": {\n      \"wooden_dagger\": {\n        \"tier\": \"Wood\",\n        \n        \"damage\": 2.4,\n        \"speed\": 3.5,\n        \"range\": 1.8,\n        \n        \"invincibilityTime\": 5,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 0.25\n      },\n      \n      \"wooden_shortsword\": {\n        \"tier\": \"Wood\",\n        \n        \"damage\": 3.8,\n        \"speed\": 2.2,\n        \"range\": 2.25,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 0.75\n      },\n      \n      \"wooden_stiletto\": {\n        \"tier\": \"Wood\",\n        \n        \"damage\": 2.6,\n        \"speed\": 2.5,\n        \"range\": 2,\n        \n        \"piercingChance\": 0.25,\n        \"piercingAmount\": 2,\n        \"invincibilityTime\": 7\n      },\n      \n      \"wooden_rapier\": {\n        \"tier\": \"Wood\",\n        \n        \"damage\": 2.6,\n        \"speed\": 2,\n        \n        \"unarmoredBonus\": 2,\n        \n        \"canSweep\": true\n      },\n      \n      \"wooden_katana\": {\n        \"tier\": \"Wood\",\n        \n        \"damage\": 4.3,\n        \"speed\": 1.8,\n        \"range\": 3.25,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 1.25,\n        \"sweepDamage\": 2,\n        \n        \"twoHandedLevel\": 1,\n\t\t\"createThdCopy\": true,\n        \"twoHandedMinDamage\": 1,\n        \"twoHandedMajDamage\": 3,\n        \"twoHandedMinSpeed\": 0.05,\n        \"twoHandedMajSpeed\": 1\n      },\n      \n      \"wooden_greatsword\": {\n        \"tier\": \"Wood\",\n        \n        \"damage\": 4,\n        \"speed\": 1.2,\n        \"range\": 3.5,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 1.5,\n        \"sweepDamage\": 3,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 4,\n        \"twoHandedMajSpeed\": 0.4\n      },\n      \n      \"wooden_longsword\": {\n        \"tier\": \"Wood\",\n        \n        \"damage\": 5.3,\n        \"speed\": 1.3,\n        \"range\": 3.5,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 2,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 4,\n        \"twoHandedMajSpeed\": 0.4\n      },\n      \n      \"wooden_twinblade\": {\n        \"tier\": \"Wood\",\n        \n        \"damage\": 4.5,\n        \"speed\": 1.9,\n        \"range\": 3.5,\n        \n        \"canSweep\": true,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 4,\n        \"twoHandedMajSpeed\": 0.4\n      },\n      \n      \"wooden_zweihander\": {\n        \"tier\": \"Wood\",\n        \n        \"damage\": 3.2,\n        \"speed\": 1,\n        \"range\": 4,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 2.5,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 3,\n        \"twoHandedMajSpeed\": 0.5\n      },\n\n      \"wooden_battle_axe\": {\n        \"tier\": \"Wood\",\n        \"weaponType\": \"Axe\",\n\n        \"damage\": 7,\n        \"speed\": 0.6,\n        \"range\": 3.25,\n\n        \"twoHandedLevel\": 1,\n\t\t\"createThdCopy\": true,\n        \"twoHandedMinDamage\": 1,\n        \"twoHandedMajDamage\": 3,\n        \"twoHandedMinSpeed\": 0.1,\n        \"twoHandedMajSpeed\": 0.3\n      },\n      \n      \"wooden_glaive\": {\n        \"tier\": \"Wood\",\n        \n        \"damage\": 5.2,\n        \"speed\": 1,\n        \"range\": 4,\n        \n        \"canSweep\": true,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 4,\n        \"twoHandedMajSpeed\": 0.5\n      },\n      \n      \"wooden_spear\": {\n        \"tier\": \"Wood\",\n        \n        \"damage\": 2.5,\n        \"speed\": 1.3,\n        \"range\": 4.2,\n        \n        \"piercingAmount\": 0.8,\n        \n        \"twoHandedLevel\": 1,\n\t\t\"createThdCopy\": true,\n        \"twoHandedMajDamage\": 1,\n        \"twoHandedMinSpeed\": 0.1,\n        \"twoHandedMajSpeed\": 0.55\n      },\n      \n      \"wooden_halberd\": {\n        \"tier\": \"Wood\",\n        \n        \"damage\": 4.1,\n        \"speed\": 0.7,\n        \"range\": 4.5,\n        \n        \"piercingChance\": 0.5,\n        \"piercingAmount\": 2,\n        \"breachChance\": 1,\n        \"breachTime\": 1.5,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 3,\n        \"twoHandedMajSpeed\": 0.2\n      },\n      \n      \"wooden_pike\": {\n        \"tier\": \"Wood\",\n        \n        \"damage\": 3,\n        \"speed\": 0.8,\n        \"range\": 5,\n        \n        \"piercingAmount\": 1,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 2,\n        \"twoHandedMajSpeed\": 0.3\n      },\n\n      \"wooden_throwing_knife\": {\n        \"tier\": \"Wood\",\n\n        \"damage\": 5,\n        \"speed\": 1.6,\n        \"range\": 3,\n\n        \"throwingWeapon\": {\n          \"damage\": 10,\n          \"force\": 2.5,\n          \"ammo\": 8,\n\n          \"chargeTime\": 10,\n          \"inaccuracy\": 1,\n          \"weight\": 1,\n          \"waterInertia\": 0.7,\n\n          \"modelData\": {\n            \"textureSize\": \"16X\",\n            \"useAnim\": \"spear\",\n            \"rotating\": false,\n            \"horizontal\": false\n          }\n        }\n      },\n\n      \"wooden_shuriken\": {\n        \"tier\": \"Wood\",\n\n        \"damage\": 5,\n        \"speed\": 1.6,\n        \"range\": 3,\n\n        \"throwingWeapon\": {\n          \"damage\": 10,\n          \"force\": 2.5,\n          \"ammo\": 16,\n\n          \"chargeTime\": 10,\n          \"inaccuracy\": 1,\n          \"weight\": 1,\n          \"waterInertia\": 0.6,\n\n          \"modelData\": {\n            \"textureSize\": \"16X\",\n            \"useAnim\": \"spear\",\n            \"rotating\": true,\n            \"horizontal\": false\n          }\n        }\n      },\n\n      \"wooden_chakram\": {\n        \"tier\": \"Wood\",\n\n        \"damage\": 5,\n        \"speed\": 1.6,\n        \"range\": 3,\n\n        \"throwingWeapon\": {\n          \"damage\": 10,\n          \"force\": 2.5,\n          \"ammo\": 4,\n\n          \"chargeTime\": 10,\n          \"inaccuracy\": 1,\n          \"weight\": 0.5,\n          \"waterInertia\": 1,\n\n          \"modelData\": {\n            \"textureSize\": \"16X\",\n            \"useAnim\": \"spear\",\n            \"rotating\": true,\n            \"horizontal\": true\n          }\n        }\n      },\n\n      \"wooden_javelin\": {\n        \"tier\": \"Wood\",\n\n        \"damage\": 5,\n        \"speed\": 1.6,\n        \"range\": 3,\n\n        \"throwingWeapon\": {\n          \"damage\": 10,\n          \"force\": 2.5,\n          \"ammo\": 2,\n\n          \"chargeTime\": 10,\n          \"inaccuracy\": 1,\n          \"weight\": 1,\n          \"waterInertia\": 0.6,\n\n          \"modelData\": {\n            \"textureSize\": \"32X\",\n            \"useAnim\": \"spear\",\n            \"rotating\": false,\n            \"horizontal\": false\n          }\n        }\n      },\n      \n      \"stone_dagger\": {\n        \"tier\": \"Stone\",\n        \n        \"damage\": 2.9,\n        \"speed\": 3.5,\n        \"range\": 1.8,\n        \n        \"invincibilityTime\": 5,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 0.25\n      },\n      \n      \"stone_shortsword\": {\n        \"tier\": \"Stone\",\n        \n        \"damage\": 4.5,\n        \"speed\": 2.2,\n        \"range\": 2.25,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 0.75\n      },\n      \n      \"stone_stiletto\": {\n        \"tier\": \"Stone\",\n        \n        \"damage\": 3.2,\n        \"speed\": 2.5,\n        \"range\": 2,\n        \n        \"piercingChance\": 0.25,\n        \"piercingAmount\": 2,\n        \"invincibilityTime\": 7\n      },\n      \n      \"stone_rapier\": {\n        \"tier\": \"Stone\",\n        \n        \"damage\": 3.4,\n        \"speed\": 2,\n        \n        \"unarmoredBonus\": 2,\n        \n        \"canSweep\": true\n      },\n      \n      \"stone_katana\": {\n        \"tier\": \"Stone\",\n        \n        \"damage\": 5.2,\n        \"speed\": 1.8,\n        \"range\": 3.25,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 1.25,\n        \"sweepDamage\": 2,\n        \n        \"twoHandedLevel\": 1,\n\t\t\"createThdCopy\": true,\n        \"twoHandedMinDamage\": 1,\n        \"twoHandedMajDamage\": 4,\n        \"twoHandedMinSpeed\": 0.05,\n        \"twoHandedMajSpeed\": 1\n      },\n      \n      \"stone_greatsword\": {\n        \"tier\": \"Stone\",\n        \n        \"damage\": 5.3,\n        \"speed\": 1.2,\n        \"range\": 3.5,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 1.5,\n        \"sweepDamage\": 4,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 5,\n        \"twoHandedMajSpeed\": 0.4\n      },\n      \n      \"stone_longsword\": {\n        \"tier\": \"Stone\",\n        \n        \"damage\": 6.5,\n        \"speed\": 1.3,\n        \"range\": 3.5,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 2,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 5,\n        \"twoHandedMajSpeed\": 0.4\n      },\n      \n      \"stone_twinblade\": {\n        \"tier\": \"Stone\",\n        \n        \"damage\": 5.3,\n        \"speed\": 1.9,\n        \"range\": 3.5,\n        \n        \"canSweep\": true,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 5,\n        \"twoHandedMajSpeed\": 0.4\n      },\n      \n      \"stone_zweihander\": {\n        \"tier\": \"Stone\",\n        \n        \"damage\": 4.8,\n        \"speed\": 1,\n        \"range\": 4,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 2.5,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 4,\n        \"twoHandedMajSpeed\": 0.5\n      },\n\n      \"stone_battle_axe\": {\n        \"tier\": \"Stone\",\n        \"weaponType\": \"Axe\",\n\n        \"damage\": 9.7,\n        \"speed\": 0.6,\n        \"range\": 3.25,\n\n        \"twoHandedLevel\": 1,\n\t\t\"createThdCopy\": true,\n        \"twoHandedMinDamage\": 1,\n        \"twoHandedMajDamage\": 3,\n        \"twoHandedMinSpeed\": 0.1,\n        \"twoHandedMajSpeed\": 0.3\n      },\n      \n      \"stone_glaive\": {\n        \"tier\": \"Stone\",\n        \n        \"damage\": 6.8,\n        \"speed\": 1,\n        \"range\": 4,\n        \n        \"canSweep\": true,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 4,\n        \"twoHandedMajSpeed\": 0.5\n      },\n      \n      \"stone_spear\": {\n        \"tier\": \"Stone\",\n        \n        \"damage\": 3.7,\n        \"speed\": 1.3,\n        \"range\": 4.2,\n        \n        \"piercingAmount\": 0.8,\n        \n        \"twoHandedLevel\": 1,\n\t\t\"createThdCopy\": true,\n        \"twoHandedMajDamage\": 2,\n        \"twoHandedMinSpeed\": 0.1,\n        \"twoHandedMajSpeed\": 0.55\n      },\n      \n      \"stone_halberd\": {\n        \"tier\": \"Stone\",\n        \n        \"damage\": 6.4,\n        \"speed\": 0.7,\n        \"range\": 4.5,\n        \n        \"piercingChance\": 0.5,\n        \"piercingAmount\": 2,\n        \"breachChance\": 1,\n        \"breachTime\": 1.5,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 4,\n        \"twoHandedMajSpeed\": 0.2\n      },\n      \n      \"stone_pike\": {\n        \"tier\": \"Stone\",\n        \n        \"damage\": 5,\n        \"speed\": 0.8,\n        \"range\": 5,\n        \n        \"piercingAmount\": 1,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 3,\n        \"twoHandedMajSpeed\": 0.3\n      },\n\n      \"stone_throwing_knife\": {\n        \"tier\": \"Stone\",\n\n        \"damage\": 5,\n        \"speed\": 1.6,\n        \"range\": 3,\n\n        \"throwingWeapon\": {\n          \"damage\": 10,\n          \"force\": 2.5,\n          \"ammo\": 8,\n\n          \"chargeTime\": 10,\n          \"inaccuracy\": 1,\n          \"weight\": 1,\n          \"waterInertia\": 0.7,\n\n          \"modelData\": {\n            \"textureSize\": \"16X\",\n            \"useAnim\": \"spear\",\n            \"rotating\": false,\n            \"horizontal\": false\n          }\n        }\n      },\n\n      \"stone_shuriken\": {\n        \"tier\": \"Stone\",\n\n        \"damage\": 5,\n        \"speed\": 1.6,\n        \"range\": 3,\n\n        \"throwingWeapon\": {\n          \"damage\": 10,\n          \"force\": 2.5,\n          \"ammo\": 16,\n\n          \"chargeTime\": 10,\n          \"inaccuracy\": 1,\n          \"weight\": 1,\n          \"waterInertia\": 0.6,\n\n          \"modelData\": {\n            \"textureSize\": \"16X\",\n            \"useAnim\": \"spear\",\n            \"rotating\": true,\n            \"horizontal\": false\n          }\n        }\n      },\n\n      \"stone_chakram\": {\n        \"tier\": \"Stone\",\n\n        \"damage\": 5,\n        \"speed\": 1.6,\n        \"range\": 3,\n\n        \"throwingWeapon\": {\n          \"damage\": 10,\n          \"force\": 2.5,\n          \"ammo\": 4,\n\n          \"chargeTime\": 10,\n          \"inaccuracy\": 1,\n          \"weight\": 0.5,\n          \"waterInertia\": 1,\n\n          \"modelData\": {\n            \"textureSize\": \"16X\",\n            \"useAnim\": \"spear\",\n            \"rotating\": true,\n            \"horizontal\": true\n          }\n        }\n      },\n\n      \"stone_javelin\": {\n        \"tier\": \"Stone\",\n\n        \"damage\": 5,\n        \"speed\": 1.6,\n        \"range\": 3,\n\n        \"throwingWeapon\": {\n          \"damage\": 10,\n          \"force\": 2.5,\n          \"ammo\": 2,\n\n          \"chargeTime\": 10,\n          \"inaccuracy\": 1,\n          \"weight\": 1,\n          \"waterInertia\": 0.6,\n\n          \"modelData\": {\n            \"textureSize\": \"32X\",\n            \"useAnim\": \"spear\",\n            \"rotating\": false,\n            \"horizontal\": false\n          }\n        }\n      },\n      \n      \"golden_dagger\": {\n        \"tier\": \"Gold\",\n        \n        \"damage\": 2.4,\n        \"speed\": 3.5,\n        \"range\": 1.8,\n        \n        \"invincibilityTime\": 5,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 0.25\n      },\n      \n      \"golden_shortsword\": {\n        \"tier\": \"Gold\",\n        \n        \"damage\": 3.8,\n        \"speed\": 2.2,\n        \"range\": 2.25,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 0.75\n      },\n      \n      \"golden_stiletto\": {\n        \"tier\": \"Gold\",\n        \n        \"damage\": 2.6,\n        \"speed\": 2.5,\n        \"range\": 2,\n        \n        \"piercingChance\": 0.25,\n        \"piercingAmount\": 2,\n        \"invincibilityTime\": 7\n      },\n      \n      \"golden_rapier\": {\n        \"tier\": \"Gold\",\n        \n        \"damage\": 2.6,\n        \"speed\": 2,\n        \n        \"unarmoredBonus\": 1,\n        \n        \"canSweep\": true\n      },\n      \n      \"golden_katana\": {\n        \"tier\": \"Gold\",\n        \n        \"damage\": 4.3,\n        \"speed\": 1.8,\n        \"range\": 3.25,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 1.25,\n        \"sweepDamage\": 2,\n        \n        \"twoHandedLevel\": 1,\n\t\t\"createThdCopy\": true,\n        \"twoHandedMinDamage\": 1,\n        \"twoHandedMajDamage\": 3,\n        \"twoHandedMinSpeed\": 0.05,\n        \"twoHandedMajSpeed\": 1\n      },\n      \n      \"golden_greatsword\": {\n        \"tier\": \"Gold\",\n        \n        \"damage\": 4,\n        \"speed\": 1.2,\n        \"range\": 3.5,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 1.5,\n        \"sweepDamage\": 3,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 4,\n        \"twoHandedMajSpeed\": 0.4\n      },\n      \n      \"golden_longsword\": {\n        \"tier\": \"Gold\",\n        \n        \"damage\": 5.3,\n        \"speed\": 1.3,\n        \"range\": 3.5,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 2,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 4,\n        \"twoHandedMajSpeed\": 0.4\n      },\n      \n      \"golden_twinblade\": {\n        \"tier\": \"Gold\",\n        \n        \"damage\": 4.5,\n        \"speed\": 1.9,\n        \"range\": 3.5,\n        \n        \"canSweep\": true,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 4,\n        \"twoHandedMajSpeed\": 0.4\n      },\n      \n      \"golden_zweihander\": {\n        \"tier\": \"Gold\",\n        \n        \"damage\": 3.2,\n        \"speed\": 1,\n        \"range\": 4,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 2.5,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 3,\n        \"twoHandedMajSpeed\": 0.5\n      },\n\n      \"golden_battle_axe\": {\n        \"tier\": \"Gold\",\n        \"weaponType\": \"Axe\",\n\n        \"damage\": 7,\n        \"speed\": 0.6,\n        \"range\": 3.25,\n\n        \"twoHandedLevel\": 1,\n\t\t\"createThdCopy\": true,\n        \"twoHandedMinDamage\": 1,\n        \"twoHandedMajDamage\": 3,\n        \"twoHandedMinSpeed\": 0.1,\n        \"twoHandedMajSpeed\": 0.3\n      },\n      \n      \"golden_glaive\": {\n        \"tier\": \"Gold\",\n        \n        \"damage\": 5.2,\n        \"speed\": 1,\n        \"range\": 4,\n        \n        \"canSweep\": true,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 4,\n        \"twoHandedMajSpeed\": 0.5\n      },\n      \n      \"golden_spear\": {\n        \"tier\": \"Gold\",\n        \n        \"damage\": 2.5,\n        \"speed\": 1.3,\n        \"range\": 4.2,\n        \n        \"piercingAmount\": 0.8,\n        \n        \"twoHandedLevel\": 1,\n\t\t\"createThdCopy\": true,\n        \"twoHandedMajDamage\": 1,\n        \"twoHandedMinSpeed\": 0.1,\n        \"twoHandedMajSpeed\": 0.55\n      },\n      \n      \"golden_halberd\": {\n        \"tier\": \"Gold\",\n        \n        \"damage\": 4.1,\n        \"speed\": 0.7,\n        \"range\": 4.5,\n        \n        \"piercingChance\": 0.5,\n        \"piercingAmount\": 4,\n        \"breachChance\": 1,\n        \"breachTime\": 1.5,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 3,\n        \"twoHandedMajSpeed\": 0.2\n      },\n      \n      \"golden_pike\": {\n        \"tier\": \"Gold\",\n        \n        \"damage\": 3,\n        \"speed\": 0.8,\n        \"range\": 5,\n        \n        \"piercingAmount\": 1,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 2,\n        \"twoHandedMajSpeed\": 0.3\n      },\n      \n      \"iron_dagger\": {\n        \"tier\": \"Iron\",\n        \n        \"damage\": 3.5,\n        \"speed\": 3.5,\n        \"range\": 1.8,\n        \n        \"invincibilityTime\": 5,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 0.25\n      },\n      \n      \"iron_shortsword\": {\n        \"tier\": \"Iron\",\n        \n        \"damage\": 5.3,\n        \"speed\": 2.2,\n        \"range\": 2.25,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 0.75\n      },\n      \n      \"iron_stiletto\": {\n        \"tier\": \"Iron\",\n        \n        \"damage\": 3.6,\n        \"speed\": 2.5,\n        \"range\": 2,\n        \n        \"piercingChance\": 0.25,\n        \"piercingAmount\": 3,\n        \"invincibilityTime\": 7\n      },\n      \n      \"iron_rapier\": {\n        \"tier\": \"Iron\",\n        \n        \"damage\": 4,\n        \"speed\": 2,\n        \n        \"unarmoredBonus\": 2.2,\n        \n        \"canSweep\": true\n      },\n      \n      \"iron_katana\": {\n        \"tier\": \"Iron\",\n        \n        \"damage\": 6.1,\n        \"speed\": 1.8,\n        \"range\": 3.25,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 1.25,\n        \"sweepDamage\": 2,\n        \n        \"twoHandedLevel\": 1,\n\t\t\"createThdCopy\": true,\n        \"twoHandedMinDamage\": 1,\n        \"twoHandedMajDamage\": 4,\n        \"twoHandedMinSpeed\": 0.1,\n        \"twoHandedMajSpeed\": 1\n      },\n      \n      \"iron_greatsword\": {\n        \"tier\": \"Iron\",\n        \n        \"damage\": 6.7,\n        \"speed\": 1.2,\n        \"range\": 3.5,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 1.5,\n        \"sweepDamage\": 4,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 5,\n        \"twoHandedMajSpeed\": 0.4\n      },\n      \n      \"iron_longsword\": {\n        \"tier\": \"Iron\",\n        \n        \"damage\": 7.8,\n        \"speed\": 1.3,\n        \"range\": 3.5,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 2,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 5,\n        \"twoHandedMajSpeed\": 0.4\n      },\n      \n      \"iron_twinblade\": {\n        \"tier\": \"Iron\",\n        \n        \"damage\": 6.2,\n        \"speed\": 1.9,\n        \"range\": 3.5,\n        \n        \"canSweep\": true,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 5,\n        \"twoHandedMajSpeed\": 0.4\n      },\n      \n      \"iron_zweihander\": {\n        \"tier\": \"Iron\",\n        \n        \"damage\": 6.4,\n        \"speed\": 1,\n        \"range\": 4,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 2.5,\n        \"sweepDamage\": 2,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 4,\n        \"twoHandedMajSpeed\": 0.5\n      },\n\n      \"iron_battle_axe\": {\n        \"tier\": \"Iron\",\n        \"weaponType\": \"Axe\",\n\n        \"damage\": 12.3,\n        \"speed\": 0.6,\n        \"range\": 3.25,\n\n        \"twoHandedLevel\": 1,\n\t\t\"createThdCopy\": true,\n        \"twoHandedMinDamage\": 1,\n        \"twoHandedMajDamage\": 3,\n        \"twoHandedMinSpeed\": 0.1,\n        \"twoHandedMajSpeed\": 0.3\n      },\n      \n      \"iron_glaive\": {\n        \"tier\": \"Iron\",\n        \n        \"damage\": 8.4,\n        \"speed\": 1,\n        \"range\": 4,\n        \n        \"canSweep\": true,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 4,\n        \"twoHandedMajSpeed\": 0.5\n      },\n      \n      \"iron_spear\": {\n        \"tier\": \"Iron\",\n        \n        \"damage\": 5,\n        \"speed\": 1.3,\n        \"range\": 4.2,\n        \n        \"piercingAmount\": 0.8,\n        \n        \"twoHandedLevel\": 1,\n\t\t\"createThdCopy\": true,\n        \"twoHandedMajDamage\": 2,\n        \"twoHandedMinSpeed\": 0.1,\n        \"twoHandedMajSpeed\": 0.55\n      },\n      \n      \"iron_halberd\": {\n        \"tier\": \"Iron\",\n        \n        \"damage\": 8.2,\n        \"speed\": 0.7,\n        \"range\": 4.5,\n        \n        \"piercingChance\": 0.5,\n        \"piercingAmount\": 3,\n        \"breachChance\": 1,\n        \"breachTime\": 1.5,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 3,\n        \"twoHandedMajSpeed\": 0.2\n      },\n      \n      \"iron_pike\": {\n        \"tier\": \"Iron\",\n        \n        \"damage\": 7,\n        \"speed\": 0.8,\n        \"range\": 5,\n        \n        \"piercingAmount\": 1,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 3,\n        \"twoHandedMajSpeed\": 0.3\n      },\n\n      \"iron_throwing_knife\": {\n        \"tier\": \"Iron\",\n\n        \"damage\": 5,\n        \"speed\": 1.6,\n        \"range\": 3,\n\n        \"throwingWeapon\": {\n          \"damage\": 10,\n          \"force\": 2.5,\n          \"ammo\": 8,\n\n          \"chargeTime\": 10,\n          \"inaccuracy\": 1,\n          \"weight\": 1,\n          \"waterInertia\": 0.7,\n\n          \"modelData\": {\n            \"textureSize\": \"16X\",\n            \"useAnim\": \"spear\",\n            \"rotating\": false,\n            \"horizontal\": false\n          }\n        }\n      },\n\n      \"iron_shuriken\": {\n        \"tier\": \"Iron\",\n\n        \"damage\": 5,\n        \"speed\": 1.6,\n        \"range\": 3,\n\n        \"throwingWeapon\": {\n          \"damage\": 10,\n          \"force\": 2.5,\n          \"ammo\": 16,\n\n          \"chargeTime\": 10,\n          \"inaccuracy\": 1,\n          \"weight\": 1,\n          \"waterInertia\": 0.6,\n\n          \"modelData\": {\n            \"textureSize\": \"16X\",\n            \"useAnim\": \"spear\",\n            \"rotating\": true,\n            \"horizontal\": false\n          }\n        }\n      },\n\n      \"iron_chakram\": {\n        \"tier\": \"Iron\",\n\n        \"damage\": 5,\n        \"speed\": 1.6,\n        \"range\": 3,\n\n        \"throwingWeapon\": {\n          \"damage\": 10,\n          \"force\": 2.5,\n          \"ammo\": 4,\n\n          \"chargeTime\": 10,\n          \"inaccuracy\": 1,\n          \"weight\": 0.5,\n          \"waterInertia\": 1,\n\n          \"modelData\": {\n            \"textureSize\": \"16X\",\n            \"useAnim\": \"spear\",\n            \"rotating\": true,\n            \"horizontal\": true\n          }\n        }\n      },\n\n      \"iron_javelin\": {\n        \"tier\": \"Iron\",\n\n        \"damage\": 5,\n        \"speed\": 1.6,\n        \"range\": 3,\n\n        \"throwingWeapon\": {\n          \"damage\": 10,\n          \"force\": 2.5,\n          \"ammo\": 2,\n\n          \"chargeTime\": 10,\n          \"inaccuracy\": 1,\n          \"weight\": 1,\n          \"waterInertia\": 0.6,\n\n          \"modelData\": {\n            \"textureSize\": \"32X\",\n            \"useAnim\": \"spear\",\n            \"rotating\": false,\n            \"horizontal\": false\n          }\n        }\n      },\n      \n      \"diamond_dagger\": {\n        \"tier\": \"Diamond\",\n        \n        \"damage\": 4,\n        \"speed\": 3.5,\n        \"range\": 1.8,\n        \n        \"invincibilityTime\": 5,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 0.25\n      },\n      \n      \"diamond_shortsword\": {\n        \"tier\": \"Diamond\",\n        \n        \"damage\": 6,\n        \"speed\": 2.2,\n        \"range\": 2.25,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 0.75\n      },\n      \n      \"diamond_stiletto\": {\n        \"tier\": \"Diamond\",\n        \n        \"damage\": 4,\n        \"speed\": 2.5,\n        \"range\": 2,\n        \n        \"piercingChance\": 0.25,\n        \"piercingAmount\": 4,\n        \"invincibilityTime\": 7\n      },\n      \n      \"diamond_rapier\": {\n        \"tier\": \"Diamond\",\n        \n        \"damage\": 4,\n        \"speed\": 2,\n        \n        \"unarmoredBonus\": 3,\n        \n        \"canSweep\": true\n      },\n      \n      \"diamond_katana\": {\n        \"tier\": \"Diamond\",\n        \n        \"damage\": 7,\n        \"speed\": 1.8,\n        \"range\": 3.25,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 1.25,\n        \"sweepDamage\": 2,\n        \n        \"twoHandedLevel\": 1,\n\t\t\"createThdCopy\": true,\n        \"twoHandedMinDamage\": 2,\n        \"twoHandedMajDamage\": 5,\n        \"twoHandedMinSpeed\": 0.05,\n        \"twoHandedMajSpeed\": 1\n      },\n      \n      \"diamond_greatsword\": {\n        \"tier\": \"Diamond\",\n        \n        \"damage\": 8,\n        \"speed\": 1.2,\n        \"range\": 3.5,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 1.5,\n        \"sweepDamage\": 5,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 6,\n        \"twoHandedMajSpeed\": 0.4\n      },\n      \n      \"diamond_longsword\": {\n        \"tier\": \"Diamond\",\n        \n        \"damage\": 9,\n        \"speed\": 1.3,\n        \"range\": 3.5,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 2,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 6,\n        \"twoHandedMajSpeed\": 0.4\n      },\n      \n      \"diamond_twinblade\": {\n        \"tier\": \"Diamond\",\n        \n        \"damage\": 7,\n        \"speed\": 1.9,\n        \"range\": 3.5,\n        \n        \"canSweep\": true,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 6,\n        \"twoHandedMajSpeed\": 0.4\n      },\n      \n      \"diamond_zweihander\": {\n        \"tier\": \"Diamond\",\n        \n        \"damage\": 8,\n        \"speed\": 1,\n        \"range\": 4,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 2.5,\n        \"sweepDamage\": 2,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 5,\n        \"twoHandedMajSpeed\": 0.5\n      },\n\n      \"diamond_battle_axe\": {\n        \"tier\": \"Diamond\",\n        \"weaponType\": \"Axe\",\n\n        \"damage\": 15,\n        \"speed\": 0.6,\n        \"range\": 3.25,\n\n        \"twoHandedLevel\": 1,\n\t\t\"createThdCopy\": true,\n        \"twoHandedMinDamage\": 1,\n        \"twoHandedMajDamage\": 4,\n        \"twoHandedMinSpeed\": 0.1,\n        \"twoHandedMajSpeed\": 0.3\n      },\n      \n      \"diamond_glaive\": {\n        \"tier\": \"Diamond\",\n        \n        \"damage\": 10,\n        \"speed\": 1,\n        \"range\": 4,\n        \n        \"canSweep\": true,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 4,\n        \"twoHandedMajSpeed\": 0.5\n      },\n      \n      \"diamond_spear\": {\n        \"tier\": \"Diamond\",\n        \n        \"damage\": 5,\n        \"speed\": 1.3,\n        \"range\": 4.2,\n        \n        \"piercingAmount\": 2,\n        \n        \"twoHandedLevel\": 1,\n\t\t\"createThdCopy\": true,\n        \"twoHandedMajDamage\": 3,\n        \"twoHandedMinSpeed\": 0.1,\n        \"twoHandedMajSpeed\": 0.55\n      },\n      \n      \"diamond_halberd\": {\n        \"tier\": \"Diamond\",\n        \n        \"damage\": 10,\n        \"speed\": 0.7,\n        \"range\": 4.5,\n        \n        \"piercingChance\": 0.5,\n        \"piercingAmount\": 4,\n        \"breachChance\": 1,\n        \"breachTime\": 1.5,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 5,\n        \"twoHandedMajSpeed\": 0.2\n      },\n      \n      \"diamond_pike\": {\n        \"tier\": \"Diamond\",\n\n        \"damage\": 8,\n        \"speed\": 0.8,\n        \"range\": 5,\n\n        \"piercingAmount\": 2,\n\n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 4,\n        \"twoHandedMajSpeed\": 0.3\n      },\n\n      \"diamond_throwing_knife\": {\n        \"tier\": \"Diamond\",\n\n        \"damage\": 5,\n        \"speed\": 1.6,\n        \"range\": 3,\n\n        \"throwingWeapon\": {\n          \"damage\": 10,\n          \"force\": 2.5,\n          \"ammo\": 8,\n\n          \"chargeTime\": 10,\n          \"inaccuracy\": 1,\n          \"weight\": 1,\n          \"waterInertia\": 0.7,\n\n          \"modelData\": {\n            \"textureSize\": \"16X\",\n            \"useAnim\": \"spear\",\n            \"rotating\": false,\n            \"horizontal\": false\n          }\n        }\n      },\n\n      \"diamond_shuriken\": {\n        \"tier\": \"Diamond\",\n\n        \"damage\": 5,\n        \"speed\": 1.6,\n        \"range\": 3,\n\n        \"throwingWeapon\": {\n          \"damage\": 10,\n          \"force\": 2.5,\n          \"ammo\": 16,\n\n          \"chargeTime\": 10,\n          \"inaccuracy\": 1,\n          \"weight\": 1,\n          \"waterInertia\": 0.6,\n\n          \"modelData\": {\n            \"textureSize\": \"16X\",\n            \"useAnim\": \"spear\",\n            \"rotating\": true,\n            \"horizontal\": false\n          }\n        }\n      },\n\n      \"diamond_chakram\": {\n        \"tier\": \"Diamond\",\n\n        \"damage\": 5,\n        \"speed\": 1.6,\n        \"range\": 3,\n\n        \"throwingWeapon\": {\n          \"damage\": 10,\n          \"force\": 2.5,\n          \"ammo\": 4,\n\n          \"chargeTime\": 10,\n          \"inaccuracy\": 1,\n          \"weight\": 0.5,\n          \"waterInertia\": 1,\n\n          \"modelData\": {\n            \"textureSize\": \"16X\",\n            \"useAnim\": \"spear\",\n            \"rotating\": true,\n            \"horizontal\": true\n          }\n        }\n      },\n\n      \"diamond_javelin\": {\n        \"tier\": \"Diamond\",\n\n        \"damage\": 5,\n        \"speed\": 1.6,\n        \"range\": 3,\n\n        \"throwingWeapon\": {\n          \"damage\": 10,\n          \"force\": 2.5,\n          \"ammo\": 2,\n\n          \"chargeTime\": 10,\n          \"inaccuracy\": 1,\n          \"weight\": 1,\n          \"waterInertia\": 0.6,\n\n          \"modelData\": {\n            \"textureSize\": \"32X\",\n            \"useAnim\": \"spear\",\n            \"rotating\": false,\n            \"horizontal\": false\n          }\n        }\n      },\n      \n      \"netherite_dagger\": {\n        \"tier\": \"Netherite\",\n        \n        \"damage\": 4.5,\n        \"speed\": 3.5,\n        \"range\": 1.8,\n        \n        \"invincibilityTime\": 5,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 0.25\n      },\n      \n      \"netherite_shortsword\": {\n        \"tier\": \"Netherite\",\n        \n        \"damage\": 6.7,\n        \"speed\": 2.2,\n        \"range\": 2.25,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 0.75\n      },\n      \n      \"netherite_stiletto\": {\n        \"tier\": \"Netherite\",\n        \n        \"damage\": 4.6,\n        \"speed\": 2.5,\n        \"range\": 2,\n        \n        \"piercingChance\": 0.25,\n        \"piercingAmount\": 4,\n        \"invincibilityTime\": 7\n      },\n      \n      \"netherite_rapier\": {\n        \"tier\": \"Netherite\",\n        \n        \"damage\": 4.8,\n        \"speed\": 2,\n        \n        \"unarmoredBonus\": 3,\n        \n        \"canSweep\": true\n      },\n      \n      \"netherite_katana\": {\n        \"tier\": \"Netherite\",\n        \n        \"damage\": 7.9,\n        \"speed\": 1.8,\n        \"range\": 3.25,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 1.25,\n        \"sweepDamage\": 2,\n        \n        \"twoHandedLevel\": 1,\n\t\t\"createThdCopy\": true,\n        \"twoHandedMinDamage\": 2,\n        \"twoHandedMajDamage\": 5,\n        \"twoHandedMinSpeed\": 0.05,\n        \"twoHandedMajSpeed\": 1\n      },\n      \n      \"netherite_greatsword\": {\n        \"tier\": \"Netherite\",\n        \n        \"damage\": 9.3,\n        \"speed\": 1.2,\n        \"range\": 3.5,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 1.5,\n        \"sweepDamage\": 5,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 6,\n        \"twoHandedMajSpeed\": 0.4\n      },\n      \n      \"netherite_longsword\": {\n        \"tier\": \"Netherite\",\n        \n        \"damage\": 10.2,\n        \"speed\": 1.3,\n        \"range\": 3.5,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 2,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 6,\n        \"twoHandedMajSpeed\": 0.4\n      },\n      \n      \"netherite_twinblade\": {\n        \"tier\": \"Netherite\",\n        \n        \"damage\": 7.8,\n        \"speed\": 1.9,\n        \"range\": 3.5,\n        \n        \"canSweep\": true,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 6,\n        \"twoHandedMajSpeed\": 0.4\n      },\n      \n      \"netherite_zweihander\": {\n        \"tier\": \"Netherite\",\n        \n        \"damage\": 9.6,\n        \"speed\": 1,\n        \"range\": 4,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 2.5,\n        \"sweepDamage\": 2,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 5,\n        \"twoHandedMajSpeed\": 0.5\n      },\n\n      \"netherite_battle_axe\": {\n        \"tier\": \"Netherite\",\n        \"weaponType\": \"Axe\",\n\n        \"damage\": 17.7,\n        \"speed\": 0.6,\n        \"range\": 3.25,\n\n        \"twoHandedLevel\": 1,\n\t\t\"createThdCopy\": true,\n        \"twoHandedMinDamage\": 1,\n        \"twoHandedMajDamage\": 5,\n        \"twoHandedMinSpeed\": 0.1,\n        \"twoHandedMajSpeed\": 0.3\n      },\n      \n      \"netherite_glaive\": {\n        \"tier\": \"Netherite\",\n        \n        \"damage\": 11.6,\n        \"speed\": 1,\n        \"range\": 4,\n        \n        \"canSweep\": true,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 4,\n        \"twoHandedMajSpeed\": 0.5\n      },\n      \n      \"netherite_spear\": {\n        \"tier\": \"Netherite\",\n        \n        \"damage\": 6.2,\n        \"speed\": 1.3,\n        \"range\": 4.2,\n        \n        \"piercingAmount\": 2,\n        \n        \"twoHandedLevel\": 1,\n\t\t\"createThdCopy\": true,\n        \"twoHandedMajDamage\": 3,\n        \"twoHandedMinSpeed\": 0.1,\n        \"twoHandedMajSpeed\": 0.55\n      },\n      \n      \"netherite_halberd\": {\n        \"tier\": \"Netherite\",\n        \n        \"damage\": 12.3,\n        \"speed\": 0.7,\n        \"range\": 4.5,\n        \n        \"piercingChance\": 0.5,\n        \"piercingAmount\": 4,\n        \"breachChance\": 1,\n        \"breachTime\": 1.5,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 5,\n        \"twoHandedMajSpeed\": 0.2\n      },\n      \n      \"netherite_pike\": {\n        \"tier\": \"Netherite\",\n        \n        \"damage\": 10,\n        \"speed\": 0.8,\n        \"range\": 5,\n        \n        \"piercingAmount\": 2,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 4,\n        \"twoHandedMajSpeed\": 0.3\n      },\n\n      \"netherite_throwing_knife\": {\n        \"tier\": \"Netherite\",\n\n        \"damage\": 5,\n        \"speed\": 1.6,\n        \"range\": 3,\n\n        \"throwingWeapon\": {\n          \"damage\": 10,\n          \"force\": 2.5,\n          \"ammo\": 8,\n\n          \"chargeTime\": 10,\n          \"inaccuracy\": 1,\n          \"weight\": 1,\n          \"waterInertia\": 0.7,\n\n          \"modelData\": {\n            \"textureSize\": \"16X\",\n            \"useAnim\": \"spear\",\n            \"rotating\": false,\n            \"horizontal\": false\n          }\n        }\n      },\n\n      \"netherite_shuriken\": {\n        \"tier\": \"Netherite\",\n\n        \"damage\": 5,\n        \"speed\": 1.6,\n        \"range\": 3,\n\n        \"throwingWeapon\": {\n          \"damage\": 10,\n          \"force\": 2.5,\n          \"ammo\": 16,\n\n          \"chargeTime\": 10,\n          \"inaccuracy\": 1,\n          \"weight\": 1,\n          \"waterInertia\": 0.6,\n\n          \"modelData\": {\n            \"textureSize\": \"16X\",\n            \"useAnim\": \"spear\",\n            \"rotating\": true,\n            \"horizontal\": false\n          }\n        }\n      },\n\n      \"netherite_chakram\": {\n        \"tier\": \"Netherite\",\n\n        \"damage\": 5,\n        \"speed\": 1.6,\n        \"range\": 3,\n\n        \"throwingWeapon\": {\n          \"damage\": 10,\n          \"force\": 2.5,\n          \"ammo\": 4,\n\n          \"chargeTime\": 10,\n          \"inaccuracy\": 1,\n          \"weight\": 0.5,\n          \"waterInertia\": 1,\n\n          \"modelData\": {\n            \"textureSize\": \"16X\",\n            \"useAnim\": \"spear\",\n            \"rotating\": true,\n            \"horizontal\": true\n          }\n        }\n      },\n\n      \"netherite_javelin\": {\n        \"tier\": \"Netherite\",\n\n        \"damage\": 5,\n        \"speed\": 1.6,\n        \"range\": 3,\n\n        \"throwingWeapon\": {\n          \"damage\": 10,\n          \"force\": 2.5,\n          \"ammo\": 2,\n\n          \"chargeTime\": 10,\n          \"inaccuracy\": 1,\n          \"weight\": 1,\n          \"waterInertia\": 0.6,\n\n          \"modelData\": {\n            \"textureSize\": \"32X\",\n            \"useAnim\": \"spear\",\n            \"rotating\": false,\n            \"horizontal\": false\n          }\n        }\n      },\n      \n      \"electrum_dagger\": {\n        \"dependencies\": \"oreganized\",\n        \n        \"tier\": \"Electrum\",\n        \n        \"damage\": 4,\n        \"range\": 1.8,\n        \n        \"invincibilityTime\": 5,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 0.25\n      },\n      \n      \"electrum_shortsword\": {\n        \"dependencies\": \"oreganized\",\n        \n        \"tier\": \"Electrum\",\n        \n        \"damage\": 6,\n        \"speed\": 2.5,\n        \"range\": 2.25,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 0.75\n      },\n      \n      \"electrum_stiletto\": {\n        \"dependencies\": \"oreganized\",\n        \n        \"tier\": \"Electrum\",\n        \n        \"damage\": 4,\n        \"speed\": 2.8,\n        \"range\": 2,\n        \n        \"piercingChance\": 0.25,\n        \"piercingAmount\": 4,\n        \"invincibilityTime\": 7\n      },\n      \n      \"electrum_rapier\": {\n        \"dependencies\": \"oreganized\",\n        \n        \"tier\": \"Electrum\",\n        \n        \"damage\": 4,\n        \"speed\": 2.2,\n        \n        \"unarmoredBonus\": 3,\n        \n        \"canSweep\": true\n      },\n      \n      \"electrum_katana\": {\n        \"dependencies\": \"oreganized\",\n        \n        \"tier\": \"Electrum\",\n        \n        \"damage\": 7,\n        \"speed\": 2,\n        \"range\": 3.25,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 1.25,\n        \"sweepDamage\": 2,\n        \n        \"twoHandedLevel\": 1,\n\t\t\"createThdCopy\": true,\n        \"twoHandedMinDamage\": 2,\n        \"twoHandedMajDamage\": 5,\n        \"twoHandedMinSpeed\": 0.05,\n        \"twoHandedMajSpeed\": 1\n      },\n      \n      \"electrum_greatsword\": {\n        \"dependencies\": \"oreganized\",\n        \n        \"tier\": \"Electrum\",\n        \n        \"damage\": 8,\n        \"speed\": 1.4,\n        \"range\": 3.5,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 1.5,\n        \"sweepDamage\": 5,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 6,\n        \"twoHandedMajSpeed\": 0.4\n      },\n      \n      \"electrum_longsword\": {\n        \"dependencies\": \"oreganized\",\n        \n        \"tier\": \"Electrum\",\n        \n        \"damage\": 9,\n        \"speed\": 1.5,\n        \"range\": 3.5,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 2,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 6,\n        \"twoHandedMajSpeed\": 0.4\n      },\n      \n      \"electrum_twinblade\": {\n        \"dependencies\": \"oreganized\",\n        \n        \"tier\": \"Electrum\",\n        \n        \"damage\": 7,\n        \"speed\": 2.1,\n        \"range\": 3.5,\n        \n        \"canSweep\": true,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 6,\n        \"twoHandedMajSpeed\": 0.4\n      },\n      \n      \"electrum_zweihander\": {\n        \"dependencies\": \"oreganized\",\n        \n        \"tier\": \"Electrum\",\n        \n        \"damage\": 8,\n        \"speed\": 1.2,\n        \"range\": 4,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 2.5,\n        \"sweepDamage\": 2,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 5,\n        \"twoHandedMajSpeed\": 0.5\n      },\n\n      \"electrum_battle_axe\": {\n        \"dependencies\": \"oreganized\",\n\n        \"tier\": \"Electrum\",\n        \"weaponType\": \"Axe\",\n\n        \"damage\": 15,\n        \"speed\": 0.65,\n        \"range\": 3.25,\n\n        \"twoHandedLevel\": 1,\n\t\t\"createThdCopy\": true,\n        \"twoHandedMinDamage\": 1,\n        \"twoHandedMajDamage\": 5,\n        \"twoHandedMinSpeed\": 0.1,\n        \"twoHandedMajSpeed\": 0.3\n      },\n      \n      \"electrum_glaive\": {\n        \"dependencies\": \"oreganized\",\n        \n        \"tier\": \"Electrum\",\n        \n        \"damage\": 10,\n        \"speed\": 1.2,\n        \"range\": 4,\n        \n        \"canSweep\": true,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 4,\n        \"twoHandedMajSpeed\": 0.5\n      },\n      \n      \"electrum_spear\": {\n        \"dependencies\": \"oreganized\",\n        \n        \"tier\": \"Electrum\",\n        \n        \"damage\": 5,\n        \"speed\": 1.5,\n        \"range\": 4.2,\n        \n        \"piercingAmount\": 2,\n        \n        \"twoHandedLevel\": 1,\n\t\t\"createThdCopy\": true,\n        \"twoHandedMajDamage\": 3,\n        \"twoHandedMinSpeed\": 0.1,\n        \"twoHandedMajSpeed\": 0.55\n      },\n      \n      \"electrum_halberd\": {\n        \"dependencies\": \"oreganized\",\n        \n        \"tier\": \"Electrum\",\n        \n        \"damage\": 10,\n        \"speed\": 0.8,\n        \"range\": 4.5,\n        \n        \"piercingChance\": 0.5,\n        \"piercingAmount\": 4,\n        \"breachChance\": 1,\n        \"breachTime\": 1.5,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 5,\n        \"twoHandedMajSpeed\": 0.2\n      },\n      \n      \"electrum_pike\": {\n        \"dependencies\": \"oreganized\",\n        \n        \"tier\": \"Electrum\",\n        \n        \"damage\": 8,\n        \"speed\": 1,\n        \"range\": 5,\n        \n        \"piercingAmount\": 2,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 4,\n        \"twoHandedMajSpeed\": 0.3\n      },\n\n      \"electrum_throwing_knife\": {\n        \"tier\": \"Electrum\",\n\n        \"damage\": 5,\n        \"speed\": 1.6,\n        \"range\": 3,\n\n        \"throwingWeapon\": {\n          \"damage\": 10,\n          \"force\": 2.5,\n          \"ammo\": 8,\n\n          \"chargeTime\": 10,\n          \"inaccuracy\": 1,\n          \"weight\": 1,\n          \"waterInertia\": 0.7,\n\n          \"modelData\": {\n            \"textureSize\": \"16X\",\n            \"useAnim\": \"spear\",\n            \"rotating\": false,\n            \"horizontal\": false\n          }\n        }\n      },\n\n      \"electrum_shuriken\": {\n        \"tier\": \"Electrum\",\n\n        \"damage\": 5,\n        \"speed\": 1.6,\n        \"range\": 3,\n\n        \"throwingWeapon\": {\n          \"damage\": 10,\n          \"force\": 2.5,\n          \"ammo\": 16,\n\n          \"chargeTime\": 10,\n          \"inaccuracy\": 1,\n          \"weight\": 1,\n          \"waterInertia\": 0.6,\n\n          \"modelData\": {\n            \"textureSize\": \"16X\",\n            \"useAnim\": \"spear\",\n            \"rotating\": true,\n            \"horizontal\": false\n          }\n        }\n      },\n\n      \"electrum_chakram\": {\n        \"tier\": \"Electrum\",\n\n        \"damage\": 5,\n        \"speed\": 1.6,\n        \"range\": 3,\n\n        \"throwingWeapon\": {\n          \"damage\": 10,\n          \"force\": 2.5,\n          \"ammo\": 4,\n\n          \"chargeTime\": 10,\n          \"inaccuracy\": 1,\n          \"weight\": 0.5,\n          \"waterInertia\": 1,\n\n          \"modelData\": {\n            \"textureSize\": \"16X\",\n            \"useAnim\": \"spear\",\n            \"rotating\": true,\n            \"horizontal\": true\n          }\n        }\n      },\n\n      \"electrum_javelin\": {\n        \"tier\": \"Electrum\",\n\n        \"damage\": 5,\n        \"speed\": 1.6,\n        \"range\": 3,\n\n        \"throwingWeapon\": {\n          \"damage\": 10,\n          \"force\": 2.5,\n          \"ammo\": 2,\n\n          \"chargeTime\": 10,\n          \"inaccuracy\": 1,\n          \"weight\": 1,\n          \"waterInertia\": 0.6,\n\n          \"modelData\": {\n            \"textureSize\": \"32X\",\n            \"useAnim\": \"spear\",\n            \"rotating\": false,\n            \"horizontal\": false\n          }\n        }\n      },\n      \n      \"adamantite_dagger\": {\n        \"dependencies\": \"enlightened_end\",\n        \n        \"tier\": \"Adamantite\",\n        \n        \"damage\": 5,\n        \"speed\": 3.1,\n        \"range\": 1.8,\n        \n        \"invincibilityTime\": 5,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 0.25\n      },\n      \n      \"adamantite_shortsword\": {\n        \"dependencies\": \"enlightened_end\",\n        \n        \"tier\": \"Adamantite\",\n        \n        \"damage\": 7.4,\n        \"speed\": 2,\n        \"range\": 2.25,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 0.75\n      },\n      \n      \"adamantite_stiletto\": {\n        \"dependencies\": \"enlightened_end\",\n        \n        \"tier\": \"Adamantite\",\n        \n        \"damage\": 5.2,\n        \"speed\": 2.2,\n        \"range\": 2,\n        \n        \"piercingChance\": 0.25,\n        \"piercingAmount\": 4,\n        \"invincibilityTime\": 7\n      },\n      \n      \"adamantite_rapier\": {\n        \"dependencies\": \"enlightened_end\",\n        \n        \"tier\": \"Adamantite\",\n        \n        \"damage\": 5.6,\n        \"speed\": 1.8,\n        \n        \"unarmoredBonus\": 3,\n        \n        \"canSweep\": true\n      },\n      \n      \"adamantite_katana\": {\n        \"dependencies\": \"enlightened_end\",\n        \n        \"tier\": \"Adamantite\",\n        \n        \"damage\": 8.8,\n        \"speed\": 1.6,\n        \"range\": 3.25,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 1.25,\n        \"sweepDamage\": 2,\n        \n        \"twoHandedLevel\": 1,\n\t\t\"createThdCopy\": true,\n        \"twoHandedMinDamage\": 2,\n        \"twoHandedMajDamage\": 5,\n        \"twoHandedMinSpeed\": 0.05,\n        \"twoHandedMajSpeed\": 1\n      },\n      \n      \"adamantite_greatsword\": {\n        \"dependencies\": \"enlightened_end\",\n        \n        \"tier\": \"Adamantite\",\n        \n        \"damage\": 10.6,\n        \"speed\": 1,\n        \"range\": 3.5,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 1.5,\n        \"sweepDamage\": 5,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 6,\n        \"twoHandedMajSpeed\": 0.4\n      },\n      \n      \"adamantite_longsword\": {\n        \"dependencies\": \"enlightened_end\",\n        \n        \"tier\": \"Adamantite\",\n        \n        \"damage\": 11.4,\n        \"speed\": 1.1,\n        \"range\": 3.5,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 2,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 6,\n        \"twoHandedMajSpeed\": 0.4\n      },\n      \n      \"adamantite_twinblade\": {\n        \"dependencies\": \"enlightened_end\",\n        \n        \"tier\": \"Adamantite\",\n        \n        \"damage\": 8.6,\n        \"speed\": 1.7,\n        \"range\": 3.5,\n        \n        \"canSweep\": true,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 6,\n        \"twoHandedMajSpeed\": 0.4\n      },\n      \n      \"adamantite_zweihander\": {\n        \"dependencies\": \"enlightened_end\",\n        \n        \"tier\": \"Adamantite\",\n        \n        \"damage\": 11.2,\n        \"speed\": 0.8,\n        \"range\": 4,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 2.5,\n        \"sweepDamage\": 2,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 5,\n        \"twoHandedMajSpeed\": 0.5\n      },\n\n      \"adamantite_battle_axe\": {\n        \"dependencies\": \"enlightened_end\",\n\n        \"tier\": \"Adamantite\",\n        \"weaponType\": \"Axe\",\n\n        \"damage\": 20.4,\n        \"speed\": 0.5,\n        \"range\": 3.25,\n\n        \"twoHandedLevel\": 1,\n\t\t\"createThdCopy\": true,\n        \"twoHandedMinDamage\": 1,\n        \"twoHandedMajDamage\": 5,\n        \"twoHandedMinSpeed\": 0.1,\n        \"twoHandedMajSpeed\": 0.3\n      },\n      \n      \"adamantite_glaive\": {\n        \"dependencies\": \"enlightened_end\",\n        \n        \"tier\": \"Adamantite\",\n        \n        \"damage\": 13.2,\n        \"speed\": 0.9,\n        \"range\": 4,\n        \n        \"canSweep\": true,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 4,\n        \"twoHandedMajSpeed\": 0.5\n      },\n      \n      \"adamantite_spear\": {\n        \"dependencies\": \"enlightened_end\",\n        \n        \"tier\": \"Adamantite\",\n        \n        \"damage\": 7.4,\n        \"speed\": 1.1,\n        \"range\": 4.2,\n        \n        \"piercingAmount\": 2,\n        \n        \"twoHandedLevel\": 1,\n\t\t\"createThdCopy\": true,\n        \"twoHandedMajDamage\": 3,\n        \"twoHandedMinSpeed\": 0.1,\n        \"twoHandedMajSpeed\": 0.55\n      },\n      \n      \"adamantite_halberd\": {\n        \"dependencies\": \"enlightened_end\",\n        \n        \"tier\": \"Adamantite\",\n        \n        \"damage\": 14.6,\n        \"speed\": 0.6,\n        \"range\": 4.5,\n        \n        \"piercingChance\": 0.5,\n        \"piercingAmount\": 4,\n        \"breachChance\": 1,\n        \"breachTime\": 1.5,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 5,\n        \"twoHandedMajSpeed\": 0.2\n      },\n      \n      \"adamantite_pike\": {\n        \"dependencies\": \"enlightened_end\",\n        \n        \"tier\": \"Adamantite\",\n        \n        \"damage\": 12,\n        \"speed\": 0.7,\n        \"range\": 5,\n        \n        \"piercingAmount\": 2,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 4,\n        \"twoHandedMajSpeed\": 0.3\n      },\n\n      \"adamantite_throwing_knife\": {\n        \"tier\": \"Adamantite\",\n\n        \"damage\": 5,\n        \"speed\": 1.6,\n        \"range\": 3,\n\n        \"throwingWeapon\": {\n          \"damage\": 10,\n          \"force\": 2.5,\n          \"ammo\": 8,\n\n          \"chargeTime\": 10,\n          \"inaccuracy\": 1,\n          \"weight\": 1,\n          \"waterInertia\": 0.7,\n\n          \"modelData\": {\n            \"textureSize\": \"16X\",\n            \"useAnim\": \"spear\",\n            \"rotating\": false,\n            \"horizontal\": false\n          }\n        }\n      },\n\n      \"adamantite_shuriken\": {\n        \"tier\": \"Adamantite\",\n\n        \"damage\": 5,\n        \"speed\": 1.6,\n        \"range\": 3,\n\n        \"throwingWeapon\": {\n          \"damage\": 10,\n          \"force\": 2.5,\n          \"ammo\": 16,\n\n          \"chargeTime\": 10,\n          \"inaccuracy\": 1,\n          \"weight\": 1,\n          \"waterInertia\": 0.6,\n\n          \"modelData\": {\n            \"textureSize\": \"16X\",\n            \"useAnim\": \"spear\",\n            \"rotating\": true,\n            \"horizontal\": false\n          }\n        }\n      },\n\n      \"adamantite_chakram\": {\n        \"tier\": \"Adamantite\",\n\n        \"damage\": 5,\n        \"speed\": 1.6,\n        \"range\": 3,\n\n        \"throwingWeapon\": {\n          \"damage\": 10,\n          \"force\": 2.5,\n          \"ammo\": 4,\n\n          \"chargeTime\": 10,\n          \"inaccuracy\": 1,\n          \"weight\": 0.5,\n          \"waterInertia\": 1,\n\n          \"modelData\": {\n            \"textureSize\": \"16X\",\n            \"useAnim\": \"spear\",\n            \"rotating\": true,\n            \"horizontal\": true\n          }\n        }\n      },\n\n      \"adamantite_javelin\": {\n        \"tier\": \"Adamantite\",\n\n        \"damage\": 5,\n        \"speed\": 1.6,\n        \"range\": 3,\n\n        \"throwingWeapon\": {\n          \"damage\": 10,\n          \"force\": 2.5,\n          \"ammo\": 2,\n\n          \"chargeTime\": 10,\n          \"inaccuracy\": 1,\n          \"weight\": 1,\n          \"waterInertia\": 0.6,\n\n          \"modelData\": {\n            \"textureSize\": \"32X\",\n            \"useAnim\": \"spear\",\n            \"rotating\": false,\n            \"horizontal\": false\n          }\n        }\n      }\n    }\n  }\n}");
                writer.close();
                logger.info("Wrote a new file");
            }
            catch (IOException ignored) {
                logger.warn("Exception occured, couldn't write the file");
            }
        } else {
            logger.info("Didn't write a new file because none was created");
        }
        String configString = FileUtils.readFileToString((File)configFile, (Charset)StandardCharsets.UTF_8);
        try {
            CONFIG = (Map)new Gson().fromJson(configString, Map.class);
            try {
                for (Map.Entry<String, Map<String, ?>> i : CONFIG.get("weapons").get("regular").entrySet()) {
                    WeaponObject obj = DixtasArmoryJsonConfig.createWeaponObject(i, WEAPONS.size());
                    if (obj == null) continue;
                    WEAPONS.add(obj);
                }
            }
            catch (Exception e) {
                logger.warn("Failed to create weapons. " + e.getClass() + ": " + e.getMessage());
            }
        }
        catch (Exception e) {
            logger.warn("Failed to create a map from the given json info. " + e.getClass() + ": " + e.getMessage());
        }
    }

    public static void registerTiers() throws IOException {
        String path = System.getProperty("user.dir") + File.separator + "config" + File.separator + "dixtas_armory-common.json";
        Logger logger = LogManager.getLogger();
        File configFile = new File(path);
        boolean newFile = configFile.createNewFile();
        if (newFile) {
            try {
                FileWriter writer = new FileWriter(path);
                writer.write("{\n  \"weapons\": {\n    \"materials\": {\n    },\n\n    \"regular\": {\n      \"wooden_dagger\": {\n        \"tier\": \"Wood\",\n        \n        \"damage\": 2.4,\n        \"speed\": 3.5,\n        \"range\": 1.8,\n        \n        \"invincibilityTime\": 5,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 0.25\n      },\n      \n      \"wooden_shortsword\": {\n        \"tier\": \"Wood\",\n        \n        \"damage\": 3.8,\n        \"speed\": 2.2,\n        \"range\": 2.25,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 0.75\n      },\n      \n      \"wooden_stiletto\": {\n        \"tier\": \"Wood\",\n        \n        \"damage\": 2.6,\n        \"speed\": 2.5,\n        \"range\": 2,\n        \n        \"piercingChance\": 0.25,\n        \"piercingAmount\": 2,\n        \"invincibilityTime\": 7\n      },\n      \n      \"wooden_rapier\": {\n        \"tier\": \"Wood\",\n        \n        \"damage\": 2.6,\n        \"speed\": 2,\n        \n        \"unarmoredBonus\": 2,\n        \n        \"canSweep\": true\n      },\n      \n      \"wooden_katana\": {\n        \"tier\": \"Wood\",\n        \n        \"damage\": 4.3,\n        \"speed\": 1.8,\n        \"range\": 3.25,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 1.25,\n        \"sweepDamage\": 2,\n        \n        \"twoHandedLevel\": 1,\n\t\t\"createThdCopy\": true,\n        \"twoHandedMinDamage\": 1,\n        \"twoHandedMajDamage\": 3,\n        \"twoHandedMinSpeed\": 0.05,\n        \"twoHandedMajSpeed\": 1\n      },\n      \n      \"wooden_greatsword\": {\n        \"tier\": \"Wood\",\n        \n        \"damage\": 4,\n        \"speed\": 1.2,\n        \"range\": 3.5,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 1.5,\n        \"sweepDamage\": 3,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 4,\n        \"twoHandedMajSpeed\": 0.4\n      },\n      \n      \"wooden_longsword\": {\n        \"tier\": \"Wood\",\n        \n        \"damage\": 5.3,\n        \"speed\": 1.3,\n        \"range\": 3.5,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 2,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 4,\n        \"twoHandedMajSpeed\": 0.4\n      },\n      \n      \"wooden_twinblade\": {\n        \"tier\": \"Wood\",\n        \n        \"damage\": 4.5,\n        \"speed\": 1.9,\n        \"range\": 3.5,\n        \n        \"canSweep\": true,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 4,\n        \"twoHandedMajSpeed\": 0.4\n      },\n      \n      \"wooden_zweihander\": {\n        \"tier\": \"Wood\",\n        \n        \"damage\": 3.2,\n        \"speed\": 1,\n        \"range\": 4,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 2.5,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 3,\n        \"twoHandedMajSpeed\": 0.5\n      },\n\n      \"wooden_battle_axe\": {\n        \"tier\": \"Wood\",\n        \"weaponType\": \"Axe\",\n\n        \"damage\": 7,\n        \"speed\": 0.6,\n        \"range\": 3.25,\n\n        \"twoHandedLevel\": 1,\n\t\t\"createThdCopy\": true,\n        \"twoHandedMinDamage\": 1,\n        \"twoHandedMajDamage\": 3,\n        \"twoHandedMinSpeed\": 0.1,\n        \"twoHandedMajSpeed\": 0.3\n      },\n      \n      \"wooden_glaive\": {\n        \"tier\": \"Wood\",\n        \n        \"damage\": 5.2,\n        \"speed\": 1,\n        \"range\": 4,\n        \n        \"canSweep\": true,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 4,\n        \"twoHandedMajSpeed\": 0.5\n      },\n      \n      \"wooden_spear\": {\n        \"tier\": \"Wood\",\n        \n        \"damage\": 2.5,\n        \"speed\": 1.3,\n        \"range\": 4.2,\n        \n        \"piercingAmount\": 0.8,\n        \n        \"twoHandedLevel\": 1,\n\t\t\"createThdCopy\": true,\n        \"twoHandedMajDamage\": 1,\n        \"twoHandedMinSpeed\": 0.1,\n        \"twoHandedMajSpeed\": 0.55\n      },\n      \n      \"wooden_halberd\": {\n        \"tier\": \"Wood\",\n        \n        \"damage\": 4.1,\n        \"speed\": 0.7,\n        \"range\": 4.5,\n        \n        \"piercingChance\": 0.5,\n        \"piercingAmount\": 2,\n        \"breachChance\": 1,\n        \"breachTime\": 1.5,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 3,\n        \"twoHandedMajSpeed\": 0.2\n      },\n      \n      \"wooden_pike\": {\n        \"tier\": \"Wood\",\n        \n        \"damage\": 3,\n        \"speed\": 0.8,\n        \"range\": 5,\n        \n        \"piercingAmount\": 1,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 2,\n        \"twoHandedMajSpeed\": 0.3\n      },\n\n      \"wooden_throwing_knife\": {\n        \"tier\": \"Wood\",\n\n        \"damage\": 5,\n        \"speed\": 1.6,\n        \"range\": 3,\n\n        \"throwingWeapon\": {\n          \"damage\": 10,\n          \"force\": 2.5,\n          \"ammo\": 8,\n\n          \"chargeTime\": 10,\n          \"inaccuracy\": 1,\n          \"weight\": 1,\n          \"waterInertia\": 0.7,\n\n          \"modelData\": {\n            \"textureSize\": \"16X\",\n            \"useAnim\": \"spear\",\n            \"rotating\": false,\n            \"horizontal\": false\n          }\n        }\n      },\n\n      \"wooden_shuriken\": {\n        \"tier\": \"Wood\",\n\n        \"damage\": 5,\n        \"speed\": 1.6,\n        \"range\": 3,\n\n        \"throwingWeapon\": {\n          \"damage\": 10,\n          \"force\": 2.5,\n          \"ammo\": 16,\n\n          \"chargeTime\": 10,\n          \"inaccuracy\": 1,\n          \"weight\": 1,\n          \"waterInertia\": 0.6,\n\n          \"modelData\": {\n            \"textureSize\": \"16X\",\n            \"useAnim\": \"spear\",\n            \"rotating\": true,\n            \"horizontal\": false\n          }\n        }\n      },\n\n      \"wooden_chakram\": {\n        \"tier\": \"Wood\",\n\n        \"damage\": 5,\n        \"speed\": 1.6,\n        \"range\": 3,\n\n        \"throwingWeapon\": {\n          \"damage\": 10,\n          \"force\": 2.5,\n          \"ammo\": 4,\n\n          \"chargeTime\": 10,\n          \"inaccuracy\": 1,\n          \"weight\": 0.5,\n          \"waterInertia\": 1,\n\n          \"modelData\": {\n            \"textureSize\": \"16X\",\n            \"useAnim\": \"spear\",\n            \"rotating\": true,\n            \"horizontal\": true\n          }\n        }\n      },\n\n      \"wooden_javelin\": {\n        \"tier\": \"Wood\",\n\n        \"damage\": 5,\n        \"speed\": 1.6,\n        \"range\": 3,\n\n        \"throwingWeapon\": {\n          \"damage\": 10,\n          \"force\": 2.5,\n          \"ammo\": 2,\n\n          \"chargeTime\": 10,\n          \"inaccuracy\": 1,\n          \"weight\": 1,\n          \"waterInertia\": 0.6,\n\n          \"modelData\": {\n            \"textureSize\": \"32X\",\n            \"useAnim\": \"spear\",\n            \"rotating\": false,\n            \"horizontal\": false\n          }\n        }\n      },\n      \n      \"stone_dagger\": {\n        \"tier\": \"Stone\",\n        \n        \"damage\": 2.9,\n        \"speed\": 3.5,\n        \"range\": 1.8,\n        \n        \"invincibilityTime\": 5,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 0.25\n      },\n      \n      \"stone_shortsword\": {\n        \"tier\": \"Stone\",\n        \n        \"damage\": 4.5,\n        \"speed\": 2.2,\n        \"range\": 2.25,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 0.75\n      },\n      \n      \"stone_stiletto\": {\n        \"tier\": \"Stone\",\n        \n        \"damage\": 3.2,\n        \"speed\": 2.5,\n        \"range\": 2,\n        \n        \"piercingChance\": 0.25,\n        \"piercingAmount\": 2,\n        \"invincibilityTime\": 7\n      },\n      \n      \"stone_rapier\": {\n        \"tier\": \"Stone\",\n        \n        \"damage\": 3.4,\n        \"speed\": 2,\n        \n        \"unarmoredBonus\": 2,\n        \n        \"canSweep\": true\n      },\n      \n      \"stone_katana\": {\n        \"tier\": \"Stone\",\n        \n        \"damage\": 5.2,\n        \"speed\": 1.8,\n        \"range\": 3.25,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 1.25,\n        \"sweepDamage\": 2,\n        \n        \"twoHandedLevel\": 1,\n\t\t\"createThdCopy\": true,\n        \"twoHandedMinDamage\": 1,\n        \"twoHandedMajDamage\": 4,\n        \"twoHandedMinSpeed\": 0.05,\n        \"twoHandedMajSpeed\": 1\n      },\n      \n      \"stone_greatsword\": {\n        \"tier\": \"Stone\",\n        \n        \"damage\": 5.3,\n        \"speed\": 1.2,\n        \"range\": 3.5,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 1.5,\n        \"sweepDamage\": 4,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 5,\n        \"twoHandedMajSpeed\": 0.4\n      },\n      \n      \"stone_longsword\": {\n        \"tier\": \"Stone\",\n        \n        \"damage\": 6.5,\n        \"speed\": 1.3,\n        \"range\": 3.5,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 2,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 5,\n        \"twoHandedMajSpeed\": 0.4\n      },\n      \n      \"stone_twinblade\": {\n        \"tier\": \"Stone\",\n        \n        \"damage\": 5.3,\n        \"speed\": 1.9,\n        \"range\": 3.5,\n        \n        \"canSweep\": true,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 5,\n        \"twoHandedMajSpeed\": 0.4\n      },\n      \n      \"stone_zweihander\": {\n        \"tier\": \"Stone\",\n        \n        \"damage\": 4.8,\n        \"speed\": 1,\n        \"range\": 4,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 2.5,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 4,\n        \"twoHandedMajSpeed\": 0.5\n      },\n\n      \"stone_battle_axe\": {\n        \"tier\": \"Stone\",\n        \"weaponType\": \"Axe\",\n\n        \"damage\": 9.7,\n        \"speed\": 0.6,\n        \"range\": 3.25,\n\n        \"twoHandedLevel\": 1,\n\t\t\"createThdCopy\": true,\n        \"twoHandedMinDamage\": 1,\n        \"twoHandedMajDamage\": 3,\n        \"twoHandedMinSpeed\": 0.1,\n        \"twoHandedMajSpeed\": 0.3\n      },\n      \n      \"stone_glaive\": {\n        \"tier\": \"Stone\",\n        \n        \"damage\": 6.8,\n        \"speed\": 1,\n        \"range\": 4,\n        \n        \"canSweep\": true,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 4,\n        \"twoHandedMajSpeed\": 0.5\n      },\n      \n      \"stone_spear\": {\n        \"tier\": \"Stone\",\n        \n        \"damage\": 3.7,\n        \"speed\": 1.3,\n        \"range\": 4.2,\n        \n        \"piercingAmount\": 0.8,\n        \n        \"twoHandedLevel\": 1,\n\t\t\"createThdCopy\": true,\n        \"twoHandedMajDamage\": 2,\n        \"twoHandedMinSpeed\": 0.1,\n        \"twoHandedMajSpeed\": 0.55\n      },\n      \n      \"stone_halberd\": {\n        \"tier\": \"Stone\",\n        \n        \"damage\": 6.4,\n        \"speed\": 0.7,\n        \"range\": 4.5,\n        \n        \"piercingChance\": 0.5,\n        \"piercingAmount\": 2,\n        \"breachChance\": 1,\n        \"breachTime\": 1.5,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 4,\n        \"twoHandedMajSpeed\": 0.2\n      },\n      \n      \"stone_pike\": {\n        \"tier\": \"Stone\",\n        \n        \"damage\": 5,\n        \"speed\": 0.8,\n        \"range\": 5,\n        \n        \"piercingAmount\": 1,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 3,\n        \"twoHandedMajSpeed\": 0.3\n      },\n\n      \"stone_throwing_knife\": {\n        \"tier\": \"Stone\",\n\n        \"damage\": 5,\n        \"speed\": 1.6,\n        \"range\": 3,\n\n        \"throwingWeapon\": {\n          \"damage\": 10,\n          \"force\": 2.5,\n          \"ammo\": 8,\n\n          \"chargeTime\": 10,\n          \"inaccuracy\": 1,\n          \"weight\": 1,\n          \"waterInertia\": 0.7,\n\n          \"modelData\": {\n            \"textureSize\": \"16X\",\n            \"useAnim\": \"spear\",\n            \"rotating\": false,\n            \"horizontal\": false\n          }\n        }\n      },\n\n      \"stone_shuriken\": {\n        \"tier\": \"Stone\",\n\n        \"damage\": 5,\n        \"speed\": 1.6,\n        \"range\": 3,\n\n        \"throwingWeapon\": {\n          \"damage\": 10,\n          \"force\": 2.5,\n          \"ammo\": 16,\n\n          \"chargeTime\": 10,\n          \"inaccuracy\": 1,\n          \"weight\": 1,\n          \"waterInertia\": 0.6,\n\n          \"modelData\": {\n            \"textureSize\": \"16X\",\n            \"useAnim\": \"spear\",\n            \"rotating\": true,\n            \"horizontal\": false\n          }\n        }\n      },\n\n      \"stone_chakram\": {\n        \"tier\": \"Stone\",\n\n        \"damage\": 5,\n        \"speed\": 1.6,\n        \"range\": 3,\n\n        \"throwingWeapon\": {\n          \"damage\": 10,\n          \"force\": 2.5,\n          \"ammo\": 4,\n\n          \"chargeTime\": 10,\n          \"inaccuracy\": 1,\n          \"weight\": 0.5,\n          \"waterInertia\": 1,\n\n          \"modelData\": {\n            \"textureSize\": \"16X\",\n            \"useAnim\": \"spear\",\n            \"rotating\": true,\n            \"horizontal\": true\n          }\n        }\n      },\n\n      \"stone_javelin\": {\n        \"tier\": \"Stone\",\n\n        \"damage\": 5,\n        \"speed\": 1.6,\n        \"range\": 3,\n\n        \"throwingWeapon\": {\n          \"damage\": 10,\n          \"force\": 2.5,\n          \"ammo\": 2,\n\n          \"chargeTime\": 10,\n          \"inaccuracy\": 1,\n          \"weight\": 1,\n          \"waterInertia\": 0.6,\n\n          \"modelData\": {\n            \"textureSize\": \"32X\",\n            \"useAnim\": \"spear\",\n            \"rotating\": false,\n            \"horizontal\": false\n          }\n        }\n      },\n      \n      \"golden_dagger\": {\n        \"tier\": \"Gold\",\n        \n        \"damage\": 2.4,\n        \"speed\": 3.5,\n        \"range\": 1.8,\n        \n        \"invincibilityTime\": 5,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 0.25\n      },\n      \n      \"golden_shortsword\": {\n        \"tier\": \"Gold\",\n        \n        \"damage\": 3.8,\n        \"speed\": 2.2,\n        \"range\": 2.25,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 0.75\n      },\n      \n      \"golden_stiletto\": {\n        \"tier\": \"Gold\",\n        \n        \"damage\": 2.6,\n        \"speed\": 2.5,\n        \"range\": 2,\n        \n        \"piercingChance\": 0.25,\n        \"piercingAmount\": 2,\n        \"invincibilityTime\": 7\n      },\n      \n      \"golden_rapier\": {\n        \"tier\": \"Gold\",\n        \n        \"damage\": 2.6,\n        \"speed\": 2,\n        \n        \"unarmoredBonus\": 1,\n        \n        \"canSweep\": true\n      },\n      \n      \"golden_katana\": {\n        \"tier\": \"Gold\",\n        \n        \"damage\": 4.3,\n        \"speed\": 1.8,\n        \"range\": 3.25,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 1.25,\n        \"sweepDamage\": 2,\n        \n        \"twoHandedLevel\": 1,\n\t\t\"createThdCopy\": true,\n        \"twoHandedMinDamage\": 1,\n        \"twoHandedMajDamage\": 3,\n        \"twoHandedMinSpeed\": 0.05,\n        \"twoHandedMajSpeed\": 1\n      },\n      \n      \"golden_greatsword\": {\n        \"tier\": \"Gold\",\n        \n        \"damage\": 4,\n        \"speed\": 1.2,\n        \"range\": 3.5,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 1.5,\n        \"sweepDamage\": 3,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 4,\n        \"twoHandedMajSpeed\": 0.4\n      },\n      \n      \"golden_longsword\": {\n        \"tier\": \"Gold\",\n        \n        \"damage\": 5.3,\n        \"speed\": 1.3,\n        \"range\": 3.5,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 2,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 4,\n        \"twoHandedMajSpeed\": 0.4\n      },\n      \n      \"golden_twinblade\": {\n        \"tier\": \"Gold\",\n        \n        \"damage\": 4.5,\n        \"speed\": 1.9,\n        \"range\": 3.5,\n        \n        \"canSweep\": true,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 4,\n        \"twoHandedMajSpeed\": 0.4\n      },\n      \n      \"golden_zweihander\": {\n        \"tier\": \"Gold\",\n        \n        \"damage\": 3.2,\n        \"speed\": 1,\n        \"range\": 4,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 2.5,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 3,\n        \"twoHandedMajSpeed\": 0.5\n      },\n\n      \"golden_battle_axe\": {\n        \"tier\": \"Gold\",\n        \"weaponType\": \"Axe\",\n\n        \"damage\": 7,\n        \"speed\": 0.6,\n        \"range\": 3.25,\n\n        \"twoHandedLevel\": 1,\n\t\t\"createThdCopy\": true,\n        \"twoHandedMinDamage\": 1,\n        \"twoHandedMajDamage\": 3,\n        \"twoHandedMinSpeed\": 0.1,\n        \"twoHandedMajSpeed\": 0.3\n      },\n      \n      \"golden_glaive\": {\n        \"tier\": \"Gold\",\n        \n        \"damage\": 5.2,\n        \"speed\": 1,\n        \"range\": 4,\n        \n        \"canSweep\": true,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 4,\n        \"twoHandedMajSpeed\": 0.5\n      },\n      \n      \"golden_spear\": {\n        \"tier\": \"Gold\",\n        \n        \"damage\": 2.5,\n        \"speed\": 1.3,\n        \"range\": 4.2,\n        \n        \"piercingAmount\": 0.8,\n        \n        \"twoHandedLevel\": 1,\n\t\t\"createThdCopy\": true,\n        \"twoHandedMajDamage\": 1,\n        \"twoHandedMinSpeed\": 0.1,\n        \"twoHandedMajSpeed\": 0.55\n      },\n      \n      \"golden_halberd\": {\n        \"tier\": \"Gold\",\n        \n        \"damage\": 4.1,\n        \"speed\": 0.7,\n        \"range\": 4.5,\n        \n        \"piercingChance\": 0.5,\n        \"piercingAmount\": 4,\n        \"breachChance\": 1,\n        \"breachTime\": 1.5,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 3,\n        \"twoHandedMajSpeed\": 0.2\n      },\n      \n      \"golden_pike\": {\n        \"tier\": \"Gold\",\n        \n        \"damage\": 3,\n        \"speed\": 0.8,\n        \"range\": 5,\n        \n        \"piercingAmount\": 1,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 2,\n        \"twoHandedMajSpeed\": 0.3\n      },\n      \n      \"iron_dagger\": {\n        \"tier\": \"Iron\",\n        \n        \"damage\": 3.5,\n        \"speed\": 3.5,\n        \"range\": 1.8,\n        \n        \"invincibilityTime\": 5,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 0.25\n      },\n      \n      \"iron_shortsword\": {\n        \"tier\": \"Iron\",\n        \n        \"damage\": 5.3,\n        \"speed\": 2.2,\n        \"range\": 2.25,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 0.75\n      },\n      \n      \"iron_stiletto\": {\n        \"tier\": \"Iron\",\n        \n        \"damage\": 3.6,\n        \"speed\": 2.5,\n        \"range\": 2,\n        \n        \"piercingChance\": 0.25,\n        \"piercingAmount\": 3,\n        \"invincibilityTime\": 7\n      },\n      \n      \"iron_rapier\": {\n        \"tier\": \"Iron\",\n        \n        \"damage\": 4,\n        \"speed\": 2,\n        \n        \"unarmoredBonus\": 2.2,\n        \n        \"canSweep\": true\n      },\n      \n      \"iron_katana\": {\n        \"tier\": \"Iron\",\n        \n        \"damage\": 6.1,\n        \"speed\": 1.8,\n        \"range\": 3.25,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 1.25,\n        \"sweepDamage\": 2,\n        \n        \"twoHandedLevel\": 1,\n\t\t\"createThdCopy\": true,\n        \"twoHandedMinDamage\": 1,\n        \"twoHandedMajDamage\": 4,\n        \"twoHandedMinSpeed\": 0.1,\n        \"twoHandedMajSpeed\": 1\n      },\n      \n      \"iron_greatsword\": {\n        \"tier\": \"Iron\",\n        \n        \"damage\": 6.7,\n        \"speed\": 1.2,\n        \"range\": 3.5,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 1.5,\n        \"sweepDamage\": 4,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 5,\n        \"twoHandedMajSpeed\": 0.4\n      },\n      \n      \"iron_longsword\": {\n        \"tier\": \"Iron\",\n        \n        \"damage\": 7.8,\n        \"speed\": 1.3,\n        \"range\": 3.5,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 2,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 5,\n        \"twoHandedMajSpeed\": 0.4\n      },\n      \n      \"iron_twinblade\": {\n        \"tier\": \"Iron\",\n        \n        \"damage\": 6.2,\n        \"speed\": 1.9,\n        \"range\": 3.5,\n        \n        \"canSweep\": true,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 5,\n        \"twoHandedMajSpeed\": 0.4\n      },\n      \n      \"iron_zweihander\": {\n        \"tier\": \"Iron\",\n        \n        \"damage\": 6.4,\n        \"speed\": 1,\n        \"range\": 4,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 2.5,\n        \"sweepDamage\": 2,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 4,\n        \"twoHandedMajSpeed\": 0.5\n      },\n\n      \"iron_battle_axe\": {\n        \"tier\": \"Iron\",\n        \"weaponType\": \"Axe\",\n\n        \"damage\": 12.3,\n        \"speed\": 0.6,\n        \"range\": 3.25,\n\n        \"twoHandedLevel\": 1,\n\t\t\"createThdCopy\": true,\n        \"twoHandedMinDamage\": 1,\n        \"twoHandedMajDamage\": 3,\n        \"twoHandedMinSpeed\": 0.1,\n        \"twoHandedMajSpeed\": 0.3\n      },\n      \n      \"iron_glaive\": {\n        \"tier\": \"Iron\",\n        \n        \"damage\": 8.4,\n        \"speed\": 1,\n        \"range\": 4,\n        \n        \"canSweep\": true,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 4,\n        \"twoHandedMajSpeed\": 0.5\n      },\n      \n      \"iron_spear\": {\n        \"tier\": \"Iron\",\n        \n        \"damage\": 5,\n        \"speed\": 1.3,\n        \"range\": 4.2,\n        \n        \"piercingAmount\": 0.8,\n        \n        \"twoHandedLevel\": 1,\n\t\t\"createThdCopy\": true,\n        \"twoHandedMajDamage\": 2,\n        \"twoHandedMinSpeed\": 0.1,\n        \"twoHandedMajSpeed\": 0.55\n      },\n      \n      \"iron_halberd\": {\n        \"tier\": \"Iron\",\n        \n        \"damage\": 8.2,\n        \"speed\": 0.7,\n        \"range\": 4.5,\n        \n        \"piercingChance\": 0.5,\n        \"piercingAmount\": 3,\n        \"breachChance\": 1,\n        \"breachTime\": 1.5,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 3,\n        \"twoHandedMajSpeed\": 0.2\n      },\n      \n      \"iron_pike\": {\n        \"tier\": \"Iron\",\n        \n        \"damage\": 7,\n        \"speed\": 0.8,\n        \"range\": 5,\n        \n        \"piercingAmount\": 1,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 3,\n        \"twoHandedMajSpeed\": 0.3\n      },\n\n      \"iron_throwing_knife\": {\n        \"tier\": \"Iron\",\n\n        \"damage\": 5,\n        \"speed\": 1.6,\n        \"range\": 3,\n\n        \"throwingWeapon\": {\n          \"damage\": 10,\n          \"force\": 2.5,\n          \"ammo\": 8,\n\n          \"chargeTime\": 10,\n          \"inaccuracy\": 1,\n          \"weight\": 1,\n          \"waterInertia\": 0.7,\n\n          \"modelData\": {\n            \"textureSize\": \"16X\",\n            \"useAnim\": \"spear\",\n            \"rotating\": false,\n            \"horizontal\": false\n          }\n        }\n      },\n\n      \"iron_shuriken\": {\n        \"tier\": \"Iron\",\n\n        \"damage\": 5,\n        \"speed\": 1.6,\n        \"range\": 3,\n\n        \"throwingWeapon\": {\n          \"damage\": 10,\n          \"force\": 2.5,\n          \"ammo\": 16,\n\n          \"chargeTime\": 10,\n          \"inaccuracy\": 1,\n          \"weight\": 1,\n          \"waterInertia\": 0.6,\n\n          \"modelData\": {\n            \"textureSize\": \"16X\",\n            \"useAnim\": \"spear\",\n            \"rotating\": true,\n            \"horizontal\": false\n          }\n        }\n      },\n\n      \"iron_chakram\": {\n        \"tier\": \"Iron\",\n\n        \"damage\": 5,\n        \"speed\": 1.6,\n        \"range\": 3,\n\n        \"throwingWeapon\": {\n          \"damage\": 10,\n          \"force\": 2.5,\n          \"ammo\": 4,\n\n          \"chargeTime\": 10,\n          \"inaccuracy\": 1,\n          \"weight\": 0.5,\n          \"waterInertia\": 1,\n\n          \"modelData\": {\n            \"textureSize\": \"16X\",\n            \"useAnim\": \"spear\",\n            \"rotating\": true,\n            \"horizontal\": true\n          }\n        }\n      },\n\n      \"iron_javelin\": {\n        \"tier\": \"Iron\",\n\n        \"damage\": 5,\n        \"speed\": 1.6,\n        \"range\": 3,\n\n        \"throwingWeapon\": {\n          \"damage\": 10,\n          \"force\": 2.5,\n          \"ammo\": 2,\n\n          \"chargeTime\": 10,\n          \"inaccuracy\": 1,\n          \"weight\": 1,\n          \"waterInertia\": 0.6,\n\n          \"modelData\": {\n            \"textureSize\": \"32X\",\n            \"useAnim\": \"spear\",\n            \"rotating\": false,\n            \"horizontal\": false\n          }\n        }\n      },\n      \n      \"diamond_dagger\": {\n        \"tier\": \"Diamond\",\n        \n        \"damage\": 4,\n        \"speed\": 3.5,\n        \"range\": 1.8,\n        \n        \"invincibilityTime\": 5,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 0.25\n      },\n      \n      \"diamond_shortsword\": {\n        \"tier\": \"Diamond\",\n        \n        \"damage\": 6,\n        \"speed\": 2.2,\n        \"range\": 2.25,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 0.75\n      },\n      \n      \"diamond_stiletto\": {\n        \"tier\": \"Diamond\",\n        \n        \"damage\": 4,\n        \"speed\": 2.5,\n        \"range\": 2,\n        \n        \"piercingChance\": 0.25,\n        \"piercingAmount\": 4,\n        \"invincibilityTime\": 7\n      },\n      \n      \"diamond_rapier\": {\n        \"tier\": \"Diamond\",\n        \n        \"damage\": 4,\n        \"speed\": 2,\n        \n        \"unarmoredBonus\": 3,\n        \n        \"canSweep\": true\n      },\n      \n      \"diamond_katana\": {\n        \"tier\": \"Diamond\",\n        \n        \"damage\": 7,\n        \"speed\": 1.8,\n        \"range\": 3.25,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 1.25,\n        \"sweepDamage\": 2,\n        \n        \"twoHandedLevel\": 1,\n\t\t\"createThdCopy\": true,\n        \"twoHandedMinDamage\": 2,\n        \"twoHandedMajDamage\": 5,\n        \"twoHandedMinSpeed\": 0.05,\n        \"twoHandedMajSpeed\": 1\n      },\n      \n      \"diamond_greatsword\": {\n        \"tier\": \"Diamond\",\n        \n        \"damage\": 8,\n        \"speed\": 1.2,\n        \"range\": 3.5,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 1.5,\n        \"sweepDamage\": 5,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 6,\n        \"twoHandedMajSpeed\": 0.4\n      },\n      \n      \"diamond_longsword\": {\n        \"tier\": \"Diamond\",\n        \n        \"damage\": 9,\n        \"speed\": 1.3,\n        \"range\": 3.5,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 2,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 6,\n        \"twoHandedMajSpeed\": 0.4\n      },\n      \n      \"diamond_twinblade\": {\n        \"tier\": \"Diamond\",\n        \n        \"damage\": 7,\n        \"speed\": 1.9,\n        \"range\": 3.5,\n        \n        \"canSweep\": true,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 6,\n        \"twoHandedMajSpeed\": 0.4\n      },\n      \n      \"diamond_zweihander\": {\n        \"tier\": \"Diamond\",\n        \n        \"damage\": 8,\n        \"speed\": 1,\n        \"range\": 4,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 2.5,\n        \"sweepDamage\": 2,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 5,\n        \"twoHandedMajSpeed\": 0.5\n      },\n\n      \"diamond_battle_axe\": {\n        \"tier\": \"Diamond\",\n        \"weaponType\": \"Axe\",\n\n        \"damage\": 15,\n        \"speed\": 0.6,\n        \"range\": 3.25,\n\n        \"twoHandedLevel\": 1,\n\t\t\"createThdCopy\": true,\n        \"twoHandedMinDamage\": 1,\n        \"twoHandedMajDamage\": 4,\n        \"twoHandedMinSpeed\": 0.1,\n        \"twoHandedMajSpeed\": 0.3\n      },\n      \n      \"diamond_glaive\": {\n        \"tier\": \"Diamond\",\n        \n        \"damage\": 10,\n        \"speed\": 1,\n        \"range\": 4,\n        \n        \"canSweep\": true,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 4,\n        \"twoHandedMajSpeed\": 0.5\n      },\n      \n      \"diamond_spear\": {\n        \"tier\": \"Diamond\",\n        \n        \"damage\": 5,\n        \"speed\": 1.3,\n        \"range\": 4.2,\n        \n        \"piercingAmount\": 2,\n        \n        \"twoHandedLevel\": 1,\n\t\t\"createThdCopy\": true,\n        \"twoHandedMajDamage\": 3,\n        \"twoHandedMinSpeed\": 0.1,\n        \"twoHandedMajSpeed\": 0.55\n      },\n      \n      \"diamond_halberd\": {\n        \"tier\": \"Diamond\",\n        \n        \"damage\": 10,\n        \"speed\": 0.7,\n        \"range\": 4.5,\n        \n        \"piercingChance\": 0.5,\n        \"piercingAmount\": 4,\n        \"breachChance\": 1,\n        \"breachTime\": 1.5,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 5,\n        \"twoHandedMajSpeed\": 0.2\n      },\n      \n      \"diamond_pike\": {\n        \"tier\": \"Diamond\",\n\n        \"damage\": 8,\n        \"speed\": 0.8,\n        \"range\": 5,\n\n        \"piercingAmount\": 2,\n\n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 4,\n        \"twoHandedMajSpeed\": 0.3\n      },\n\n      \"diamond_throwing_knife\": {\n        \"tier\": \"Diamond\",\n\n        \"damage\": 5,\n        \"speed\": 1.6,\n        \"range\": 3,\n\n        \"throwingWeapon\": {\n          \"damage\": 10,\n          \"force\": 2.5,\n          \"ammo\": 8,\n\n          \"chargeTime\": 10,\n          \"inaccuracy\": 1,\n          \"weight\": 1,\n          \"waterInertia\": 0.7,\n\n          \"modelData\": {\n            \"textureSize\": \"16X\",\n            \"useAnim\": \"spear\",\n            \"rotating\": false,\n            \"horizontal\": false\n          }\n        }\n      },\n\n      \"diamond_shuriken\": {\n        \"tier\": \"Diamond\",\n\n        \"damage\": 5,\n        \"speed\": 1.6,\n        \"range\": 3,\n\n        \"throwingWeapon\": {\n          \"damage\": 10,\n          \"force\": 2.5,\n          \"ammo\": 16,\n\n          \"chargeTime\": 10,\n          \"inaccuracy\": 1,\n          \"weight\": 1,\n          \"waterInertia\": 0.6,\n\n          \"modelData\": {\n            \"textureSize\": \"16X\",\n            \"useAnim\": \"spear\",\n            \"rotating\": true,\n            \"horizontal\": false\n          }\n        }\n      },\n\n      \"diamond_chakram\": {\n        \"tier\": \"Diamond\",\n\n        \"damage\": 5,\n        \"speed\": 1.6,\n        \"range\": 3,\n\n        \"throwingWeapon\": {\n          \"damage\": 10,\n          \"force\": 2.5,\n          \"ammo\": 4,\n\n          \"chargeTime\": 10,\n          \"inaccuracy\": 1,\n          \"weight\": 0.5,\n          \"waterInertia\": 1,\n\n          \"modelData\": {\n            \"textureSize\": \"16X\",\n            \"useAnim\": \"spear\",\n            \"rotating\": true,\n            \"horizontal\": true\n          }\n        }\n      },\n\n      \"diamond_javelin\": {\n        \"tier\": \"Diamond\",\n\n        \"damage\": 5,\n        \"speed\": 1.6,\n        \"range\": 3,\n\n        \"throwingWeapon\": {\n          \"damage\": 10,\n          \"force\": 2.5,\n          \"ammo\": 2,\n\n          \"chargeTime\": 10,\n          \"inaccuracy\": 1,\n          \"weight\": 1,\n          \"waterInertia\": 0.6,\n\n          \"modelData\": {\n            \"textureSize\": \"32X\",\n            \"useAnim\": \"spear\",\n            \"rotating\": false,\n            \"horizontal\": false\n          }\n        }\n      },\n      \n      \"netherite_dagger\": {\n        \"tier\": \"Netherite\",\n        \n        \"damage\": 4.5,\n        \"speed\": 3.5,\n        \"range\": 1.8,\n        \n        \"invincibilityTime\": 5,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 0.25\n      },\n      \n      \"netherite_shortsword\": {\n        \"tier\": \"Netherite\",\n        \n        \"damage\": 6.7,\n        \"speed\": 2.2,\n        \"range\": 2.25,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 0.75\n      },\n      \n      \"netherite_stiletto\": {\n        \"tier\": \"Netherite\",\n        \n        \"damage\": 4.6,\n        \"speed\": 2.5,\n        \"range\": 2,\n        \n        \"piercingChance\": 0.25,\n        \"piercingAmount\": 4,\n        \"invincibilityTime\": 7\n      },\n      \n      \"netherite_rapier\": {\n        \"tier\": \"Netherite\",\n        \n        \"damage\": 4.8,\n        \"speed\": 2,\n        \n        \"unarmoredBonus\": 3,\n        \n        \"canSweep\": true\n      },\n      \n      \"netherite_katana\": {\n        \"tier\": \"Netherite\",\n        \n        \"damage\": 7.9,\n        \"speed\": 1.8,\n        \"range\": 3.25,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 1.25,\n        \"sweepDamage\": 2,\n        \n        \"twoHandedLevel\": 1,\n\t\t\"createThdCopy\": true,\n        \"twoHandedMinDamage\": 2,\n        \"twoHandedMajDamage\": 5,\n        \"twoHandedMinSpeed\": 0.05,\n        \"twoHandedMajSpeed\": 1\n      },\n      \n      \"netherite_greatsword\": {\n        \"tier\": \"Netherite\",\n        \n        \"damage\": 9.3,\n        \"speed\": 1.2,\n        \"range\": 3.5,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 1.5,\n        \"sweepDamage\": 5,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 6,\n        \"twoHandedMajSpeed\": 0.4\n      },\n      \n      \"netherite_longsword\": {\n        \"tier\": \"Netherite\",\n        \n        \"damage\": 10.2,\n        \"speed\": 1.3,\n        \"range\": 3.5,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 2,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 6,\n        \"twoHandedMajSpeed\": 0.4\n      },\n      \n      \"netherite_twinblade\": {\n        \"tier\": \"Netherite\",\n        \n        \"damage\": 7.8,\n        \"speed\": 1.9,\n        \"range\": 3.5,\n        \n        \"canSweep\": true,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 6,\n        \"twoHandedMajSpeed\": 0.4\n      },\n      \n      \"netherite_zweihander\": {\n        \"tier\": \"Netherite\",\n        \n        \"damage\": 9.6,\n        \"speed\": 1,\n        \"range\": 4,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 2.5,\n        \"sweepDamage\": 2,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 5,\n        \"twoHandedMajSpeed\": 0.5\n      },\n\n      \"netherite_battle_axe\": {\n        \"tier\": \"Netherite\",\n        \"weaponType\": \"Axe\",\n\n        \"damage\": 17.7,\n        \"speed\": 0.6,\n        \"range\": 3.25,\n\n        \"twoHandedLevel\": 1,\n\t\t\"createThdCopy\": true,\n        \"twoHandedMinDamage\": 1,\n        \"twoHandedMajDamage\": 5,\n        \"twoHandedMinSpeed\": 0.1,\n        \"twoHandedMajSpeed\": 0.3\n      },\n      \n      \"netherite_glaive\": {\n        \"tier\": \"Netherite\",\n        \n        \"damage\": 11.6,\n        \"speed\": 1,\n        \"range\": 4,\n        \n        \"canSweep\": true,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 4,\n        \"twoHandedMajSpeed\": 0.5\n      },\n      \n      \"netherite_spear\": {\n        \"tier\": \"Netherite\",\n        \n        \"damage\": 6.2,\n        \"speed\": 1.3,\n        \"range\": 4.2,\n        \n        \"piercingAmount\": 2,\n        \n        \"twoHandedLevel\": 1,\n\t\t\"createThdCopy\": true,\n        \"twoHandedMajDamage\": 3,\n        \"twoHandedMinSpeed\": 0.1,\n        \"twoHandedMajSpeed\": 0.55\n      },\n      \n      \"netherite_halberd\": {\n        \"tier\": \"Netherite\",\n        \n        \"damage\": 12.3,\n        \"speed\": 0.7,\n        \"range\": 4.5,\n        \n        \"piercingChance\": 0.5,\n        \"piercingAmount\": 4,\n        \"breachChance\": 1,\n        \"breachTime\": 1.5,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 5,\n        \"twoHandedMajSpeed\": 0.2\n      },\n      \n      \"netherite_pike\": {\n        \"tier\": \"Netherite\",\n        \n        \"damage\": 10,\n        \"speed\": 0.8,\n        \"range\": 5,\n        \n        \"piercingAmount\": 2,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 4,\n        \"twoHandedMajSpeed\": 0.3\n      },\n\n      \"netherite_throwing_knife\": {\n        \"tier\": \"Netherite\",\n\n        \"damage\": 5,\n        \"speed\": 1.6,\n        \"range\": 3,\n\n        \"throwingWeapon\": {\n          \"damage\": 10,\n          \"force\": 2.5,\n          \"ammo\": 8,\n\n          \"chargeTime\": 10,\n          \"inaccuracy\": 1,\n          \"weight\": 1,\n          \"waterInertia\": 0.7,\n\n          \"modelData\": {\n            \"textureSize\": \"16X\",\n            \"useAnim\": \"spear\",\n            \"rotating\": false,\n            \"horizontal\": false\n          }\n        }\n      },\n\n      \"netherite_shuriken\": {\n        \"tier\": \"Netherite\",\n\n        \"damage\": 5,\n        \"speed\": 1.6,\n        \"range\": 3,\n\n        \"throwingWeapon\": {\n          \"damage\": 10,\n          \"force\": 2.5,\n          \"ammo\": 16,\n\n          \"chargeTime\": 10,\n          \"inaccuracy\": 1,\n          \"weight\": 1,\n          \"waterInertia\": 0.6,\n\n          \"modelData\": {\n            \"textureSize\": \"16X\",\n            \"useAnim\": \"spear\",\n            \"rotating\": true,\n            \"horizontal\": false\n          }\n        }\n      },\n\n      \"netherite_chakram\": {\n        \"tier\": \"Netherite\",\n\n        \"damage\": 5,\n        \"speed\": 1.6,\n        \"range\": 3,\n\n        \"throwingWeapon\": {\n          \"damage\": 10,\n          \"force\": 2.5,\n          \"ammo\": 4,\n\n          \"chargeTime\": 10,\n          \"inaccuracy\": 1,\n          \"weight\": 0.5,\n          \"waterInertia\": 1,\n\n          \"modelData\": {\n            \"textureSize\": \"16X\",\n            \"useAnim\": \"spear\",\n            \"rotating\": true,\n            \"horizontal\": true\n          }\n        }\n      },\n\n      \"netherite_javelin\": {\n        \"tier\": \"Netherite\",\n\n        \"damage\": 5,\n        \"speed\": 1.6,\n        \"range\": 3,\n\n        \"throwingWeapon\": {\n          \"damage\": 10,\n          \"force\": 2.5,\n          \"ammo\": 2,\n\n          \"chargeTime\": 10,\n          \"inaccuracy\": 1,\n          \"weight\": 1,\n          \"waterInertia\": 0.6,\n\n          \"modelData\": {\n            \"textureSize\": \"32X\",\n            \"useAnim\": \"spear\",\n            \"rotating\": false,\n            \"horizontal\": false\n          }\n        }\n      },\n      \n      \"electrum_dagger\": {\n        \"dependencies\": \"oreganized\",\n        \n        \"tier\": \"Electrum\",\n        \n        \"damage\": 4,\n        \"range\": 1.8,\n        \n        \"invincibilityTime\": 5,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 0.25\n      },\n      \n      \"electrum_shortsword\": {\n        \"dependencies\": \"oreganized\",\n        \n        \"tier\": \"Electrum\",\n        \n        \"damage\": 6,\n        \"speed\": 2.5,\n        \"range\": 2.25,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 0.75\n      },\n      \n      \"electrum_stiletto\": {\n        \"dependencies\": \"oreganized\",\n        \n        \"tier\": \"Electrum\",\n        \n        \"damage\": 4,\n        \"speed\": 2.8,\n        \"range\": 2,\n        \n        \"piercingChance\": 0.25,\n        \"piercingAmount\": 4,\n        \"invincibilityTime\": 7\n      },\n      \n      \"electrum_rapier\": {\n        \"dependencies\": \"oreganized\",\n        \n        \"tier\": \"Electrum\",\n        \n        \"damage\": 4,\n        \"speed\": 2.2,\n        \n        \"unarmoredBonus\": 3,\n        \n        \"canSweep\": true\n      },\n      \n      \"electrum_katana\": {\n        \"dependencies\": \"oreganized\",\n        \n        \"tier\": \"Electrum\",\n        \n        \"damage\": 7,\n        \"speed\": 2,\n        \"range\": 3.25,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 1.25,\n        \"sweepDamage\": 2,\n        \n        \"twoHandedLevel\": 1,\n\t\t\"createThdCopy\": true,\n        \"twoHandedMinDamage\": 2,\n        \"twoHandedMajDamage\": 5,\n        \"twoHandedMinSpeed\": 0.05,\n        \"twoHandedMajSpeed\": 1\n      },\n      \n      \"electrum_greatsword\": {\n        \"dependencies\": \"oreganized\",\n        \n        \"tier\": \"Electrum\",\n        \n        \"damage\": 8,\n        \"speed\": 1.4,\n        \"range\": 3.5,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 1.5,\n        \"sweepDamage\": 5,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 6,\n        \"twoHandedMajSpeed\": 0.4\n      },\n      \n      \"electrum_longsword\": {\n        \"dependencies\": \"oreganized\",\n        \n        \"tier\": \"Electrum\",\n        \n        \"damage\": 9,\n        \"speed\": 1.5,\n        \"range\": 3.5,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 2,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 6,\n        \"twoHandedMajSpeed\": 0.4\n      },\n      \n      \"electrum_twinblade\": {\n        \"dependencies\": \"oreganized\",\n        \n        \"tier\": \"Electrum\",\n        \n        \"damage\": 7,\n        \"speed\": 2.1,\n        \"range\": 3.5,\n        \n        \"canSweep\": true,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 6,\n        \"twoHandedMajSpeed\": 0.4\n      },\n      \n      \"electrum_zweihander\": {\n        \"dependencies\": \"oreganized\",\n        \n        \"tier\": \"Electrum\",\n        \n        \"damage\": 8,\n        \"speed\": 1.2,\n        \"range\": 4,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 2.5,\n        \"sweepDamage\": 2,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 5,\n        \"twoHandedMajSpeed\": 0.5\n      },\n\n      \"electrum_battle_axe\": {\n        \"dependencies\": \"oreganized\",\n\n        \"tier\": \"Electrum\",\n        \"weaponType\": \"Axe\",\n\n        \"damage\": 15,\n        \"speed\": 0.65,\n        \"range\": 3.25,\n\n        \"twoHandedLevel\": 1,\n\t\t\"createThdCopy\": true,\n        \"twoHandedMinDamage\": 1,\n        \"twoHandedMajDamage\": 5,\n        \"twoHandedMinSpeed\": 0.1,\n        \"twoHandedMajSpeed\": 0.3\n      },\n      \n      \"electrum_glaive\": {\n        \"dependencies\": \"oreganized\",\n        \n        \"tier\": \"Electrum\",\n        \n        \"damage\": 10,\n        \"speed\": 1.2,\n        \"range\": 4,\n        \n        \"canSweep\": true,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 4,\n        \"twoHandedMajSpeed\": 0.5\n      },\n      \n      \"electrum_spear\": {\n        \"dependencies\": \"oreganized\",\n        \n        \"tier\": \"Electrum\",\n        \n        \"damage\": 5,\n        \"speed\": 1.5,\n        \"range\": 4.2,\n        \n        \"piercingAmount\": 2,\n        \n        \"twoHandedLevel\": 1,\n\t\t\"createThdCopy\": true,\n        \"twoHandedMajDamage\": 3,\n        \"twoHandedMinSpeed\": 0.1,\n        \"twoHandedMajSpeed\": 0.55\n      },\n      \n      \"electrum_halberd\": {\n        \"dependencies\": \"oreganized\",\n        \n        \"tier\": \"Electrum\",\n        \n        \"damage\": 10,\n        \"speed\": 0.8,\n        \"range\": 4.5,\n        \n        \"piercingChance\": 0.5,\n        \"piercingAmount\": 4,\n        \"breachChance\": 1,\n        \"breachTime\": 1.5,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 5,\n        \"twoHandedMajSpeed\": 0.2\n      },\n      \n      \"electrum_pike\": {\n        \"dependencies\": \"oreganized\",\n        \n        \"tier\": \"Electrum\",\n        \n        \"damage\": 8,\n        \"speed\": 1,\n        \"range\": 5,\n        \n        \"piercingAmount\": 2,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 4,\n        \"twoHandedMajSpeed\": 0.3\n      },\n\n      \"electrum_throwing_knife\": {\n        \"tier\": \"Electrum\",\n\n        \"damage\": 5,\n        \"speed\": 1.6,\n        \"range\": 3,\n\n        \"throwingWeapon\": {\n          \"damage\": 10,\n          \"force\": 2.5,\n          \"ammo\": 8,\n\n          \"chargeTime\": 10,\n          \"inaccuracy\": 1,\n          \"weight\": 1,\n          \"waterInertia\": 0.7,\n\n          \"modelData\": {\n            \"textureSize\": \"16X\",\n            \"useAnim\": \"spear\",\n            \"rotating\": false,\n            \"horizontal\": false\n          }\n        }\n      },\n\n      \"electrum_shuriken\": {\n        \"tier\": \"Electrum\",\n\n        \"damage\": 5,\n        \"speed\": 1.6,\n        \"range\": 3,\n\n        \"throwingWeapon\": {\n          \"damage\": 10,\n          \"force\": 2.5,\n          \"ammo\": 16,\n\n          \"chargeTime\": 10,\n          \"inaccuracy\": 1,\n          \"weight\": 1,\n          \"waterInertia\": 0.6,\n\n          \"modelData\": {\n            \"textureSize\": \"16X\",\n            \"useAnim\": \"spear\",\n            \"rotating\": true,\n            \"horizontal\": false\n          }\n        }\n      },\n\n      \"electrum_chakram\": {\n        \"tier\": \"Electrum\",\n\n        \"damage\": 5,\n        \"speed\": 1.6,\n        \"range\": 3,\n\n        \"throwingWeapon\": {\n          \"damage\": 10,\n          \"force\": 2.5,\n          \"ammo\": 4,\n\n          \"chargeTime\": 10,\n          \"inaccuracy\": 1,\n          \"weight\": 0.5,\n          \"waterInertia\": 1,\n\n          \"modelData\": {\n            \"textureSize\": \"16X\",\n            \"useAnim\": \"spear\",\n            \"rotating\": true,\n            \"horizontal\": true\n          }\n        }\n      },\n\n      \"electrum_javelin\": {\n        \"tier\": \"Electrum\",\n\n        \"damage\": 5,\n        \"speed\": 1.6,\n        \"range\": 3,\n\n        \"throwingWeapon\": {\n          \"damage\": 10,\n          \"force\": 2.5,\n          \"ammo\": 2,\n\n          \"chargeTime\": 10,\n          \"inaccuracy\": 1,\n          \"weight\": 1,\n          \"waterInertia\": 0.6,\n\n          \"modelData\": {\n            \"textureSize\": \"32X\",\n            \"useAnim\": \"spear\",\n            \"rotating\": false,\n            \"horizontal\": false\n          }\n        }\n      },\n      \n      \"adamantite_dagger\": {\n        \"dependencies\": \"enlightened_end\",\n        \n        \"tier\": \"Adamantite\",\n        \n        \"damage\": 5,\n        \"speed\": 3.1,\n        \"range\": 1.8,\n        \n        \"invincibilityTime\": 5,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 0.25\n      },\n      \n      \"adamantite_shortsword\": {\n        \"dependencies\": \"enlightened_end\",\n        \n        \"tier\": \"Adamantite\",\n        \n        \"damage\": 7.4,\n        \"speed\": 2,\n        \"range\": 2.25,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 0.75\n      },\n      \n      \"adamantite_stiletto\": {\n        \"dependencies\": \"enlightened_end\",\n        \n        \"tier\": \"Adamantite\",\n        \n        \"damage\": 5.2,\n        \"speed\": 2.2,\n        \"range\": 2,\n        \n        \"piercingChance\": 0.25,\n        \"piercingAmount\": 4,\n        \"invincibilityTime\": 7\n      },\n      \n      \"adamantite_rapier\": {\n        \"dependencies\": \"enlightened_end\",\n        \n        \"tier\": \"Adamantite\",\n        \n        \"damage\": 5.6,\n        \"speed\": 1.8,\n        \n        \"unarmoredBonus\": 3,\n        \n        \"canSweep\": true\n      },\n      \n      \"adamantite_katana\": {\n        \"dependencies\": \"enlightened_end\",\n        \n        \"tier\": \"Adamantite\",\n        \n        \"damage\": 8.8,\n        \"speed\": 1.6,\n        \"range\": 3.25,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 1.25,\n        \"sweepDamage\": 2,\n        \n        \"twoHandedLevel\": 1,\n\t\t\"createThdCopy\": true,\n        \"twoHandedMinDamage\": 2,\n        \"twoHandedMajDamage\": 5,\n        \"twoHandedMinSpeed\": 0.05,\n        \"twoHandedMajSpeed\": 1\n      },\n      \n      \"adamantite_greatsword\": {\n        \"dependencies\": \"enlightened_end\",\n        \n        \"tier\": \"Adamantite\",\n        \n        \"damage\": 10.6,\n        \"speed\": 1,\n        \"range\": 3.5,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 1.5,\n        \"sweepDamage\": 5,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 6,\n        \"twoHandedMajSpeed\": 0.4\n      },\n      \n      \"adamantite_longsword\": {\n        \"dependencies\": \"enlightened_end\",\n        \n        \"tier\": \"Adamantite\",\n        \n        \"damage\": 11.4,\n        \"speed\": 1.1,\n        \"range\": 3.5,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 2,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 6,\n        \"twoHandedMajSpeed\": 0.4\n      },\n      \n      \"adamantite_twinblade\": {\n        \"dependencies\": \"enlightened_end\",\n        \n        \"tier\": \"Adamantite\",\n        \n        \"damage\": 8.6,\n        \"speed\": 1.7,\n        \"range\": 3.5,\n        \n        \"canSweep\": true,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 6,\n        \"twoHandedMajSpeed\": 0.4\n      },\n      \n      \"adamantite_zweihander\": {\n        \"dependencies\": \"enlightened_end\",\n        \n        \"tier\": \"Adamantite\",\n        \n        \"damage\": 11.2,\n        \"speed\": 0.8,\n        \"range\": 4,\n        \n        \"canSweep\": true,\n        \"sweepRadius\": 2.5,\n        \"sweepDamage\": 2,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 5,\n        \"twoHandedMajSpeed\": 0.5\n      },\n\n      \"adamantite_battle_axe\": {\n        \"dependencies\": \"enlightened_end\",\n\n        \"tier\": \"Adamantite\",\n        \"weaponType\": \"Axe\",\n\n        \"damage\": 20.4,\n        \"speed\": 0.5,\n        \"range\": 3.25,\n\n        \"twoHandedLevel\": 1,\n\t\t\"createThdCopy\": true,\n        \"twoHandedMinDamage\": 1,\n        \"twoHandedMajDamage\": 5,\n        \"twoHandedMinSpeed\": 0.1,\n        \"twoHandedMajSpeed\": 0.3\n      },\n      \n      \"adamantite_glaive\": {\n        \"dependencies\": \"enlightened_end\",\n        \n        \"tier\": \"Adamantite\",\n        \n        \"damage\": 13.2,\n        \"speed\": 0.9,\n        \"range\": 4,\n        \n        \"canSweep\": true,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 4,\n        \"twoHandedMajSpeed\": 0.5\n      },\n      \n      \"adamantite_spear\": {\n        \"dependencies\": \"enlightened_end\",\n        \n        \"tier\": \"Adamantite\",\n        \n        \"damage\": 7.4,\n        \"speed\": 1.1,\n        \"range\": 4.2,\n        \n        \"piercingAmount\": 2,\n        \n        \"twoHandedLevel\": 1,\n\t\t\"createThdCopy\": true,\n        \"twoHandedMajDamage\": 3,\n        \"twoHandedMinSpeed\": 0.1,\n        \"twoHandedMajSpeed\": 0.55\n      },\n      \n      \"adamantite_halberd\": {\n        \"dependencies\": \"enlightened_end\",\n        \n        \"tier\": \"Adamantite\",\n        \n        \"damage\": 14.6,\n        \"speed\": 0.6,\n        \"range\": 4.5,\n        \n        \"piercingChance\": 0.5,\n        \"piercingAmount\": 4,\n        \"breachChance\": 1,\n        \"breachTime\": 1.5,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 5,\n        \"twoHandedMajSpeed\": 0.2\n      },\n      \n      \"adamantite_pike\": {\n        \"dependencies\": \"enlightened_end\",\n        \n        \"tier\": \"Adamantite\",\n        \n        \"damage\": 12,\n        \"speed\": 0.7,\n        \"range\": 5,\n        \n        \"piercingAmount\": 2,\n        \n        \"twoHandedLevel\": 2,\n        \"twoHandedMajDamage\": 4,\n        \"twoHandedMajSpeed\": 0.3\n      },\n\n      \"adamantite_throwing_knife\": {\n        \"tier\": \"Adamantite\",\n\n        \"damage\": 5,\n        \"speed\": 1.6,\n        \"range\": 3,\n\n        \"throwingWeapon\": {\n          \"damage\": 10,\n          \"force\": 2.5,\n          \"ammo\": 8,\n\n          \"chargeTime\": 10,\n          \"inaccuracy\": 1,\n          \"weight\": 1,\n          \"waterInertia\": 0.7,\n\n          \"modelData\": {\n            \"textureSize\": \"16X\",\n            \"useAnim\": \"spear\",\n            \"rotating\": false,\n            \"horizontal\": false\n          }\n        }\n      },\n\n      \"adamantite_shuriken\": {\n        \"tier\": \"Adamantite\",\n\n        \"damage\": 5,\n        \"speed\": 1.6,\n        \"range\": 3,\n\n        \"throwingWeapon\": {\n          \"damage\": 10,\n          \"force\": 2.5,\n          \"ammo\": 16,\n\n          \"chargeTime\": 10,\n          \"inaccuracy\": 1,\n          \"weight\": 1,\n          \"waterInertia\": 0.6,\n\n          \"modelData\": {\n            \"textureSize\": \"16X\",\n            \"useAnim\": \"spear\",\n            \"rotating\": true,\n            \"horizontal\": false\n          }\n        }\n      },\n\n      \"adamantite_chakram\": {\n        \"tier\": \"Adamantite\",\n\n        \"damage\": 5,\n        \"speed\": 1.6,\n        \"range\": 3,\n\n        \"throwingWeapon\": {\n          \"damage\": 10,\n          \"force\": 2.5,\n          \"ammo\": 4,\n\n          \"chargeTime\": 10,\n          \"inaccuracy\": 1,\n          \"weight\": 0.5,\n          \"waterInertia\": 1,\n\n          \"modelData\": {\n            \"textureSize\": \"16X\",\n            \"useAnim\": \"spear\",\n            \"rotating\": true,\n            \"horizontal\": true\n          }\n        }\n      },\n\n      \"adamantite_javelin\": {\n        \"tier\": \"Adamantite\",\n\n        \"damage\": 5,\n        \"speed\": 1.6,\n        \"range\": 3,\n\n        \"throwingWeapon\": {\n          \"damage\": 10,\n          \"force\": 2.5,\n          \"ammo\": 2,\n\n          \"chargeTime\": 10,\n          \"inaccuracy\": 1,\n          \"weight\": 1,\n          \"waterInertia\": 0.6,\n\n          \"modelData\": {\n            \"textureSize\": \"32X\",\n            \"useAnim\": \"spear\",\n            \"rotating\": false,\n            \"horizontal\": false\n          }\n        }\n      }\n    }\n  }\n}");
                writer.close();
                logger.info("Wrote a new file");
            }
            catch (IOException ignored) {
                logger.warn("Exception occured, couldn't write the file");
            }
        } else {
            logger.info("Didn't write a new file because none was created");
        }
        String configString = FileUtils.readFileToString((File)configFile, (Charset)StandardCharsets.UTF_8);
        try {
            CONFIG = (Map)new Gson().fromJson(configString, Map.class);
            try {
                for (Map.Entry<String, Map<String, ?>> tierData : CONFIG.get("weapons").get("materials").entrySet()) {
                    TIERS.add(DixtasArmoryJsonConfig.createTier(tierData));
                }
            }
            catch (Exception e) {
                logger.warn("Failed to register tiers. " + e.getClass() + ": " + e.getMessage());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        WEAPONS = new ArrayList<WeaponObject>();
        THD_COPIES = new ArrayList<WeaponObject>();
        TIERS = new ArrayList<String>();
    }
}

