/*
 * Decompiled with CFR 0.152.
 */
package net.dixta.dixtas_armory.entity;

import javax.annotation.Nullable;
import net.dixta.dixtas_armory.entity.ModEntities;
import net.dixta.dixtas_armory.item.custom.ThrowableItem;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;

public class ThrownWeaponEntity
extends AbstractArrow {
    private static final EntityDataAccessor<Byte> ID_LOYALTY = SynchedEntityData.m_135353_(ThrownWeaponEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Boolean> ID_FOIL = SynchedEntityData.m_135353_(ThrownWeaponEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<String> ID_ITEM = SynchedEntityData.m_135353_(ThrownWeaponEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private ItemStack weaponItem = new ItemStack((ItemLike)Items.f_41905_);
    private boolean dealtDamage;
    public int clientSideReturnTridentTickCount;
    public int airTime = 0;
    public float damage;
    public float weight;
    public float waterInertia;
    private int life = 0;

    public ThrownWeaponEntity(EntityType<? extends ThrownWeaponEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public ThrownWeaponEntity(Level pLevel, LivingEntity pShooter, ItemStack pStack) {
        super((EntityType)ModEntities.THROWN_WEAPON_PROJECTILE.get(), pShooter, pLevel);
        this.weaponItem = pStack.m_41777_();
        this.damage = ((ThrowableItem)this.weaponItem.m_41720_()).baseDamage;
        this.weight = ((ThrowableItem)this.weaponItem.m_41720_()).thrownWeight;
        this.waterInertia = ((ThrowableItem)this.weaponItem.m_41720_()).waterInertia;
        this.f_19804_.m_135381_(ID_FOIL, (Object)pStack.m_41790_());
        this.f_19804_.m_135381_(ID_ITEM, (Object)ForgeRegistries.ITEMS.getKey((Object)pStack.m_41720_()).toString());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ID_LOYALTY, (Object)0);
        this.f_19804_.m_135372_(ID_FOIL, (Object)false);
        this.f_19804_.m_135372_(ID_ITEM, (Object)"minecraft:bedrock");
    }

    public void m_8119_() {
        if (!this.f_36703_) {
            ++this.airTime;
        }
        if (this.f_36704_ > 4) {
            this.dealtDamage = true;
        }
        Entity entity = this.m_19749_();
        byte i = (Byte)this.f_19804_.m_135370_(ID_LOYALTY);
        if (i > 0 && (this.dealtDamage || this.m_36797_()) && entity != null) {
            if (!this.isAcceptibleReturnOwner()) {
                if (!this.m_9236_().f_46443_ && this.f_36705_ == AbstractArrow.Pickup.ALLOWED) {
                    this.m_5552_(this.m_7941_(), 0.1f);
                }
                this.m_146870_();
            } else {
                this.m_36790_(true);
                Vec3 vec3 = entity.m_146892_().m_82546_(this.m_20182_());
                this.m_20343_(this.m_20185_(), this.m_20186_() + vec3.f_82480_ * 0.015 * (double)i, this.m_20189_());
                if (this.m_9236_().f_46443_) {
                    this.f_19791_ = this.m_20186_();
                }
                double d0 = 0.05 * (double)i;
                this.m_20256_(this.m_20184_().m_82490_(0.95).m_82549_(vec3.m_82541_().m_82490_(d0)));
                if (this.clientSideReturnTridentTickCount == 0) {
                    this.m_5496_(SoundEvents.f_12516_, 10.0f, 1.0f);
                }
                ++this.clientSideReturnTridentTickCount;
            }
        }
        super.m_8119_();
        if (!this.m_20068_() && !this.m_36797_()) {
            Vec3 vec34 = this.m_20184_();
            this.m_20334_(vec34.f_82479_, vec34.f_82480_ + (double)0.05f - (double)this.weight * 0.05, vec34.f_82481_);
        }
    }

    private boolean isAcceptibleReturnOwner() {
        Entity entity = this.m_19749_();
        if (entity != null && entity.m_6084_()) {
            return !(entity instanceof ServerPlayer) || !entity.m_5833_();
        }
        return false;
    }

    protected ItemStack m_7941_() {
        return this.weaponItem.m_41777_();
    }

    protected ItemStack getRenderingItem() {
        ItemStack tempItem = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation((String)this.f_19804_.m_135370_(ID_ITEM))));
        if (this.isFoil()) {
            tempItem.m_41663_(Enchantments.f_44977_, 0);
        }
        return tempItem;
    }

    public boolean isFoil() {
        return (Boolean)this.f_19804_.m_135370_(ID_FOIL);
    }

    @Nullable
    protected EntityHitResult m_6351_(Vec3 pStartVec, Vec3 pEndVec) {
        return this.dealtDamage ? null : super.m_6351_(pStartVec, pEndVec);
    }

    protected void m_5790_(EntityHitResult pResult) {
        Entity entity = pResult.m_82443_();
        float f = this.damage;
        if (entity instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity;
            f += EnchantmentHelper.m_44833_((ItemStack)this.weaponItem, (MobType)livingentity.m_6336_());
        }
        Entity entity1 = this.m_19749_();
        DamageSource damagesource = this.m_269291_().m_269525_((Entity)this, (Entity)(entity1 == null ? this : entity1));
        this.dealtDamage = true;
        SoundEvent soundevent = SoundEvents.f_12514_;
        if (entity.m_6469_(damagesource, f)) {
            if (entity.m_6095_() == EntityType.f_20566_) {
                return;
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingentity1 = (LivingEntity)entity;
                if (entity1 instanceof LivingEntity) {
                    EnchantmentHelper.m_44823_((LivingEntity)livingentity1, (Entity)entity1);
                    EnchantmentHelper.m_44896_((LivingEntity)((LivingEntity)entity1), (Entity)livingentity1);
                }
                this.m_7761_(livingentity1);
            }
        }
        this.m_20256_(this.m_20184_().m_82542_(-0.01, -0.1, -0.01));
        float f1 = 1.0f;
        this.m_5496_(soundevent, f1, 1.0f);
    }

    public boolean isChanneling() {
        return EnchantmentHelper.m_44936_((ItemStack)this.weaponItem);
    }

    protected boolean canPickup(Player pPlayer) {
        switch (this.f_36705_) {
            case ALLOWED: {
                return this.tryAddAmmo(pPlayer);
            }
            case CREATIVE_ONLY: {
                return pPlayer.m_150110_().f_35937_;
            }
        }
        return false;
    }

    protected boolean m_142470_(Player pPlayer) {
        return this.canPickup(pPlayer) || this.m_36797_() && this.m_150171_((Entity)pPlayer) && this.tryAddAmmo(pPlayer);
    }

    protected boolean tryAddAmmo(Player pPlayer) {
        Item item = this.weaponItem.m_41720_();
        Inventory playerInventory = pPlayer.m_150109_();
        for (int i = 0; i < playerInventory.m_6643_(); ++i) {
            ItemStack stack = playerInventory.m_8020_(i);
            if (stack.m_41720_() != item || !stack.m_41784_().m_128342_("dixtas_armory.throwable.uuid").equals(this.weaponItem.m_41784_().m_128342_("dixtas_armory.throwable.uuid"))) continue;
            this.increaseAmmo(stack);
            return true;
        }
        return false;
    }

    protected void increaseAmmo(ItemStack pStack) {
        int defaultAmmo = ((ThrowableItem)pStack.m_41720_()).defaultAmmo;
        int currentAmmo = pStack.m_41784_().m_128451_("dixtas_armory.throwable.ammo");
        if (0 < currentAmmo && currentAmmo < defaultAmmo) {
            pStack.m_41784_().m_128405_("dixtas_armory.throwable.ammo", currentAmmo + 1);
        }
    }

    protected SoundEvent m_7239_() {
        return SoundEvents.f_12515_;
    }

    public void m_6123_(Player pEntity) {
        if (this.m_150171_((Entity)pEntity) || this.m_19749_() == null) {
            super.m_6123_(pEntity);
        }
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128425_("Weapon", 10)) {
            this.weaponItem = ItemStack.m_41712_((CompoundTag)pCompound.m_128469_("Weapon"));
        }
        this.dealtDamage = pCompound.m_128471_("DealtDamage");
        this.f_19804_.m_135381_(ID_LOYALTY, (Object)((byte)EnchantmentHelper.m_44928_((ItemStack)this.weaponItem)));
        this.f_19804_.m_135381_(ID_ITEM, (Object)ForgeRegistries.ITEMS.getKey((Object)this.weaponItem.m_41720_()).toString());
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128365_("Weapon", (Tag)this.weaponItem.m_41739_(new CompoundTag()));
        pCompound.m_128379_("DealtDamage", this.dealtDamage);
    }

    public void m_6901_() {
        byte i = (Byte)this.f_19804_.m_135370_(ID_LOYALTY);
        if (this.f_36705_ != AbstractArrow.Pickup.ALLOWED || i <= 0) {
            ++this.life;
            if (this.life >= 6000) {
                this.m_146870_();
            }
        }
    }

    protected float m_6882_() {
        return 0.99f;
    }

    public boolean m_6000_(double pX, double pY, double pZ) {
        return true;
    }
}

