/*
 * Decompiled with CFR 0.152.
 */
package net.dixta.dixtas_armory.item;

import java.util.ArrayList;
import java.util.List;
import net.dixta.dixtas_armory.config.DixtasArmoryJsonConfig;
import net.dixta.dixtas_armory.entity.TextureSize;
import net.dixta.dixtas_armory.item.LanceItem;
import net.dixta.dixtas_armory.item.custom.AdvancedSwordItem;
import net.dixta.dixtas_armory.item.custom.ThrowableItem;
import net.dixta.dixtas_armory.item.custom.TwoHandedIWeapon;
import net.dixta.dixtas_armory.item.custom.attributes.AttackAttribute;
import net.dixta.dixtas_armory.item.custom.attributes.SweepAttribute;
import net.dixta.dixtas_armory.item.custom.attributes.ThrownWeaponAttribute;
import net.dixta.dixtas_armory.item.custom.attributes.TwoHandedAttribute;
import net.dixta.dixtas_armory.item.custom.attributes.WeaponObject;
import net.dixta.dixtas_armory.item.custom.attributes.WeaponProperty;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.UseAnim;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ModItems {
    public static List<RegistryObject<Item>> CONFIG_WEAPONS = new ArrayList<RegistryObject<Item>>();
    public static List<RegistryObject<Item>> CONFIG_THD_COPIES = new ArrayList<RegistryObject<Item>>();
    public static List<RegistryObject<Item>> CONFIG_THROWABLES = new ArrayList<RegistryObject<Item>>();
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"dixtas_armory");
    public static final RegistryObject<Item> POLE = ITEMS.register("pole", () -> new Item(new Item.Properties()));
    public static final RegistryObject<Item> ICON = ITEMS.register("icon", () -> new Item(new Item.Properties()));
    public static final RegistryObject<Item> TEST_BOOMERANG = ITEMS.register("diamond_boomerang", () -> new ThrowableItem(new WeaponProperty((Tier)Tiers.DIAMOND, 4.0f, 1.0f, new Item.Properties(), 3.0f, AttackAttribute.none, TwoHandedAttribute.none, SweepAttribute.none, new ThrownWeaponAttribute(4.0f, 2.5f, 5, 10, 1.0f, 0.0f, 0.6f, new ThrownWeaponAttribute.ModelData(TextureSize.X16, UseAnim.SPEAR, true, true)), false), 0));
    public static final RegistryObject<Item> TEST_LANCE = ITEMS.register("diamond_lance", () -> new LanceItem(new WeaponProperty((Tier)Tiers.DIAMOND, 4.0f, 1.0f, new Item.Properties(), 3.0f, AttackAttribute.none, TwoHandedAttribute.none, SweepAttribute.none, ThrownWeaponAttribute.none, false), 0));

    public static void register(IEventBus eventBus) {
        assert (false);
        for (WeaponObject weapon : DixtasArmoryJsonConfig.WEAPONS) {
            if (weapon.weaponProperties.thwAttribute != null) {
                CONFIG_WEAPONS.add((RegistryObject<Item>)ITEMS.register(weapon.name, () -> new ThrowableItem(weapon.weaponProperties, weapon.index)));
                CONFIG_THROWABLES.add(CONFIG_WEAPONS.get(CONFIG_WEAPONS.size() - 1));
                continue;
            }
            CONFIG_WEAPONS.add((RegistryObject<Item>)ITEMS.register(weapon.name, () -> new AdvancedSwordItem(weapon.weaponProperties, weapon.index)));
        }
        for (WeaponObject weapon : DixtasArmoryJsonConfig.THD_COPIES) {
            CONFIG_THD_COPIES.add((RegistryObject<Item>)ITEMS.register(weapon.name, () -> new TwoHandedIWeapon(weapon.weaponProperties, weapon.index)));
        }
        ITEMS.register(eventBus);
    }
}

