/*
 * Decompiled with CFR 0.152.
 */
package net.dixta.dixtas_armory.item.custom;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.dixta.dixtas_armory.config.DixtasArmoryCommonConfig;
import net.dixta.dixtas_armory.item.ModDamageTypes;
import net.dixta.dixtas_armory.item.custom.TwoHandedIWeapon;
import net.dixta.dixtas_armory.item.custom.attributes.WeaponProperty;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.fml.ModList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdvancedSwordItem
extends SwordItem {
    public static UUID weaponRangeUUID = UUID.fromString("83a4286a-fdbb-4c91-b01a-64b3ddaec64e");
    public static UUID weaponKnockbackUUID = UUID.fromString("0627f79d-d31b-4d18-b645-25952e483585");
    public double pAttackRange;
    public double pAttackSpeed;
    public float pAttackDamage;
    public int copyIndex;
    boolean pIsTwoHanded;
    int pLevelTwoHanded;
    float pArmorPiercing;
    float pArmorPierceChance;
    float pSweepBoxX;
    float pSweepBoxY;
    float pSweepBoxZ;
    boolean pCanSweep;
    float pAttackKnockback;
    float pTwoHandedIDamage;
    float pTwoHandedIIDamage;
    float pTwoHandedISpeed;
    float pTwoHandedIISpeed;
    float pDamageSweep;
    float pUnarmoredDamage;
    int pInvincibilityTime;
    float pShieldCooldown;
    public Item pSwitchItem;
    Random random = new Random();
    Tier f_43306_;

    public AdvancedSwordItem(WeaponProperty pWeaponData, int pCopyIndex) {
        super(pWeaponData.tier, Math.round(pWeaponData.damage), pWeaponData.speed, pWeaponData.itemProperties);
        this.pAttackRange = pWeaponData.range - 3.0f;
        this.pAttackSpeed = pWeaponData.speed - 4.0f;
        this.pAttackDamage = pWeaponData.damage + pWeaponData.tier.m_6631_();
        this.copyIndex = pCopyIndex;
        this.pIsTwoHanded = pWeaponData.thdAttribute.level > 0;
        this.pLevelTwoHanded = pWeaponData.thdAttribute.level;
        this.pTwoHandedISpeed = (float)this.pAttackSpeed - pWeaponData.thdAttribute.minSpeed;
        this.pTwoHandedIISpeed = (float)this.pAttackSpeed - pWeaponData.thdAttribute.majSpeed;
        this.pTwoHandedIDamage = this.m_43299_() - (float)pWeaponData.thdAttribute.minDamage;
        this.pTwoHandedIIDamage = this.m_43299_() - (float)pWeaponData.thdAttribute.majDamage;
        this.pSwitchItem = pWeaponData.switchItem;
        this.pSweepBoxX = pWeaponData.swpAttribute.sweepRadiusX;
        this.pSweepBoxY = pWeaponData.swpAttribute.sweepRadiusX;
        this.pSweepBoxZ = pWeaponData.swpAttribute.sweepRadiusX;
        this.pCanSweep = pWeaponData.swpAttribute.canSweep;
        this.pDamageSweep = pWeaponData.swpAttribute.sweepDamage;
        this.pAttackKnockback = pWeaponData.atkAttribute.knockback;
        this.pArmorPierceChance = pWeaponData.atkAttribute.armorPiercingChance;
        this.pArmorPiercing = pWeaponData.atkAttribute.armorPiercingAmount;
        this.pUnarmoredDamage = pWeaponData.atkAttribute.unarmoredBonusDamage;
        this.pInvincibilityTime = pWeaponData.atkAttribute.invincibilityTime;
        this.pShieldCooldown = pWeaponData.atkAttribute.breachTime;
        this.f_43306_ = pWeaponData.tier;
    }

    public boolean canDisableShield(ItemStack stack, ItemStack shield, LivingEntity entity, LivingEntity attacker) {
        return false;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        if (slot == EquipmentSlot.MAINHAND) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Tool modifier", (double)this.findDamage(stack), AttributeModifier.Operation.ADDITION));
            builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Tool modifier", (double)this.findSpeed(stack), AttributeModifier.Operation.ADDITION));
            if (!ModList.get().isLoaded("bettercombat")) {
                builder.put((Object)((Attribute)ForgeMod.ENTITY_REACH.get()), (Object)new AttributeModifier(weaponRangeUUID, "Tool modifier", this.pAttackRange, AttributeModifier.Operation.ADDITION));
            }
            builder.put((Object)Attributes.f_22282_, (Object)new AttributeModifier(weaponKnockbackUUID, "Knockback modifier", (double)this.pAttackKnockback, AttributeModifier.Operation.ADDITION));
            return builder.build();
        }
        return super.getAttributeModifiers(slot, stack);
    }

    float findDamage(ItemStack stack) {
        int two_handed;
        try {
            two_handed = stack.m_41783_().m_128451_("dixtas_armory.two_handed");
        }
        catch (Exception e) {
            two_handed = -1;
        }
        return switch (two_handed) {
            case 1 -> this.pTwoHandedIDamage;
            case 2 -> this.pTwoHandedIIDamage;
            default -> (Boolean)DixtasArmoryCommonConfig.ROUND_WEAPON_DAMAGE.get() != false ? (float)Math.round(this.pAttackDamage) : this.pAttackDamage;
        };
    }

    float findSpeed(ItemStack stack) {
        int two_handed;
        try {
            two_handed = stack.m_41783_().m_128451_("dixtas_armory.two_handed");
        }
        catch (Exception e) {
            two_handed = -1;
        }
        return switch (two_handed) {
            case 1 -> this.pTwoHandedISpeed;
            case 2 -> this.pTwoHandedIISpeed;
            default -> (float)this.pAttackSpeed;
        };
    }

    @NotNull
    public AABB getSweepHitBox(@NotNull ItemStack stack, @NotNull Player player, @NotNull Entity target) {
        if (this.pDamageSweep == 0.0f) {
            return target.m_20191_().m_82377_(1.0 * (double)this.pSweepBoxX, 0.25 * (double)this.pSweepBoxY, 1.0 * (double)this.pSweepBoxZ);
        }
        for (LivingEntity livingentity : player.m_9236_().m_45976_(LivingEntity.class, target.m_20191_().m_82377_(1.0 * (double)this.pSweepBoxX, 0.25 * (double)this.pSweepBoxY, 1.0 * (double)this.pSweepBoxZ))) {
            double entityReachSq = Mth.m_144952_((double)player.getEntityReach());
            if (livingentity == player || livingentity == target || player.m_7307_((Entity)livingentity) || livingentity instanceof ArmorStand && ((ArmorStand)livingentity).m_31677_() || !(player.m_20280_((Entity)livingentity) < entityReachSq)) continue;
            livingentity.m_147240_((double)0.4f, (double)Mth.m_14031_((float)(player.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(player.m_146908_() * ((float)Math.PI / 180)))));
            livingentity.m_6469_(player.m_269291_().m_269075_(player), this.pDamageSweep);
        }
        return target.m_20191_().m_82377_(0.0, 0.0, 0.0);
    }

    public void m_6883_(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        if (ModList.get().isLoaded("bettercombat") && this.pLevelTwoHanded == 1 && pEntity instanceof Player) {
            Player p = (Player)pEntity;
            if (!(pLevel.f_46443_ || this instanceof TwoHandedIWeapon || this.pSwitchItem == null || p.m_21205_() != pStack || p.m_21206_().m_41720_() != Items.f_41852_ && !this.checkHeavy(p.m_21206_()))) {
                ItemStack pNew = new ItemStack((ItemLike)this.pSwitchItem);
                pNew.m_41751_(pStack.m_41783_());
                p.m_21008_(InteractionHand.MAIN_HAND, pNew);
            }
        }
        if (this.pLevelTwoHanded != 0) {
            this.twoHanded((LivingEntity)pEntity, pStack);
        }
        super.m_6883_(pStack, pLevel, pEntity, pSlotId, pIsSelected);
    }

    private void twoHanded(LivingEntity pPlayer, ItemStack pStack) {
        if (this.pIsTwoHanded) {
            pStack.m_41784_().m_128405_("dixtas_armory.two_handed", -1);
            if (pPlayer.m_21205_() == pStack && !pPlayer.m_21206_().m_41720_().equals(Items.f_41852_)) {
                if (this.pLevelTwoHanded == 2 || this.checkHeavy(pPlayer.m_21206_())) {
                    pStack.m_41784_().m_128405_("dixtas_armory.two_handed", 2);
                } else {
                    pStack.m_41784_().m_128405_("dixtas_armory.two_handed", 1);
                }
            } else if (pPlayer.m_21206_() == pStack && !pPlayer.m_21205_().m_41720_().equals(Items.f_41852_)) {
                if (this.pLevelTwoHanded == 2 || this.checkHeavy(pPlayer.m_21205_())) {
                    pStack.m_41784_().m_128405_("dixtas_armory.two_handed", 2);
                } else {
                    pStack.m_41784_().m_128405_("dixtas_armory.two_handed", 1);
                }
            }
        }
    }

    boolean isTwoHanded(ItemStack pStack) {
        try {
            int i = pStack.m_41783_().m_128451_("dixtas_armory.two_handed");
            return i != 0;
        }
        catch (Exception error) {
            return false;
        }
    }

    boolean stackHeavy(ItemStack pStack) {
        return pStack.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation(ModList.get().isLoaded("shieldexex") ? "dixtas_armory:two_handed_heavy_installed" : "dixtas_armory:two_handed_heavy")));
    }

    boolean checkHeavy(ItemStack pStack) {
        return this.isTwoHanded(pStack) || this.stackHeavy(pStack);
    }

    boolean noArmor(LivingEntity pEntity) {
        return !this.hasHelmet(pEntity) && !this.hasChestplate(pEntity) && !this.hasLeggings(pEntity) && !this.hasBoots(pEntity);
    }

    boolean hasHelmet(LivingEntity pEntity) {
        return pEntity.m_6844_(EquipmentSlot.HEAD).m_41720_() != Items.f_41852_;
    }

    boolean hasChestplate(LivingEntity pEntity) {
        return pEntity.m_6844_(EquipmentSlot.CHEST).m_41720_() != Items.f_41852_;
    }

    boolean hasLeggings(LivingEntity pEntity) {
        return pEntity.m_6844_(EquipmentSlot.LEGS).m_41720_() != Items.f_41852_;
    }

    boolean hasBoots(LivingEntity pEntity) {
        return pEntity.m_6844_(EquipmentSlot.FEET).m_41720_() != Items.f_41852_;
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        if (this.pArmorPiercing > 0.0f || this.pUnarmoredDamage > 0.0f) {
            boolean critical = player.m_36403_(0.5f) == 1.0f && player.f_19789_ > 0.0f && !player.m_20096_() && !player.m_6147_() && !player.m_20069_() && !player.m_21023_(MobEffects.f_19610_) && !player.m_20159_() && entity instanceof LivingEntity;
            critical = critical && !player.m_20142_();
            stack.m_41784_().m_128379_("dixtas_armory.attack.charged", (double)player.m_36403_(0.5f) > 0.9);
            stack.m_41784_().m_128379_("dixtas_armory.attack.crit", critical);
        }
        return super.onLeftClickEntity(stack, player, entity);
    }

    public boolean m_7579_(ItemStack pStack, LivingEntity pTarget, LivingEntity pAttacker) {
        DamageSource source = new DamageSource((Holder)pAttacker.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(ModDamageTypes.ARMOR_PIERCING));
        boolean charged = false;
        boolean crit = false;
        if (this.pArmorPiercing > 0.0f || this.pUnarmoredDamage > 0.0f) {
            assert (pStack.m_41783_() != null);
            charged = pStack.m_41783_().m_128471_("dixtas_armory.attack.charged");
            crit = pStack.m_41783_().m_128471_("dixtas_armory.attack.crit");
            pStack.m_41749_("dixtas_armory.attack.charged");
            pStack.m_41749_("dixtas_armory.attack.crit");
        }
        if (this.pArmorPiercing > 0.0f) {
            if (this.random.nextFloat() <= this.pArmorPierceChance && (charged || !(pAttacker instanceof Player))) {
                damage = this.pArmorPiercing;
                if (crit) {
                    damage = (float)((double)damage * 1.5);
                }
                pTarget.f_19802_ = 0;
                pTarget.m_6469_(source, damage);
            }
        } else if (this.pUnarmoredDamage > 0.0f && this.noArmor(pTarget) && charged) {
            damage = this.pUnarmoredDamage;
            if (crit) {
                damage = (float)((double)damage * 1.5);
            }
            pTarget.f_19802_ = 0;
            pTarget.m_6469_(pTarget.m_269291_().m_269075_((Player)pAttacker), damage);
        }
        pTarget.f_19802_ = this.pInvincibilityTime;
        boolean b = super.m_7579_(pStack, pTarget, pAttacker);
        return b;
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        if (this.pCanSweep) {
            return super.canPerformAction(stack, toolAction);
        }
        return false;
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        if (this.pIsTwoHanded) {
            int twoHanded;
            try {
                twoHanded = pStack.m_41783_().m_128451_("dixtas_armory.two_handed");
            }
            catch (Exception e) {
                twoHanded = -1;
            }
            if (twoHanded == 1) {
                pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.dixtas_armory.two_handed.1.blocked_light"));
            } else if (twoHanded == 2) {
                if (this.pLevelTwoHanded == 1) {
                    pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.dixtas_armory.two_handed.1.blocked"));
                } else {
                    pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.dixtas_armory.two_handed.2.blocked"));
                }
            } else if (this.pLevelTwoHanded == 1) {
                pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.dixtas_armory.two_handed.1"));
            } else {
                pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.dixtas_armory.two_handed.2"));
            }
            if (Screen.m_96638_()) {
                if (this.pLevelTwoHanded == 1) {
                    pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.dixtas_armory.two_handed.1.desc"));
                } else {
                    pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.dixtas_armory.two_handed.2.desc"));
                }
            }
        }
        if (!ModList.get().isLoaded("shieldexp") && this.pShieldCooldown > 0.0f) {
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.dixtas_armory.breach"));
            if (Screen.m_96638_()) {
                if (ModList.get().isLoaded("shieldexp")) {
                    pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.dixtas_armory.breach.desc.shieldexp", (Object[])new Object[]{Float.valueOf(this.pShieldCooldown)}).m_130940_(ChatFormatting.GRAY));
                } else {
                    pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.dixtas_armory.breach.desc.vanilla", (Object[])new Object[]{Float.valueOf(5.0f * this.pShieldCooldown)}).m_130940_(ChatFormatting.GRAY));
                }
            }
        }
        if (this.pInvincibilityTime != 20) {
            if (this.pInvincibilityTime < 20) {
                pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.dixtas_armory.quick_strike"));
                if (Screen.m_96638_()) {
                    pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.dixtas_armory.quick_strike.desc", (Object[])new Object[]{Float.valueOf((float)(this.pInvincibilityTime - 10) / 20.0f)}).m_130940_(ChatFormatting.GRAY));
                }
            } else {
                pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.dixtas_armory.slow_strike"));
                if (Screen.m_96638_()) {
                    pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.dixtas_armory.slow_strike.desc", (Object[])new Object[]{Float.valueOf((float)(this.pInvincibilityTime - 10) / 20.0f)}).m_130940_(ChatFormatting.GRAY));
                }
            }
        }
        if (this.pArmorPiercing > 0.0f) {
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.dixtas_armory.armor_piercing"));
            if (Screen.m_96638_()) {
                if (this.pArmorPierceChance == 0.0f || this.pArmorPierceChance == 1.0f) {
                    pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.dixtas_armory.armor_piercing.desc", (Object[])new Object[]{Float.valueOf(this.pArmorPiercing)}).m_130940_(ChatFormatting.GRAY));
                } else {
                    pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.dixtas_armory.armor_piercing.desc.chance", (Object[])new Object[]{(int)(this.pArmorPierceChance * 100.0f), "%", Float.valueOf(this.pArmorPiercing)}).m_130940_(ChatFormatting.GRAY));
                }
            }
        }
        if (this.pUnarmoredDamage > 0.0f) {
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.dixtas_armory.unarmored_bonus"));
            if (Screen.m_96638_()) {
                pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.dixtas_armory.unarmored_bonus.desc", (Object[])new Object[]{Float.valueOf(this.pUnarmoredDamage)}).m_130940_(ChatFormatting.GRAY));
            }
        }
        if (this.pCanSweep && (this.pDamageSweep != 0.0f && this.pDamageSweep != 1.0f || this.pSweepBoxX != 1.0f)) {
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.dixtas_armory.sweeping"));
            if (Screen.m_96638_()) {
                if (this.pDamageSweep != 0.0f && this.pDamageSweep != 1.0f) {
                    pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.dixtas_armory.sweeping_damage.desc", (Object[])new Object[]{Float.valueOf(this.pDamageSweep)}).m_130940_(ChatFormatting.GRAY));
                }
                if (this.pSweepBoxX != 1.0f) {
                    pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.dixtas_armory.sweeping_radius.desc", (Object[])new Object[]{Float.valueOf(this.pSweepBoxX)}).m_130940_(ChatFormatting.GRAY));
                }
            }
        }
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }
}

