/*
 * Decompiled with CFR 0.152.
 */
package net.dixta.dixtas_armory.item.custom;

import java.util.List;
import java.util.UUID;
import net.dixta.dixtas_armory.entity.ThrownWeaponEntity;
import net.dixta.dixtas_armory.item.custom.AdvancedSwordItem;
import net.dixta.dixtas_armory.item.custom.attributes.ThrownWeaponAttribute;
import net.dixta.dixtas_armory.item.custom.attributes.WeaponProperty;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ThrowableItem
extends AdvancedSwordItem
implements Vanishable {
    public float baseDamage;
    public float shootPower;
    public float throwInaccuracy;
    public int throwChargingTime;
    public float thrownWeight;
    public float waterInertia;
    public int defaultAmmo;
    public ThrownWeaponAttribute.ModelData modelData;

    public ThrowableItem(WeaponProperty pWeaponData, int pCopyIndex) {
        super(pWeaponData, pCopyIndex);
        this.baseDamage = pWeaponData.thwAttribute.thrownDamage;
        this.shootPower = pWeaponData.thwAttribute.throwForce;
        this.defaultAmmo = pWeaponData.thwAttribute.throwAmmo;
        this.thrownWeight = pWeaponData.thwAttribute.thrownWeight;
        this.throwInaccuracy = pWeaponData.thwAttribute.throwInaccuracy;
        this.throwChargingTime = pWeaponData.thwAttribute.throwChargingTime;
        this.waterInertia = pWeaponData.thwAttribute.waterInertia;
        this.modelData = pWeaponData.thwAttribute.modelData;
    }

    @Override
    public void m_6883_(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        this.initNbt(pStack);
        super.m_6883_(pStack, pLevel, pEntity, pSlotId, pIsSelected);
    }

    public void initNbt(ItemStack pStack) {
        try {
            if (pStack.m_41783_().m_128451_("dixtas_armory.throwable.ammo") == 0) {
                pStack.m_41784_().m_128405_("dixtas_armory.throwable.ammo", this.defaultAmmo);
            }
        }
        catch (Exception e) {
            pStack.m_41784_().m_128405_("dixtas_armory.throwable.ammo", this.defaultAmmo);
        }
        try {
            pStack.m_41784_().m_128342_("dixtas_armory.throwable.uuid");
        }
        catch (Exception e) {
            pStack.m_41784_().m_128362_("dixtas_armory.throwable.uuid", UUID.randomUUID());
        }
    }

    public int getAmmo(ItemStack pStack) {
        try {
            return pStack.m_41783_().m_128451_("dixtas_armory.throwable.ammo");
        }
        catch (Exception e) {
            return this.defaultAmmo;
        }
    }

    public void setAmmo(ItemStack pStack, int pValue) {
        int ammoToSet = pValue;
        if (ammoToSet > this.defaultAmmo) {
            ammoToSet = this.defaultAmmo;
        }
        if (ammoToSet < 1) {
            ammoToSet = 1;
        }
        pStack.m_41784_().m_128405_("dixtas_armory.throwable.ammo", ammoToSet);
    }

    public void increaseAmmo(ItemStack pStack) {
        this.setAmmo(pStack, this.getAmmo(pStack) + 1);
    }

    public UseAnim m_6164_(ItemStack pStack) {
        return this.modelData.useAnim;
    }

    public int m_8105_(ItemStack pStack) {
        return 72000;
    }

    public void m_5551_(ItemStack pStack, Level pLevel, LivingEntity pEntityLiving, int pTimeLeft) {
        int ammo = this.getAmmo(pStack);
        if (pEntityLiving instanceof Player) {
            int j;
            int i;
            Player player = (Player)pEntityLiving;
            if (ammo > 1 && (i = this.m_8105_(pStack) - pTimeLeft) >= this.throwChargingTime && ((j = EnchantmentHelper.m_44932_((ItemStack)pStack)) <= 0 || player.m_20070_())) {
                if (!pLevel.f_46443_) {
                    pStack.m_41622_(1, (LivingEntity)player, p_43388_ -> p_43388_.m_21190_(pEntityLiving.m_7655_()));
                    if (j == 0) {
                        ThrownWeaponEntity thrownweapon = new ThrownWeaponEntity(pLevel, (LivingEntity)player, pStack);
                        thrownweapon.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, this.shootPower + (float)j * 0.5f, this.throwInaccuracy);
                        if (player.m_150110_().f_35937_) {
                            thrownweapon.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                        }
                        pLevel.m_7967_((Entity)thrownweapon);
                        pLevel.m_6269_((Player)null, (Entity)thrownweapon, SoundEvents.f_12520_, SoundSource.PLAYERS, 1.0f, 1.0f);
                        if (!player.m_150110_().f_35937_) {
                            this.setAmmo(pStack, ammo - 1);
                        }
                    }
                }
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                if (j > 0) {
                    float f7 = player.m_146908_();
                    float f = player.m_146909_();
                    float f1 = -Mth.m_14031_((float)(f7 * ((float)Math.PI / 180))) * Mth.m_14089_((float)(f * ((float)Math.PI / 180)));
                    float f2 = -Mth.m_14031_((float)(f * ((float)Math.PI / 180)));
                    float f3 = Mth.m_14089_((float)(f7 * ((float)Math.PI / 180))) * Mth.m_14089_((float)(f * ((float)Math.PI / 180)));
                    float f4 = Mth.m_14116_((float)(f1 * f1 + f2 * f2 + f3 * f3));
                    float f5 = 3.0f * ((1.0f + (float)j) / 4.0f);
                    player.m_5997_((double)(f1 *= f5 / f4), (double)(f2 *= f5 / f4), (double)(f3 *= f5 / f4));
                    player.m_204079_(20);
                    if (player.m_20096_()) {
                        float f6 = 1.1999999f;
                        player.m_6478_(MoverType.SELF, new Vec3(0.0, 1.1999999284744263, 0.0));
                    }
                    SoundEvent soundevent = j >= 3 ? SoundEvents.f_12519_ : (j == 2 ? SoundEvents.f_12518_ : SoundEvents.f_12517_);
                    pLevel.m_6269_((Player)null, (Entity)player, soundevent, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            }
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        if (this.getAmmo(itemstack) <= 1) {
            return InteractionResultHolder.m_19098_((Object)itemstack);
        }
        if (itemstack.m_41773_() >= itemstack.m_41776_() - 1) {
            return InteractionResultHolder.m_19100_((Object)itemstack);
        }
        if (EnchantmentHelper.m_44932_((ItemStack)itemstack) > 0 && !pPlayer.m_20070_()) {
            return InteractionResultHolder.m_19100_((Object)itemstack);
        }
        pPlayer.m_6672_(pHand);
        return InteractionResultHolder.m_19096_((Object)itemstack);
    }

    public int m_6473_() {
        return 1;
    }

    @Override
    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        pTooltipComponents.add((Component)Component.m_237113_((String)("Ammo: " + (this.getAmmo(pStack) - 1) + "/" + (this.defaultAmmo - 1))));
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.dixtas_armory.throwable"));
        if (Screen.m_96638_()) {
            pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.dixtas_armory.throwable.desc.damage", (Object[])new Object[]{Float.valueOf(this.baseDamage)}).m_130940_(ChatFormatting.GRAY));
            pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.dixtas_armory.throwable.desc.force", (Object[])new Object[]{Float.valueOf(this.shootPower)}).m_130940_(ChatFormatting.GRAY));
            pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.dixtas_armory.throwable.desc.inaccuracy", (Object[])new Object[]{Float.valueOf(this.throwInaccuracy)}).m_130940_(ChatFormatting.GRAY));
            pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.dixtas_armory.throwable.desc.charging_time", (Object[])new Object[]{Float.valueOf((float)this.throwChargingTime / 20.0f)}).m_130940_(ChatFormatting.GRAY));
            pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.dixtas_armory.throwable.desc.weight", (Object[])new Object[]{Float.valueOf(this.thrownWeight)}).m_130940_(ChatFormatting.GRAY));
            pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.dixtas_armory.throwable.desc.water_inertia", (Object[])new Object[]{Float.valueOf(this.waterInertia)}).m_130940_(ChatFormatting.GRAY));
        }
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }
}

