/*
 * Decompiled with CFR 0.152.
 */
package com.barion.dungeons_enhanced.world.structure;

import com.barion.dungeons_enhanced.DEUtil;
import com.barion.dungeons_enhanced.registry.DEStructures;
import com.barion.dungeons_enhanced.world.gen.DETerrainAnalyzer;
import com.barion.dungeons_enhanced.world.structure.prefabs.DEBaseStructure;
import com.barion.dungeons_enhanced.world.structure.prefabs.DEGroundStructure;
import com.barion.dungeons_enhanced.world.structure.prefabs.utils.DEPieceAssembler;
import com.barion.dungeons_enhanced.world.structure.prefabs.utils.DEStructureTemplates;
import com.legacy.structure_gel.api.registry.registrar.Registrar;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public final class DEDesertTemple
extends DEGroundStructure {
    public static final String ID = "desert_temple";
    public static final Codec<DEDesertTemple> CODEC = DEDesertTemple.m_226607_(DEDesertTemple::new);
    private static final ResourceLocation BOTTOM = DEUtil.locate("desert_temple/down");

    public DEDesertTemple(Structure.StructureSettings structureSettings) {
        super(structureSettings, DEUtil.pieceBuilder().yOffset(-6).add("desert_temple/main").build(), () -> DEStructures.DESERT_TEMPLE.getType());
    }

    @Override
    @Nonnull
    public Optional<Structure.GenerationStub> m_214086_(@Nonnull Structure.GenerationContext context) {
        BlockPos rawPos = this.getGenPos(context.f_226628_());
        DEStructureTemplates.Template piece = this._templates.getRandom((RandomSource)context.f_226626_());
        Vec3i size = context.f_226625_().m_230359_(piece.Resource).m_163801_();
        if (!DETerrainAnalyzer.areNearbyBiomesValid(context.f_226623_(), rawPos, context.f_226622_(), 20, context.f_226630_(), context.f_226624_())) {
            return Optional.empty();
        }
        Pair<Float, Boolean> result = DETerrainAnalyzer.isFlatEnough(rawPos, size, 1, 6, context.f_226622_(), context.f_226629_(), context.f_226624_());
        BlockPos pos = rawPos.m_175288_(Math.round(((Float)result.getFirst()).floatValue())).m_6630_(piece.yOffset);
        return DEDesertTemple.at(pos, builder -> DEDesertTemple.generatePieces(builder, pos, piece, Rotation.NONE, context, DEDesertTemple::assembleTemple));
    }

    public static void assembleTemple(DEPieceAssembler.Context context) {
        BlockPos pos = context.pos();
        context.piecesBuilder().m_142679_((StructurePiece)new Piece(context.structureManager(), context.piece(), pos, context.rotation()));
        context.piecesBuilder().m_142679_((StructurePiece)new Piece(context.structureManager(), BOTTOM, pos.m_7918_(15, -11, 2), context.rotation()));
        context.piecesBuilder().m_142679_((StructurePiece)new Piece(context.structureManager(), BOTTOM, pos.m_7918_(25, -11, 16), context.rotation()));
        context.piecesBuilder().m_142679_((StructurePiece)new Piece(context.structureManager(), BOTTOM, pos.m_7918_(13, -11, 14), context.rotation()));
    }

    public static class Piece
    extends DEBaseStructure.Piece {
        public Piece(StructureTemplateManager structureManager, ResourceLocation templateName, BlockPos pos, Rotation rotation) {
            super((Registrar.Static<StructurePieceType>)DEStructures.DESERT_TEMPLE.getPieceType(), structureManager, templateName, pos, rotation);
        }

        public Piece(StructurePieceSerializationContext context, CompoundTag nbt) {
            super((Registrar.Static<StructurePieceType>)DEStructures.DESERT_TEMPLE.getPieceType(), context, nbt);
        }
    }
}

