/*
 * Decompiled with CFR 0.152.
 */
package com.lgow.endofherobrine.block;

import com.lgow.endofherobrine.block.TotemStates;
import com.lgow.endofherobrine.config.ConfigHandler;
import com.lgow.endofherobrine.entity.EntityInit;
import com.lgow.endofherobrine.entity.herobrine.boss.HerobrineBoss;
import com.lgow.endofherobrine.world.data.ModSavedData;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;

public class TotemBlock
extends Block {
    private static final EnumProperty<TotemStates> STATE = EnumProperty.m_61587_((String)"state", TotemStates.class);
    public final Block baseBlock;
    private final boolean isBlackstone;

    public TotemBlock(Block baseBlock) {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)baseBlock).m_60953_(blockState -> ((TotemStates)((Object)((Object)blockState.m_61143_(STATE)))).equals((Object)TotemStates.INACTIVE) ? 0 : 7).m_278166_(PushReaction.BLOCK));
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(STATE, (Comparable)((Object)TotemStates.INACTIVE)));
        this.baseBlock = baseBlock;
        this.isBlackstone = this.baseBlock.equals(Blocks.f_50730_);
    }

    private boolean isInTotem(BlockPos pos, ServerLevel level) {
        Block totemBase = this.isBlackstone ? Blocks.f_50090_ : Blocks.f_50074_;
        return level.m_45527_(pos.m_6630_(2)) && level.m_8055_(pos.m_7494_()).m_60713_(this.baseBlock) && level.m_8055_(pos.m_7495_()).m_60713_(totemBase) && level.m_8055_(pos.m_6625_(2)).m_60713_(totemBase);
    }

    private boolean isInAltar(BlockPos pos, ServerLevel level) {
        BlockPos below = pos.m_7495_();
        return !this.isBlackstone && level.m_45527_(pos.m_7494_()) && level.m_8055_(below).m_60713_(Blocks.f_50724_) && level.m_8055_(pos.m_7494_()).m_60713_(Blocks.f_50083_) && level.m_8055_(pos.m_122029_().m_122012_()).m_60713_(Blocks.f_50174_) && level.m_8055_(pos.m_122012_().m_122024_()).m_60713_(Blocks.f_50174_) && level.m_8055_(pos.m_122024_().m_122019_()).m_60713_(Blocks.f_50174_) && level.m_8055_(pos.m_122019_().m_122029_()).m_60713_(Blocks.f_50174_) && level.m_8055_(below.m_122029_()).m_60713_(Blocks.f_50074_) && level.m_8055_(below.m_122029_().m_122012_()).m_60713_(Blocks.f_50074_) && level.m_8055_(below.m_122012_()).m_60713_(Blocks.f_50074_) && level.m_8055_(below.m_122012_().m_122024_()).m_60713_(Blocks.f_50074_) && level.m_8055_(below.m_122024_()).m_60713_(Blocks.f_50074_) && level.m_8055_(below.m_122024_().m_122019_()).m_60713_(Blocks.f_50074_) && level.m_8055_(below.m_122019_()).m_60713_(Blocks.f_50074_) && level.m_8055_(below.m_122019_().m_122029_()).m_60713_(Blocks.f_50074_);
    }

    private void activate(ServerLevel serverLevel, BlockPos pos, BlockState state) {
        if (!ConfigHandler.enabledExperimentalFeatures()) {
            serverLevel.m_7654_().m_6846_().m_240416_((Component)Component.m_237113_((String)"The current bossfights are merely placeholders. To summon them you have to enable experimental features.").m_130940_(ChatFormatting.RED), false);
        } else {
            LightningBolt lightningBolt = (LightningBolt)EntityType.f_20465_.m_20615_((Level)serverLevel);
            lightningBolt.m_6034_((double)pos.m_123341_(), (double)pos.m_6630_(2).m_123342_(), (double)pos.m_123343_());
            serverLevel.m_7967_((Entity)lightningBolt);
            serverLevel.m_7731_(pos, (BlockState)state.m_61124_(STATE, (Comparable)((Object)TotemStates.ACTIVE)), 2);
            this.checkSpawn(serverLevel, pos);
        }
    }

    private void overcharge(ServerLevel serverLevel, BlockPos pos, BlockState state) {
        if (!ConfigHandler.enabledExperimentalFeatures()) {
            serverLevel.m_7654_().m_6846_().m_240416_((Component)Component.m_237113_((String)"Apocalypse Mode is an experimental feature").m_130940_(ChatFormatting.RED), false);
        }
        serverLevel.m_7731_(pos, (BlockState)state.m_61124_(STATE, (Comparable)((Object)TotemStates.OVERCHARGED)), 2);
        ModSavedData.get(serverLevel.m_7654_()).setApocalypseMode(true);
    }

    private boolean canActivateNetherrackTotem(BlockState state, ServerLevel serverLevel, BlockPos pos) {
        return !this.isBlackstone && ((TotemStates)((Object)state.m_61143_(STATE))).equals((Object)TotemStates.INACTIVE) && this.isInTotem(pos, serverLevel) && !ModSavedData.get(serverLevel.m_7654_()).hasDefeatedHerobrine();
    }

    private boolean canActivateBlackstoneTotem(BlockState state, ServerLevel serverLevel, BlockPos pos) {
        ModSavedData levelData = ModSavedData.get(serverLevel.m_7654_());
        return ((TotemStates)((Object)state.m_61143_(STATE))).equals((Object)TotemStates.INACTIVE) && this.isInTotem(pos, serverLevel) && levelData.hasDefeatedHerobrine() && !levelData.isHerobrineDeadOrResting();
    }

    private boolean canActivateAltar(BlockState state, ServerLevel serverLevel, BlockPos pos) {
        return !this.isBlackstone && ((TotemStates)((Object)state.m_61143_(STATE))).equals((Object)TotemStates.INACTIVE) && this.isInAltar(pos, serverLevel) && ModSavedData.get(serverLevel.m_7654_()).herobrineIsDead();
    }

    private void checkSpawn(ServerLevel server, BlockPos pPos) {
        if (pPos.m_123342_() >= server.m_141937_()) {
            HerobrineBoss herobrineBoss = (HerobrineBoss)((EntityType)EntityInit.HEROBRINE_BOSS.get()).m_20615_((Level)server);
            if (this.isBlackstone) {
                herobrineBoss.setEnraged(true);
            }
            herobrineBoss.m_7678_((double)pPos.m_123341_() + 0.5, pPos.m_6630_(3).m_123342_(), (double)pPos.m_123343_() + 0.5, 0.0f, 0.0f);
            for (ServerPlayer serverplayer : server.m_45976_(ServerPlayer.class, herobrineBoss.m_20191_().m_82400_(50.0))) {
                CriteriaTriggers.f_10580_.m_68256_(serverplayer, (Entity)herobrineBoss);
            }
            server.m_7967_((Entity)herobrineBoss);
        }
    }

    private void broasdcastMessage(ServerLevel server, String component, int bound) {
        if (!this.isBlackstone && !ModSavedData.get(server.m_7654_()).isHerobrineDeadOrResting() && ConfigHandler.enabledExperimentalFeatures()) {
            server.m_7654_().m_6846_().m_240416_((Component)Component.m_237113_((String)"<Herobrine> ").m_7220_((Component)Component.m_237115_((String)("totem." + component + new Random().nextInt(bound)))), false);
        }
    }

    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, @Nullable LivingEntity pPlacer, ItemStack pStack) {
        if (pLevel instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)pLevel;
            if (this.canActivateNetherrackTotem(pState, server, pPos)) {
                this.activate(server, pPos, pState);
            } else if (this.isInAltar(pPos, server)) {
                this.overcharge(server, pPos, pState);
            }
            this.broasdcastMessage(server, "placed", 2);
        }
        super.m_6402_(pLevel, pPos, pState, pPlacer, pStack);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            if (((TotemStates)((Object)state.m_61143_(STATE))).equals((Object)TotemStates.INACTIVE) && !this.isBlackstone) {
                if (server.m_46471_()) {
                    server.m_8606_(0, 6000, true, true);
                }
                level.m_5594_(null, player.m_20183_(), SoundEvents.f_12090_, SoundSource.BLOCKS, 1.0f, (float)((double)0.8f + Math.random() * 0.2));
                this.broasdcastMessage(server, "broken", 3);
            }
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (pLevel instanceof ServerLevel) {
            ItemStack itemstack;
            ServerLevel server = (ServerLevel)pLevel;
            if (this.isBlackstone && (itemstack = pPlayer.m_21120_(pHand)).m_150930_(Items.f_42686_) && this.canActivateBlackstoneTotem(pState, server, pPos)) {
                if (!pPlayer.m_7500_() && ConfigHandler.enabledExperimentalFeatures()) {
                    itemstack.m_41774_(1);
                }
                server.m_5594_(null, pPlayer.m_20183_(), SoundEvents.f_11859_, SoundSource.BLOCKS, 1.0f, (float)((double)0.8f + Math.random() * 0.2));
                this.activate(server, pPos, pState);
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6227_(pState, pLevel, pPos, pPlayer, pHand, pHit);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor accessor, BlockPos pos, BlockPos facingPos) {
        if (accessor instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)accessor;
            if (this.canActivateNetherrackTotem(state, serverLevel, pos)) {
                this.activate(serverLevel, pos, state);
            } else if (this.canActivateAltar(state, serverLevel, pos)) {
                this.overcharge(serverLevel, pos, state);
            }
        }
        return super.m_7417_(state, facing, facingState, accessor, pos, facingPos);
    }

    public void m_7742_(BlockState pState, LevelAccessor pLevel, BlockPos pPos, int pFlags, int pRecursionLeft) {
        ServerLevel serverLevel;
        if (pLevel instanceof ServerLevel && this.canActivateAltar(pState, serverLevel = (ServerLevel)pLevel, pPos)) {
            this.overcharge(serverLevel, pPos, pState);
        }
        super.m_7742_(pState, pLevel, pPos, pFlags, pRecursionLeft);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{STATE});
    }
}

