/*
 * Decompiled with CFR 0.152.
 */
package com.lgow.endofherobrine.client.layer;

import com.lgow.endofherobrine.config.EOHClient;
import com.lgow.endofherobrine.util.ModResourceLocation;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class WhiteEyesLayer<T extends PathfinderMob, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    private final String resLoc;
    private final boolean alwaysRender;

    public WhiteEyesLayer(RenderLayerParent<T, M> rendererIn, String textureLoc) {
        this(rendererIn, textureLoc, false);
    }

    public WhiteEyesLayer(RenderLayerParent<T, M> rendererIn, String textureLoc, boolean alwaysRender) {
        super(rendererIn);
        this.resLoc = "textures/entity/layer/" + textureLoc;
        this.alwaysRender = alwaysRender;
    }

    public WhiteEyesLayer(RenderLayerParent<T, M> rendererIn) {
        this(rendererIn, "", false);
    }

    public String getEyeTexture(T entity) {
        return this.resLoc;
    }

    public RenderType getRenderType(T entity) {
        if (EOHClient.shouldEyesGlow()) {
            return RenderType.m_110488_((ResourceLocation)new ModResourceLocation(this.getEyeTexture(entity)));
        }
        return RenderType.m_110458_((ResourceLocation)new ModResourceLocation(this.getEyeTexture(entity)));
    }

    private boolean shouldRender(T entity) {
        return entity.m_9236_().m_45930_(entity, 40.0) != null || entity.m_5912_() || this.alwaysRender;
    }

    public void render(PoseStack poseStack, MultiBufferSource source, int lightIn, T entity, float swing, float swingAmount, float parTicks, float age, float headYaw, float headPitch) {
        float f = 1.0f;
        VertexConsumer vertex = source.m_6299_(this.getRenderType(entity));
        if (this.shouldRender(entity)) {
            this.m_117386_().m_7695_(poseStack, vertex, lightIn, OverlayTexture.f_118083_, f, f, f, f);
        }
    }
}

