/*
 * Decompiled with CFR 0.152.
 */
package com.lgow.endofherobrine.entity;

import com.lgow.endofherobrine.config.ConfigHandler;
import com.lgow.endofherobrine.entity.PossessedMob;
import com.lgow.endofherobrine.entity.ai.neutral.DefendPassiveMobsGoal;
import com.lgow.endofherobrine.entity.ai.neutral.PosAnimalPanicGoal;
import com.lgow.endofherobrine.entity.ai.neutral.PosAnimalTargetGoal;
import com.lgow.endofherobrine.entity.ai.neutral.PosAnimalWalkAroundGoal;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;

public interface PossessedAnimal
extends PossessedMob,
NeutralMob {
    @Override
    default public boolean canRevertPossession() {
        return this.getPossessionTimer() >= ConfigHandler.getRemainPossessedTicks() && !this.m_21660_();
    }

    default public void addPossessionSavedData(CompoundTag pCompound, int possessionTimer) {
        pCompound.m_128405_("PossessionTimer", possessionTimer);
    }

    default public void readPossessionSaveData(CompoundTag pCompound) {
        this.setPossessionTimer(pCompound.m_128451_("PossessionTimer"));
    }

    public void setPossessionTimer(int var1);

    public int getPossessionTimer();

    default public void registerPosAnimalGoals(PathfinderMob mob, double speed) {
        this.registerPosAnimalGoals(mob, speed, speed);
    }

    default public void registerPosAnimalGoals(PathfinderMob mob, double attackSpeed, double panicSpeed) {
        this.registerPosMobGoals(mob, false, attackSpeed);
        mob.f_21345_.m_25352_(3, (Goal)new PosAnimalPanicGoal(mob, panicSpeed));
        mob.f_21345_.m_25352_(5, (Goal)new PosAnimalWalkAroundGoal(mob, 1.0));
        mob.f_21346_.m_25352_(0, (Goal)new DefendPassiveMobsGoal((Mob)mob));
        mob.f_21346_.m_25352_(1, new PosAnimalTargetGoal<Player>((Mob)mob, Player.class));
        mob.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal(mob, new Class[]{Monster.class}).m_26044_(new Class[0]));
    }
}

