/*
 * Decompiled with CFR 0.152.
 */
package com.lgow.endofherobrine.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public interface Teleporter {
    default public boolean checkSafePos(LivingEntity entity, BlockPos.MutableBlockPos mutablePos, boolean avoidWater) {
        BlockState blockstate = entity.m_9236_().m_8055_((BlockPos)mutablePos);
        boolean blocksMotion = blockstate.m_280555_();
        boolean posSafe = avoidWater ? blocksMotion : blocksMotion || blockstate.m_60819_().m_205070_(FluidTags.f_13131_);
        return mutablePos.m_123342_() > entity.m_9236_().m_141937_() && !posSafe;
    }

    default public boolean willHaveSightOfTarget(LivingEntity chaser, BlockPos.MutableBlockPos mutablePos, LivingEntity target) {
        Vec3 pVec;
        Vec3 mVec = new Vec3((double)mutablePos.m_123341_(), (double)((float)mutablePos.m_123342_() + chaser.m_20192_()), (double)mutablePos.m_123343_());
        if (mVec.m_82554_(pVec = new Vec3(target.m_20185_(), target.m_20188_(), target.m_20189_())) <= 128.0 && !target.m_5833_()) {
            return chaser.m_9236_().m_45547_(new ClipContext(mVec, pVec, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)chaser)).m_6662_() == HitResult.Type.MISS;
        }
        return false;
    }

    default public boolean attemptTeleport(LivingEntity teleporter, double x, double y, double z, LivingEntity target, boolean avoidWater) {
        boolean avoidFluid;
        boolean isLurking;
        boolean safePos;
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos(x, y, z);
        while (this.checkSafePos(teleporter, mutablePos, avoidWater)) {
            mutablePos.m_122173_(Direction.DOWN);
        }
        BlockState blockstate = teleporter.m_9236_().m_8055_((BlockPos)mutablePos);
        boolean bl = safePos = blockstate.m_280555_() || !avoidWater && blockstate.m_60819_().m_205070_(FluidTags.f_13131_);
        if (avoidWater && blockstate.m_60819_().m_205070_(FluidTags.f_13131_)) {
            return false;
        }
        boolean bl2 = isLurking = target == null || this.willHaveSightOfTarget(teleporter, mutablePos, target);
        boolean bl3 = avoidWater ? !blockstate.m_60819_().m_76178_() : (avoidFluid = blockstate.m_60819_().m_205070_(FluidTags.f_13132_));
        if (safePos && !avoidFluid && isLurking) {
            boolean canTeleport = this.randomTeleport(teleporter, x, y, z, avoidWater);
            if (canTeleport && !teleporter.m_20067_()) {
                teleporter.m_9236_().m_6263_(null, teleporter.f_19854_, teleporter.f_19855_, teleporter.f_19856_, SoundEvents.f_11852_, teleporter.m_5720_(), 1.0f, 1.0f);
                teleporter.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
            }
            return canTeleport;
        }
        return false;
    }

    default public boolean attemptTeleport(LivingEntity entity, double x, double y, double z) {
        return this.attemptTeleport(entity, x, y, z, null, false);
    }

    default public boolean randomTeleport(LivingEntity entity, double pX, double pY, double pZ, boolean avoidWater) {
        double d0 = entity.m_20185_();
        double d1 = entity.m_20186_();
        double d2 = entity.m_20189_();
        double d3 = pY;
        boolean flag = false;
        BlockPos.MutableBlockPos blockpos = new BlockPos.MutableBlockPos(pX, pY, pZ);
        Level level = entity.m_9236_();
        if (level.m_46805_((BlockPos)blockpos)) {
            boolean hasChunk = false;
            while (!hasChunk && blockpos.m_123342_() > level.m_141937_()) {
                BlockPos below = blockpos.m_7495_();
                BlockState blockstate = level.m_8055_(below);
                if (blockstate.m_280555_() || !avoidWater && blockstate.m_60819_().m_205070_(FluidTags.f_13131_)) {
                    hasChunk = true;
                    continue;
                }
                d3 -= 1.0;
                blockpos = below;
            }
            if (hasChunk) {
                entity.m_6021_(pX, d3, pZ);
                if (level.m_45786_((Entity)entity)) {
                    flag = true;
                }
            }
        }
        if (!flag) {
            entity.m_6021_(d0, d1, d2);
            return false;
        }
        level.m_7605_((Entity)entity, (byte)46);
        if (entity instanceof PathfinderMob) {
            PathfinderMob mob = (PathfinderMob)entity;
            mob.m_21573_().m_26573_();
        }
        return true;
    }

    default public boolean teleportInFrontOf(LivingEntity chaser, LivingEntity target) {
        if (!chaser.m_9236_().f_46443_ && target != null) {
            Vec3 targetPos = target.m_20182_();
            Vec3 chaserPos = chaser.m_20182_();
            Vec3 dir = targetPos.m_82546_(chaserPos);
            dir = dir.m_82541_();
            dir = dir.m_82559_(new Vec3(-1.5, -1.5, -1.5));
            dir = targetPos.m_82549_(dir);
            return this.attemptTeleport(chaser, dir.f_82479_, target.m_20186_(), dir.f_82481_);
        }
        return false;
    }

    default public boolean teleportBehindOf(LivingEntity chaser, LivingEntity target) {
        if (!chaser.m_9236_().f_46443_ && target != null) {
            Vec3 targetPos = target.m_20182_();
            Vec3 chaserPos = chaser.m_20182_();
            Vec3 dir = targetPos.m_82546_(chaserPos);
            dir = dir.m_82541_();
            dir = dir.m_82559_(new Vec3(1.5, 1.0, 1.5));
            dir = targetPos.m_82549_(dir);
            return this.attemptTeleport(chaser, dir.f_82479_, target.m_20186_(), dir.f_82481_);
        }
        return false;
    }
}

