/*
 * Decompiled with CFR 0.152.
 */
package com.lgow.endofherobrine.entity.herobrine;

import com.lgow.endofherobrine.entity.herobrine.AbstractHerobrine;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Lurker
extends AbstractHerobrine {
    private static final EntityDataAccessor<Boolean> IS_ANGRY = SynchedEntityData.m_135353_(Lurker.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int lastLurkedTimer;
    private int watchedPlayerTimer;
    private int playSoundCooldown;

    public Lurker(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21346_.m_25352_(0, (Goal)new LurkerTargetGoal(this));
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        if (!this.canSeeAnyPlayers()) {
            this.tpToWatchPlayer(this.getNearestPlayer());
        }
        this.resetTpCooldown();
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    private void resetTpCooldown() {
        this.teleportCooldown = 60;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_ANGRY, (Object)false);
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("IsAngry", this.getAngry());
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setAngry(pCompound.m_128471_("IsAngry"));
    }

    private void warnPlayer() {
        if (this.canSeeAnyPlayers() && this.getTargetPlayer() != null) {
            if (this.f_19796_.m_188503_(3) == 0 && this.playSoundCooldown <= 0) {
                this.m_9236_().m_5594_(null, this.getTargetPlayer().m_20183_(), (SoundEvent)SoundEvents.f_11689_.get(), SoundSource.HOSTILE, 0.5f, (float)((double)0.8f + Math.random() * 0.2));
                this.playSoundCooldown = 4000;
            } else {
                this.playSoundCooldown = 600;
            }
        }
    }

    private void tooCloseToPlayer() {
        if (!this.m_9236_().f_46443_ && this.getNearestPlayer() != null && this.m_20270_((Entity)this.getNearestPlayer()) <= 5.0f && !this.getAngry()) {
            this.teleportAway();
        }
    }

    private void lurkPlayer() {
        if (this.teleportCooldown <= 0 && this.lastLurkedTimer > 60 && this.tpToWatchPlayer(this.getNearestPlayer())) {
            this.resetTpCooldown();
        }
    }

    private void leave() {
        if (this.canSeeAnyPlayers()) {
            this.lastLurkedTimer = 0;
            if (this.watchedPlayerTimer > 4000) {
                this.teleportAway();
            } else {
                ++this.watchedPlayerTimer;
            }
        } else if (this.lastLurkedTimer > 600) {
            this.teleportAway();
        } else {
            ++this.lastLurkedTimer;
        }
    }

    @Override
    public void m_8024_() {
        --this.playSoundCooldown;
        --this.teleportCooldown;
        this.leave();
        this.tooCloseToPlayer();
        this.warnPlayer();
        this.lurkPlayer();
        super.m_8024_();
    }

    public boolean m_7327_(Entity entityIn) {
        boolean hurtTarget = super.m_7327_(entityIn);
        if (hurtTarget && entityIn instanceof Player) {
            Player player = (Player)entityIn;
            player.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 150, 1, false, false));
            player.m_7292_(new MobEffectInstance(MobEffects.f_216964_, 150, 1, false, false));
            this.m_9236_().m_7785_(player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)SoundEvents.f_11689_.get(), SoundSource.HOSTILE, 0.5f, (float)((double)0.8f + Math.random() * 0.2), false);
            this.m_146870_();
        }
        return hurtTarget;
    }

    public boolean isBeingLookedAtBy(Player pPlayer) {
        Vec3 vec3 = pPlayer.m_20252_(1.0f).m_82541_();
        Vec3 vec31 = new Vec3(this.m_20185_() - pPlayer.m_20185_(), this.m_20188_() - pPlayer.m_20188_(), this.m_20189_() - pPlayer.m_20189_());
        double d0 = vec31.m_82553_();
        double d1 = vec3.m_82526_(vec31 = vec31.m_82541_());
        return d1 > 1.0 - 0.025 / d0 && pPlayer.m_142582_((Entity)this);
    }

    private boolean getAngry() {
        return (Boolean)this.f_19804_.m_135370_(IS_ANGRY);
    }

    private void setAngry(boolean isAngry) {
        this.f_19804_.m_135381_(IS_ANGRY, (Object)isAngry);
    }

    private static class LurkerTargetGoal
    extends NearestAttackableTargetGoal<Player> {
        private final Lurker lurker;
        private final TargetingConditions startAggroTargetConditions;
        private final TargetingConditions continueAggroTargetConditions = TargetingConditions.m_148352_().m_148355_();
        @Nullable
        private Player pendingTarget;
        private int aggroTime;

        public LurkerTargetGoal(Lurker lurker) {
            super((Mob)lurker, Player.class, false);
            this.lurker = lurker;
            this.startAggroTargetConditions = TargetingConditions.m_148352_().m_26883_(this.m_7623_()).m_26888_(livingEntity -> lurker.isBeingLookedAtBy((Player)livingEntity));
        }

        public boolean m_8036_() {
            this.pendingTarget = this.lurker.m_9236_().m_45946_(this.startAggroTargetConditions, (LivingEntity)this.lurker);
            return this.pendingTarget != null;
        }

        public void m_8056_() {
            super.m_8056_();
        }

        public boolean m_8045_() {
            if (this.pendingTarget != null) {
                if (!this.lurker.isBeingLookedAtBy(this.pendingTarget)) {
                    return false;
                }
                this.lurker.m_21391_((Entity)this.pendingTarget, 10.0f, 10.0f);
                return true;
            }
            return this.f_26050_ != null && this.continueAggroTargetConditions.m_26885_((LivingEntity)this.lurker, this.f_26050_) || super.m_8045_();
        }

        public void m_8041_() {
            this.pendingTarget = null;
            super.m_8041_();
        }

        public void m_8037_() {
            if (this.lurker.m_5448_() == null) {
                super.m_26070_(null);
            }
            if (this.pendingTarget != null) {
                if (--this.aggroTime <= 0) {
                    this.f_26050_ = this.pendingTarget;
                    this.pendingTarget = null;
                    super.m_8056_();
                }
            } else {
                if (this.f_26050_ != null && this.f_26050_.m_20280_((Entity)this.lurker) > 6.0 && this.lurker.teleportCooldown <= 0 && (this.lurker.teleportInFrontOf((LivingEntity)this.lurker, this.f_26050_) || this.lurker.teleportBehindOf((LivingEntity)this.lurker, this.f_26050_))) {
                    this.lurker.resetTpCooldown();
                }
                this.lurker.setAngry(true);
                super.m_8037_();
            }
        }
    }
}

