/*
 * Decompiled with CFR 0.152.
 */
package com.lgow.endofherobrine.entity.herobrine.boss;

import com.lgow.endofherobrine.entity.herobrine.AbstractHerobrine;
import com.lgow.endofherobrine.item.ItemInit;
import com.lgow.endofherobrine.world.data.ModSavedData;
import java.util.EnumSet;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.WitherSkull;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class HerobrineBoss
extends AbstractHerobrine
implements RangedAttackMob {
    private static final EntityDataAccessor<Integer> DATA_ID_INV = SynchedEntityData.m_135353_(HerobrineBoss.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> IS_ENRAGED = SynchedEntityData.m_135353_(HerobrineBoss.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final Predicate<LivingEntity> LIVING_ENTITY_SELECTOR = livingEntity -> livingEntity.m_6336_() != MobType.f_21641_ && livingEntity.m_5789_();
    private final ServerBossEvent bossEvent = (ServerBossEvent)new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.BLUE, BossEvent.BossBarOverlay.PROGRESS).m_7003_(true);
    private boolean hasbeencriiticalHit;

    public HerobrineBoss(EntityType<? extends HerobrineBoss> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 10, false);
        this.m_21153_(this.m_21233_());
        this.m_20331_(false);
        this.f_21364_ = 50;
    }

    @Deprecated
    public static boolean canDestroy(BlockState pState) {
        return !pState.m_60795_() && !pState.m_204336_(BlockTags.f_13070_);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 45.0).m_22268_(Attributes.f_22279_, 1.5).m_22268_(Attributes.f_22280_, (double)1.8f).m_22268_(Attributes.f_22277_, 40.0).m_22268_(Attributes.f_22284_, 4.0);
    }

    @Override
    public boolean m_6673_(DamageSource pSource) {
        return !(pSource.m_7639_() instanceof Player);
    }

    protected PathNavigation m_6037_(Level pLevel) {
        FlyingPathNavigation flyingpathnavigation = new FlyingPathNavigation((Mob)this, pLevel);
        flyingpathnavigation.m_26440_(true);
        flyingpathnavigation.m_7008_(true);
        flyingpathnavigation.m_26443_(true);
        return flyingpathnavigation;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ID_INV, (Object)0);
        this.f_19804_.m_135372_(IS_ENRAGED, (Object)false);
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("Invul", this.getInvulnerableTicks());
        pCompound.m_128379_("IsEnraged", this.isEnraged());
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setInvulnerableTicks(pCompound.m_128451_("Invul"));
        this.setEnraged(pCompound.m_128471_("IsEnraged"));
    }

    protected void m_7472_(DamageSource pSource, int pLooting, boolean pRecentlyHit) {
        if (!this.isEnraged()) {
            super.m_7472_(pSource, pLooting, pRecentlyHit);
        } else {
            ItemEntity itementity = this.m_19998_((ItemLike)ItemInit.HEROBRINE_HEAD_ITEM.get());
            if (itementity != null) {
                itementity.m_32064_();
            }
        }
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new ChargeUpGoal());
        this.f_21345_.m_25352_(0, (Goal)new WaterAvoidingRandomFlyingGoal((PathfinderMob)this, 40.0));
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(3, (Goal)new RangedAttackGoal((RangedAttackMob)this, 1.0, 40, 20.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 0, false, false, LIVING_ENTITY_SELECTOR));
    }

    @Override
    public void m_8024_() {
        if (this.getInvulnerableTicks() > 0) {
            int k1 = this.getInvulnerableTicks() - 1;
            this.bossEvent.m_142711_(1.0f - (float)k1 / 220.0f);
            if (k1 <= 0) {
                this.m_9236_().m_254849_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 7.0f, Level.ExplosionInteraction.MOB);
                if (!this.m_20067_()) {
                    this.m_9236_().m_6798_(1023, this.m_20183_(), 0);
                }
            }
            this.setInvulnerableTicks(k1);
            if (this.f_19797_ % 10 == 0) {
                this.m_5634_(10.0f);
            }
        } else {
            super.m_8024_();
            if (this.f_19797_ % 200 == 0) {
                this.m_5634_(1.0f);
            }
            this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
        }
    }

    private boolean isEnraged() {
        return (Boolean)this.f_19804_.m_135370_(IS_ENRAGED);
    }

    public void setEnraged(boolean isEnraged) {
        this.f_19804_.m_135381_(IS_ENRAGED, (Object)isEnraged);
        if (isEnraged) {
            this.m_147215_(new MobEffectInstance(MobEffects.f_19605_, 400, 1, false, false), null);
            this.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 6000, 0, false, false));
            this.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 6000, 0, false, false));
            this.m_7292_(new MobEffectInstance(MobEffects.f_19617_, 2400, 3, false, false));
            this.m_255207_(Items.f_42480_.m_7968_());
            this.m_255207_(Items.f_42481_.m_7968_());
            this.m_255207_(Items.f_42482_.m_7968_());
            this.m_255207_(Items.f_42483_.m_7968_());
            this.m_255207_(Items.f_42393_.m_7968_());
            this.m_255207_(Items.f_42740_.m_7968_());
        } else {
            this.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 100, 1, false, false));
            this.m_7292_(new MobEffectInstance(MobEffects.f_19617_, 2400, 0, false, false));
        }
    }

    public void m_8107_() {
        Vec3 vec3 = this.m_20184_().m_82542_(1.0, 0.6, 1.0);
        this.m_20256_(vec3);
        if (vec3.m_165925_() > 0.05) {
            this.m_146922_((float)Mth.m_14136_((double)vec3.f_82481_, (double)vec3.f_82479_) * 57.295776f - 90.0f);
        }
        super.m_8107_();
        if (this.getInvulnerableTicks() > 0) {
            for (int i1 = 0; i1 < 3; ++i1) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123811_, this.m_20185_() + this.f_19796_.m_188583_(), this.m_20186_() + (double)(this.f_19796_.m_188501_() * 3.3f), this.m_20189_() + this.f_19796_.m_188583_(), (double)0.7f, (double)0.7f, (double)0.9f);
            }
        }
    }

    public void makeInvulnerable() {
        this.bossEvent.m_142711_(0.0f);
        this.m_21153_(this.m_21233_() / 3.0f);
    }

    private double getHeadX(int pHead) {
        if (pHead <= 0) {
            return this.m_20185_();
        }
        float f = (this.f_20883_ + (float)(180 * (pHead - 1))) * ((float)Math.PI / 180);
        float f1 = Mth.m_14089_((float)f);
        return this.m_20185_() + (double)f1 * 1.3;
    }

    private double getHeadY(int pHead) {
        return pHead <= 0 ? this.m_20186_() + 3.0 : this.m_20186_() + 2.2;
    }

    private double getHeadZ(int pHead) {
        if (pHead <= 0) {
            return this.m_20189_();
        }
        float f = (this.f_20883_ + (float)(180 * (pHead - 1))) * ((float)Math.PI / 180);
        float f1 = Mth.m_14031_((float)f);
        return this.m_20189_() + (double)f1 * 1.3;
    }

    private void performRangedAttack(int pHead, LivingEntity pTarget) {
        this.performRangedAttack(pHead, pTarget.m_20185_(), pTarget.m_20186_() + (double)pTarget.m_20192_() * 0.5, pTarget.m_20189_(), pHead == 0 && this.f_19796_.m_188501_() < 0.001f);
    }

    private void performRangedAttack(int pHead, double pX, double pY, double pZ, boolean pIsDangerous) {
        if (!this.m_20067_()) {
            this.m_9236_().m_5898_(null, 1024, this.m_20183_(), 0);
        }
        double d0 = this.getHeadX(pHead);
        double d1 = this.getHeadY(pHead);
        double d2 = this.getHeadZ(pHead);
        double d3 = pX - d0;
        double d4 = pY - d1;
        double d5 = pZ - d2;
        WitherSkull witherskull = new WitherSkull(this.m_9236_(), (LivingEntity)this, d3, d4, d5);
        witherskull.m_5602_((Entity)this);
        if (pIsDangerous) {
            witherskull.m_37629_(true);
        }
        witherskull.m_20343_(d0, d1, d2);
        this.m_9236_().m_7967_((Entity)witherskull);
    }

    public void m_6504_(LivingEntity pTarget, float pDistanceFactor) {
        this.performRangedAttack(0, pTarget);
    }

    public boolean m_147207_(MobEffectInstance pEffectInstance, @Nullable Entity pEntity) {
        return false;
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (this.m_6673_(pSource)) {
            return false;
        }
        if (!this.isEnraged() && this.m_21223_() < pAmount && this.m_21223_() > 1.0f) {
            boolean b = super.m_6469_(pSource, Math.max(this.m_21223_() - 1.0f, 0.0f));
            if (this.hasbeencriiticalHit) {
                this.m_20194_().m_6846_().m_240416_((Component)Component.m_237113_((String)"<Herobrine> ").m_7220_((Component)Component.m_237115_((String)"herobrine.death_1")), false);
                ModSavedData data = ModSavedData.get(this.m_9236_().m_7654_());
                data.setHasDefeatedHerobrine(true);
                data.setHerobrineRestTimer(12000);
                super.m_6469_(pSource, pAmount);
                this.teleportAway();
            } else {
                this.hasbeencriiticalHit = true;
            }
            return b;
        }
        if (!pSource.m_269533_(DamageTypeTags.f_268581_) && !(pSource.m_7639_() instanceof HerobrineBoss)) {
            if (this.getInvulnerableTicks() > 0 && !pSource.m_276093_(DamageTypes.f_286973_)) {
                return false;
            }
            Entity entity1 = pSource.m_7639_();
            if (!(entity1 instanceof Player) && entity1 instanceof LivingEntity && ((LivingEntity)entity1).m_6336_() == this.m_6336_()) {
                return false;
            }
            return super.m_6469_(pSource, pAmount);
        }
        return false;
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, DamageSource pSource) {
        return false;
    }

    public int getInvulnerableTicks() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_INV);
    }

    public void setInvulnerableTicks(int pInvulnerableTicks) {
        this.f_19804_.m_135381_(DATA_ID_INV, (Object)pInvulnerableTicks);
    }

    protected boolean m_7341_(Entity pEntity) {
        return false;
    }

    public boolean m_6072_() {
        return false;
    }

    public void m_6593_(@Nullable Component pName) {
        super.m_6593_(pName);
        this.bossEvent.m_6456_(this.m_5446_());
    }

    public void m_6457_(ServerPlayer pPlayer) {
        super.m_6457_(pPlayer);
        this.bossEvent.m_6543_(pPlayer);
    }

    public void m_6452_(ServerPlayer pPlayer) {
        super.m_6452_(pPlayer);
        this.bossEvent.m_6539_(pPlayer);
    }

    protected void m_6668_(DamageSource pDamageSource) {
        if (!this.m_9236_().m_5776_() && this.isEnraged()) {
            ModSavedData.get(this.m_9236_().m_7654_()).setHerobrineIsDead(true);
        }
        super.m_6668_(pDamageSource);
    }

    class ChargeUpGoal
    extends Goal {
        public ChargeUpGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return HerobrineBoss.this.getInvulnerableTicks() > 0;
        }
    }
}

