/*
 * Decompiled with CFR 0.152.
 */
package com.lgow.endofherobrine.entity.possessed;

import com.lgow.endofherobrine.block.GlowingObsidianBlock;
import com.lgow.endofherobrine.block.ModInfestedBlock;
import com.lgow.endofherobrine.entity.ModMobTypes;
import com.lgow.endofherobrine.entity.PossessedMob;
import com.lgow.endofherobrine.entity.Teleporter;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Silverfish;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.ForgeEventFactory;

public class PosSilverfish
extends Silverfish
implements Teleporter,
PossessedMob {
    private SummonPosSilverfishGoal summonPosSilverfish;

    public PosSilverfish(EntityType<? extends PosSilverfish> type, Level level) {
        super(type, level);
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 8.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22277_, 40.0).m_22268_(Attributes.f_22281_, 1.0);
    }

    protected ResourceLocation m_7582_() {
        return new ResourceLocation("entities/silverfish");
    }

    public boolean m_7327_(Entity target) {
        Player player;
        if (target instanceof Player && (player = (Player)target).m_21223_() > 1.0f) {
            boolean hasTpPos;
            while (!(hasTpPos = this.checkTeleportPos(player))) {
            }
        }
        return super.m_7327_(target);
    }

    protected void m_8099_() {
        this.registerPosMonsterGoals((PathfinderMob)this, false);
        this.summonPosSilverfish = new SummonPosSilverfishGoal(this);
        this.f_21345_.m_25352_(0, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(2, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)this.summonPosSilverfish);
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(0, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    protected SoundEvent m_7515_() {
        return null;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.summonPosSilverfish != null) {
            this.summonPosSilverfish.notifyHurt();
        }
        return super.m_6469_(source, amount);
    }

    public MobType m_6336_() {
        return ModMobTypes.POSSESSED;
    }

    protected boolean checkTeleportPos(Player player) {
        if (!player.m_9236_().f_46443_ && player.m_6084_()) {
            double d0 = player.m_20185_() + ((double)this.f_19796_.m_188503_(800) - 400.5);
            double d1 = player.m_20186_() + (double)(this.f_19796_.m_188503_(64) + 12);
            double d2 = player.m_20189_() + ((double)this.f_19796_.m_188503_(800) - 400.5);
            return this.attemptTeleport((LivingEntity)player, d0, d1, d2);
        }
        return false;
    }

    public void onAddedToWorld() {
        List list = this.m_9236_().m_45976_(PosSilverfish.class, this.m_20191_().m_82400_(30.0));
        if (this.summonPosSilverfish != null && list.size() == 1) {
            this.summonPosSilverfish.notifyHurt();
        }
        super.onAddedToWorld();
    }

    protected void m_6668_(DamageSource source) {
        if (this.summonPosSilverfish != null) {
            this.summonPosSilverfish.notifyHurt();
        }
        super.m_6668_(source);
    }

    public static class SummonPosSilverfishGoal
    extends Goal {
        private final PosSilverfish silverfish;
        private int lookForFriends;

        public SummonPosSilverfishGoal(PosSilverfish silverfish) {
            this.silverfish = silverfish;
        }

        public void notifyHurt() {
            if (this.lookForFriends == 0) {
                this.lookForFriends = this.m_183277_(20);
            }
        }

        public boolean m_8036_() {
            return this.lookForFriends > 0;
        }

        public void m_8037_() {
            --this.lookForFriends;
            if (this.lookForFriends <= 0) {
                Level level = this.silverfish.m_9236_();
                RandomSource randomsource = this.silverfish.m_217043_();
                BlockPos blockpos = this.silverfish.m_20183_();
                int i = 0;
                while (i <= 5 && i >= -5) {
                    int j = 0;
                    while (j <= 10 && j >= -10) {
                        int k = 0;
                        while (k <= 10 && k >= -10) {
                            GlowingObsidianBlock gobs;
                            BlockPos blockpos1 = blockpos.m_7918_(j, i, k);
                            BlockState blockstate = level.m_8055_(blockpos1);
                            Block block = blockstate.m_60734_();
                            if (block instanceof GlowingObsidianBlock && !(gobs = (GlowingObsidianBlock)block).isInfested(blockstate)) {
                                return;
                            }
                            if (block instanceof ModInfestedBlock) {
                                if (ForgeEventFactory.getMobGriefingEvent((Level)level, (Entity)this.silverfish)) {
                                    level.m_46953_(blockpos1, true, (Entity)this.silverfish);
                                }
                                if (randomsource.m_188499_()) {
                                    return;
                                }
                            }
                            k = (k <= 0 ? 1 : 0) - k;
                        }
                        j = (j <= 0 ? 1 : 0) - j;
                    }
                    i = (i <= 0 ? 1 : 0) - i;
                }
            }
        }
    }
}

