/*
 * Decompiled with CFR 0.152.
 */
package com.lgow.endofherobrine.event;

import com.lgow.endofherobrine.capability.CapabilityProvider;
import com.lgow.endofherobrine.capability.Wrath;
import com.lgow.endofherobrine.util.ModResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="endofherobrine")
public class CapabilityEvents {
    @SubscribeEvent
    public static void onAttachCapabilitiesPlayer(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player) {
            event.addCapability((ResourceLocation)new ModResourceLocation("capabilities"), (ICapabilityProvider)new CapabilityProvider());
        }
    }

    @SubscribeEvent
    public static void onJoinWorldSyncCap(EntityJoinLevelEvent event) {
        Entity entity;
        if (!event.getLevel().m_5776_() && (entity = event.getEntity()) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            serverPlayer.getCapability(CapabilityProvider.WRATH).ifPresent(clan -> clan.syncValue(serverPlayer));
        }
    }

    @SubscribeEvent
    public static void onPlayerCloned(PlayerEvent.Clone event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer newPlayer = (ServerPlayer)player;
            player = event.getOriginal();
            if (player instanceof ServerPlayer) {
                ServerPlayer original = (ServerPlayer)player;
                event.getOriginal().reviveCaps();
                original.getCapability(CapabilityProvider.WRATH).ifPresent(oldCap -> newPlayer.getCapability(CapabilityProvider.WRATH).ifPresent(newCap -> newCap.copyFrom((Wrath)oldCap, newPlayer)));
            }
        }
    }
}

