/*
 * Decompiled with CFR 0.152.
 */
package com.lgow.endofherobrine.event;

import com.lgow.endofherobrine.capability.CapabilityProvider;
import com.lgow.endofherobrine.config.ConfigHandler;
import com.lgow.endofherobrine.enchantment.EnchantmentInit;
import com.lgow.endofherobrine.util.ModResourceLocation;
import com.lgow.endofherobrine.world.data.ModSavedData;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.Advancement;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Score;
import net.minecraft.world.scores.criteria.ObjectiveCriteria;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="endofherobrine")
public class WrathHandler {
    private static Score getScore(ServerLevel level, String player) {
        ServerScoreboard scoreboard = level.m_6188_();
        return scoreboard.m_83471_(player, scoreboard.m_83477_("Wrath"));
    }

    private static int getTotalDestruction(ServerLevel level) {
        AtomicInteger totalWrath = new AtomicInteger();
        for (ServerPlayer player : level.m_7654_().m_6846_().m_11314_()) {
            if (!player.m_6084_()) continue;
            player.getCapability(CapabilityProvider.WRATH).ifPresent(wrath -> totalWrath.addAndGet(wrath.getValue()));
        }
        return totalWrath.get();
    }

    public static int getHerobrinesWrath(ServerLevel level) {
        ModSavedData data = ModSavedData.get(level.m_7654_());
        if (data.isApocalypseMode()) {
            return 100;
        }
        if (data.isHerobrineDeadOrResting()) {
            return 0;
        }
        int maxWrath = data.hasDefeatedHerobrine() ? 70 : 40;
        return Math.min(WrathHandler.getTotalDestruction(level) / 40, maxWrath);
    }

    public static boolean probability(ServerLevel level, float weight) {
        ModSavedData savedData = ModSavedData.get(level.m_7654_());
        return savedData.isApocalypseMode() || (float)RandomSource.m_216327_().m_188503_(100) <= (float)WrathHandler.getHerobrinesWrath(level) * weight;
    }

    private void increasePlayerDestruction(ServerPlayer player, int value) {
        ModSavedData savedData = ModSavedData.get(player.m_20194_());
        if (!savedData.isHerobrineDeadOrResting() && ConfigHandler.isWrathProgressive()) {
            player.getCapability(CapabilityProvider.WRATH).ifPresent(wrath -> wrath.addValue(value, player));
        }
    }

    @SubscribeEvent
    public void onBlockBreakScore(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.increasePlayerDestruction(serverPlayer, 1);
        }
    }

    @SubscribeEvent
    public void onBlockPlaceScore(BlockEvent.EntityPlaceEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            this.increasePlayerDestruction(serverPlayer, 1);
        }
    }

    @SubscribeEvent
    public void onMobKillScore(LivingDeathEvent event) {
        ServerPlayer player;
        Player entity;
        LivingEntity target = event.getEntity();
        Object object = entity = target.f_20889_ <= 0 ? target.f_20888_ : event.getSource().m_7639_();
        if (entity instanceof ServerPlayer && !(player = (ServerPlayer)entity).m_21205_().getAllEnchantments().containsKey(EnchantmentInit.BLESSING.get())) {
            this.increasePlayerDestruction(player, target.m_6095_().m_20674_().m_21609_() ? 4 : 2);
        }
    }

    @SubscribeEvent
    public void onTickScoreboards(TickEvent.LevelTickEvent event) {
        Level level = event.level;
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            for (ServerPlayer player : server.m_7654_().m_6846_().m_11314_()) {
                Score score = WrathHandler.getScore(server, player.m_7755_().getString());
                if (player.m_6084_()) {
                    player.getCapability(CapabilityProvider.WRATH).ifPresent(wrath -> score.m_83402_(wrath.getValue()));
                    continue;
                }
                score.m_83402_(0);
            }
            WrathHandler.getScore(server, "Wrath %").m_83402_(WrathHandler.getHerobrinesWrath(server));
            WrathHandler.getScore(server, "Total").m_83402_(WrathHandler.getTotalDestruction(server));
        }
    }

    @SubscribeEvent
    public void wrathAdvancement(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.getCapability(CapabilityProvider.WRATH).ifPresent(wrath -> {
                if (wrath.getValue() >= 1) {
                    Advancement advancement = serverPlayer.m_20194_().m_129889_().m_136041_((ResourceLocation)new ModResourceLocation("story/root"));
                    for (String s : serverPlayer.m_8960_().m_135996_(advancement).m_8219_()) {
                        serverPlayer.m_8960_().m_135988_(advancement, s);
                    }
                }
            });
        }
    }

    @SubscribeEvent
    public void decreaseHerobrineRestTimer(TickEvent.ServerTickEvent event) {
        ModSavedData data = ModSavedData.get(event.getServer());
        if (data.getHerobrineRestTimer() > 0) {
            data.setHerobrineRestTimer(data.getHerobrineRestTimer() - 1);
        }
    }

    @SubscribeEvent
    public void reformatScoreboardObjective(LevelEvent.Load event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)levelAccessor;
            if (server.m_6188_().m_83477_("Wrath") == null) {
                server.m_6188_().m_83436_("Wrath", ObjectiveCriteria.f_83588_, (Component)Component.m_237113_((String)"Wrath").m_130940_(ChatFormatting.AQUA), ObjectiveCriteria.RenderType.INTEGER);
            } else {
                server.m_6188_().m_83477_("Wrath").m_83316_((Component)Component.m_237113_((String)"Wrath").m_130940_(ChatFormatting.AQUA));
            }
            if (server.m_6188_().m_83489_("Wrath %") == null) {
                PlayerTeam wrathTeam = server.m_6188_().m_83492_("Wrath %");
                wrathTeam.m_83351_(ChatFormatting.RED);
                wrathTeam.m_6809_().add("Wrath %");
            }
            if (server.m_6188_().m_83489_("Total") == null) {
                PlayerTeam totalTeam = server.m_6188_().m_83492_("Total");
                totalTeam.m_83351_(ChatFormatting.YELLOW);
                totalTeam.m_6809_().add("Total");
            }
        }
    }
}

